<?php if(!defined('KLAY_PATH')) die('no-access');

$routes = [];

$routes['/'] = function($klay){
    if(!getDogscCount()) createSomeDogs();
    $klay->render_view(KLAY_PATH.'/views/page', [ 'subview'=>'home' ]);
};

$routes['/dogs'] = function($klay){
    $dogs = $klay->db('dog')->all();
    $klay->render_view(KLAY_PATH.'/views/page', [ 'subview'=>'dogs', 'subview_data'=>['dogs'=>$dogs] ]);
};

$routes['/about'] = function($klay){
    $klay->render_view(KLAY_PATH.'/views/page', [ 'subview'=>'about' ]);
};

$routes['/docs'] = function($klay){
    $klay->render_view(KLAY_PATH.'/views/page', [ 'title'=>'Docs' ]);
};

$routes['/api'] = function($klay){
    $klay->output(200, [
        'api_robot_says' => '🤖 Hi, this is an API endpoint. I was created in routes.php',
        'other_endpoints' => [
            'api/dogs' => 'http://localhost:2147/api/dogs',
        ],
        'random_dog' => randomDog(), 
        'time' => showTime(),
    ]);
};

$routes['/api/dogs'] = function($klay){
    $dogs = $klay->db('dog')->all();
    if(empty($dogs)) $klay->output(404, [ 'msg' => 'No dogs found, go to /admin and create one a couple?' ]);
    $klay->output(200, [ 'dogs' => $dogs ]);
};

$routes['random-dog'] = function($klay){
    $klay->output(200, [ 'random_dog' => randomDog(), 'time' => showTime() ]);
};

$routes['404'] = function($klay){
    $klay->render_view(KLAY_PATH.'/views/page', [ 'subview'=>'error404' ]);
};

return $routes;