<?php class Klay {public$version, $buildno, $config, $display_errors, $log_errors, $base_url, $content_path, $admin_url, $max_upload_mb, $max_upload_mb_img, $max_upload_mb_video, $mkdir_chmod, $routes, $controllers, $login_disabled, $view_path, $admin_css, $admin_js, $langstrings, $logged_in, $permissions, $html_cache_enabled, $cms_config, $has_sqlite_json_support, $http_input, $latest_webhook_response, $sql_queries, $dbe, $found_db_tablenames, $filters, $is_404,$events, $json_pretty, $auto_fetch_relations, $content_url, $active_route, $route_params, $active_controller;private $logged_in_user, $logins;function __construct( $config=NULL ){$this->version='1.3.2';$this->buildno=1430;if(!defined('KLAY_PATH')) die('no-access');$this->checkSystemRequirements(FALSE);if(empty($config)) $config=[];$config=(object) $config;if(is_file('.env')||isset($config->env)) {$this->load_env_file(isset($config->env)?$config->env:'.env');$config=$this->config_load_env_vars($config);}if(!isset($config->display_errors)) $config->display_errors=(ini_get('display_errors')||ini_get('display_warnings'));if(!isset($config->log_errors)) $config->log_errors=(ini_get('error_log')&&(ini_get('log_errors')||ini_get('log_warnings')));$this->display_errors=$config->display_errors;$this->log_errors=$config->log_errors;if($this->display_errors) { ini_set('display_errors', 1); ini_set('display_warnings', 1); error_reporting(E_ALL); } else { ini_set('display_errors', 0); ini_set('display_warnings', 0); error_reporting(0); }if($this->log_errors) { ini_set('log_errors', 1); ini_set('error_log', $this->log_errors); }set_error_handler([$this, 'error_handler']);set_exception_handler([$this, 'exception_handler']);$config=$this->loadPlugins($config);$this->config=$config;if(empty($config->base_url)) trigger_error('Missing config: base_url', E_USER_ERROR);$this->base_url=$config->base_url;$GLOBALS['klay']=$this;if(isset($config->routes)) $this->routes=$this->parseConfigInput_routes($config->routes);if(isset($config->controllers)) $this->controllers=$config->controllers;if(isset($config->filters)) $this->filters=$config->filters;if(isset($config->events)) $this->events=$config->events;$this->json_pretty=isset($config->json_pretty) ? $config->json_pretty : TRUE;$this->mkdir_chmod=isset($config->mkdir_chmod) ? $config->mkdir_chmod : 0777;$this->http_input=$this->get_input();$this->auto_fetch_relations=isset($config->auto_fetch_relations) ? $config->auto_fetch_relations : FALSE;$this->logins=isset($config->logins) ? $config->logins : [];if(isset($config->login)) $this->logins[]=$config->login;$this->logins=array_map(function($x) { return (object) $x; }, $this->logins);if(!empty($config->login_disabled)) {$this->login_disabled=$config->login_disabled;setcookie('t836724', 'login-disabled', time()+60*60*24*30, '/', );}if(isset($config->content_url)) $this->content_url=$config->content_url;if(empty($this->content_url)) $this->content_url=$config->base_url.'/content';if(isset($config->content_path)) $this->content_path=$config->content_path;if(empty($this->content_path)) $this->content_path='content';$this->view_path=isset($config->view_path) ? $config->view_path : '';if(!empty($config->admin_css)) $this->admin_css=$config->admin_css;if(!empty($config->admin_js)) $this->admin_js=$config->admin_js;$this->langstrings=$this->get_langstrings();if(!empty($config->admin_languages)) foreach($config->admin_languages as $key => $path) $this->add_langstrings($key,$path);$this->logged_in_user=$this->getLoggedInUser();$this->logged_in=!empty($this->logged_in_user);$this->permissions=isset($this->logged_in_user->permissions) ? explode('|',$this->logged_in_user->permissions) : [];if($this->login_disabled) $this->permissions=['anything'];$this->cms_config=$this->db_config_load();$this->html_cache_enabled=( isset($this->cms_config->html_cache_enabled)&&$this->cms_config->html_cache_enabled==='on' );if(!empty($this->config->blocks))$this->aa2ao($this->config->blocks);if(!empty($this->config->item_schemas)) $this->aa2ao($this->config->item_schemas);if(!empty($this->config->blocks))foreach($this->config->blocks as $x)$x->from_php=TRUE;if(!empty($this->config->item_schemas)) foreach($this->config->item_schemas as $x) $x->from_php=TRUE;if(!empty($this->config->blocks))$this->cms_config=$this->merge_obj((object)[ 'blocks'=>$this->config->blocks ], $this->cms_config);if(!empty($this->config->item_schemas)) $this->cms_config=$this->merge_obj((object)[ 'item_schemas'=>$this->config->item_schemas ], $this->cms_config);$this->parseAssetCustomFieldsSchema();$this->has_sqlite_json_support=defined('SQLITE3_DETERMINISTIC');if(!isset($this->config->autorun) || $this->isTrue($this->config->autorun)) $this->run();}public function run(){if(!empty($this->http_input->api_endpoint)) $this->handle_api_requests($this->http_input->api_endpoint);if(isset($this->config->show_admin)&&$this->config->show_admin===TRUE ) $this->render_admin();if(isset($this->config->admin_url)&&$this->is_route_path($this->config->admin_url)) $this->render_admin();if(isset($this->routes)) $this->handle_routes();}public function checkSystemRequirements( $forceOutput=TRUE ){$errors=[]; $warnings=[]; $ok=[];$php_v=PHP_VERSION; $php_plz='7.0.0';$php_ok=version_compare($php_v, $php_plz, '>=');if($php_ok) { $ok[]='PHP '.$php_plz; } else { $errors[]="PHP $php_plz is required and $php_v was detected."; }if(extension_loaded('sqlite3')) { $ok[]='Sqlite3'; } else { $errors[]='Sqlite is required.'; }if(extension_loaded('gd')) { $ok[]='GD extension'; } else { $errors[]='GD extension is required to handle images.'; }if(defined('SQLITE3_DETERMINISTIC')) { $ok[]='SQLite JSON functions'; } else { $warnings[]='SQLite JSON Functions not found. Your SQLite version/installation might not meet recommendations. Klay will run with db query JSON functions disabled.'; }$str='Checking system requirements...<br><br>';foreach($ok as $x) $str .= '✅ Checked: '.$x.'<br>';foreach($errors as $x) $str .= '⛔ Error: '.$x.'<br>';foreach($warnings as $x) $str .= '⚠️ Warning: '.$x.'<br>';if(!empty($errors) || !empty($warnings)) $str .= '<br><br>Please ask your server technician to update the server to meet technical requirements.';if($forceOutput || !empty($errors)) $this->dd($str);}public function parseConfigInput_routes($routes) {foreach($routes as $x => &$y) if(is_string($y)&&strpos($y,'::') !== FALSE ) $y=explode('::',$y)[1];return $routes;}public function parseAssetCustomFieldsSchema(){if(empty($this->cms_config->item_schemas))return;$asset_custom_fields_schema=array_values(array_filter($this->cms_config->item_schemas,function($x){ return ($x->name==='asset'); }));$this->cms_config->asset_custom_fields_schema=empty($asset_custom_fields_schema[0]->fields) ? [] : $asset_custom_fields_schema[0]->fields;$this->cms_config->item_schemas=array_values(array_filter($this->cms_config->item_schemas,function($x){ return ($x->name !== 'asset'); }));}public function getLoggedInUser(){$this->db_validate_table_structure('cms_tokens');if(!empty($this->login_disabled)) return true;if(empty($this->logins)) return false;if(empty($_COOKIE['t836724'])) return false;$x=$this->db('cms_tokens')->where('token',$_COOKIE['t836724'])->one();if(empty($x)||empty($x->username)) return false;$tokened_username=$x->username;foreach($this->logins as $user){$valid=$user->username==$tokened_username;if($valid) return $user;}return false;}public function getLoggedInUserSanitized(){$u=$this->getLoggedInUser();if(isset($u->password)) unset($u->password);if(isset($u->hint)) unset($u->hint);return $u;}public function userCan($x){if(empty($this->permissions)) return false;if(in_array('anything', $this->permissions)&&!in_array('!'.$x, $this->permissions)) return true;return in_array($x, $this->permissions);}public function get( $type='any', $uid=null ){$is_any=( $type=='any' || $type=='all' );$find_uid=!empty($uid);if($is_any&&$find_uid ) {$item=$this->db_get_item('any', $uid);if(empty($item))return;$output=$item;}if(!$is_any&&$find_uid ) {$item=$this->db_get_item($type, $uid);if(empty($item))return;$output=$item;}if(empty($uid)&&$type=='asset' ) $output=$this->db_get_items('asset');if(!$is_any&&!$find_uid&&$type !== 'asset' ) $output=$this->db_get_items($type);if(!$find_uid&&$type=='cms_config' ) return $this->cms_config;if($is_any&&!$find_uid ) {$output=(object) [];foreach( $this->cms_config->item_schemas as $schema ) $output->{$schema->name}=$this->db_get_items($schema->name);$output->asset=$this->db_get_items('asset');$output->cms_config=$this->cms_config;}if($this->auto_fetch_relations&&$type!='asset') $output=$this->fetch_relations($output);return $output;}public function get_by_slug($type, $slug, $lang=NULL){$item=$this->db_get_item_by_slug($type, $slug, $lang);if(empty($item))return;if($this->auto_fetch_relations&&$type!='asset') $item=$this->fetch_relations($item);return $item;}public function get_where($type, $where=[]){$items=$this->db_get_items_where($type,$where);if($this->auto_fetch_relations&&$type!='asset') $items=$this->fetch_relations($items);return $items;}function fetch_relations($data){if(is_callable($data)) return $data;if(empty($data)) return $data;if(is_object($data)&&isset($data->uid)&&(empty($data->created_at)&&empty($data->updated_at))) {$type='any';if(isset($data->type)) $type=$data->type;if(isset($data->dominant_color)||isset($data->dominant_color)||isset($data->filesize)||isset($data->format)) $type='asset';$item=$this->db_get_item($type, $data->uid);if(!empty($item)) $data=(object) array_merge( (array) $data, (array) $item);if($type=='asset') $data->files=$this->asset_load_files($data->uid);if($type=='asset') $data->size=$this->asset_load_size($data->uid);}if(is_object($data) || is_array($data)) {foreach( $data as $k => &$v ) {$v=$this->fetch_relations($v);}}return $data;}public function get_translations($type, $item){$object=(object) [];if(empty($item->language_grouping)) return $object;$items=$this->db($type)->where('language_grouping',$item->language_grouping)->all();foreach($items as $item) $object->{$item->language}=$item;return $object;}public function get_translation($type, $item, $langcode){$translations=$this->get_translations($type, $item);if(empty($translations))return;if(empty($translations->{$langcode}))return;return $translations->{$langcode};}public function get_languages(){if(empty($this->cms_config->languages)) return [];return $this->cms_config->languages;}public function get_primary_language(){$languages=$this->get_languages();foreach( $languages as $l ) if(isset($l->primary)&&$this->isTrue($l->primary)) return $l;}public function handle_api_requests($endpoint){$allowed_public=['login'];if(!$this->logged_in&&!in_array($endpoint, $allowed_public)) $this->output(401, [ 'status'=>'error', 'error'=>'Not allowed' ]);$method_name='api__'.$endpoint;$input=$this->http_input;$found=method_exists($this, $method_name);if($found) $this->{$method_name}($input);if(!$found) $this->output(404, [ 'status'=>'error', 'error'=>'no such API endpoint', ]);}public function api__login($input){if(empty($input->u)) $this->output_missing_param('u');if(empty($input->p)) $this->output_missing_param('p');foreach($this->logins as $login) {if($input->u !== $login->username ) continue;$verified=( $input->u===$login->username&&$input->p===$login->password );if(!$verified) continue;$this->db_validate_table_structure('cms_tokens');$token=$this->makeUid(36);$saved=$this->db_save_item('cms_tokens', (object)[ 'username'=>$login->username, 'token'=>$token, 'created_at'=>date('Y-m-d H:i:s') ]);if(!$saved) $this->output(500, [ 'status'=>'error', 'error'=>'could not save token' ]);setcookie('t836724', $token, time()+60*60*24*30, '/', );$this->output(200, [ 'status'=>'success', 'token'=>$token, ]);}$output=[ 'status'=>'unauthorized', ];foreach($this->logins as $login) if($login->username===$input->u ) $output['hint']=$login->hint;$this->output(401, $output);}/*public function api__asset_upload($input){$file=$_FILES['file'];$asset=json_decode($_POST['asset']);$r=$this->save_asset($file, $asset);$done=(isset($r->status)&&$r->status=='success');if(!$done) $this->output(500, $r);$this->output(200, $r);}*/public function api__fetch_content($input){if(empty($input->type)) $this->output_missing_param('type');$columns=isset($input->columns) ? $input->columns : '*';$limit=isset($input->limit) ? $input->limit : NULL;$offset=isset($input->offset) ? $input->offset : NULL;$order=isset($input->order) ? $input->order : 'created_at DESC';$q=[ 'columns'=>$columns, 'order'=>$order, 'limit'=>$limit, 'offset'=>$offset ];if(isset($input->uid)) { $q['where']=[ 'uid'=>$input->uid ]; $q['limit']=1; $q['first']=TRUE; }if(isset($input->search)){$q['where_sql']='WHERE TITLE LIKE :x OR TAGS LIKE :x';$q['params']=[ [':x','%'.$input->search.'%'], ];}if(isset($input->tagged)){$q['where_sql']='WHERE TAGS LIKE :x';$q['params']=[ [':x','%'.$input->tagged.'%'], ];if($input->tagged=='only-empty'){$q['where_sql']='WHERE tags IS NULL OR tags=\'\'';$q['params']=[];}}if($input->type=='cms_config' ) {$data=$this->cms_config;}if($input->type=='asset' ) {$data=$this->db_get('asset', $q);}if($input->type !== 'cms_config'&&$input->type !== 'asset' ) {$data=$this->db_get($input->type, $q);}if(empty($data)) $this->output(404, (object) [ 'status'=>'error', 'error'=>'content-not-found' ]);$this->output(200, (object) [ 'status'=>'success', 'data'=>$data ]);}public function api__fetch_content_tags($input){$tags=[];if(isset($input->type)) {$data=$this->db_get($input->type, [ 'columns'=>'uid,tags', ]);foreach($data as $item) { if(empty($item->tags)) { continue; } $itemtags=explode(',', $item->tags); foreach($itemtags as $itemtag) $tags[]=trim($itemtag); }}if(empty($input->type)) {$item_schemas=$this->cms_config->item_schemas;foreach( $item_schemas as $x ) {$data=$this->db_get($x->name, [ 'columns'=>'uid,tags', ]);foreach($data as $item) { if(empty($item->tags)) { continue; } $itemtags=explode(',', $item->tags); foreach($itemtags as $itemtag) $tags[]=trim($itemtag); }}}$tags=array_values(array_filter(array_unique($tags)));$this->output(200, (object) [ 'status'=>'success', 'tags'=>$tags ]);}public function api__fetch_langlinks($input){foreach(['type','language_grouping','not_uid'] as $x) if(empty($input->{$x})) $this->output_missing_param($x);$data=$this->db_get($input->type, [ 'columns'=>'uid,slug,language,language_grouping', 'where'=>[ ['language_grouping','=',$input->language_grouping], ['uid','!=',$input->not_uid] ] ]);if(empty($data)) $this->output(404, (object) [ 'status'=>'error', 'error'=>'content-not-found' ]);$this->output(200, (object) [ 'status'=>'success', 'data'=>$data ]);}public function api__fetch_pagination_info($input){if(empty($input->type)) $this->output_missing_param('type');$data=$this->db_get($input->type, [ 'columns'=>'uid,tags', ]);$this->output(200, (object) [ 'status'=>'success', ]);}public function api__fetch_relations_field_items($input){if(empty($input->types)) $input->types='all';$itemtypes=[];$item_schemas=$this->cms_config->item_schemas;foreach( $item_schemas as $x ) {if($input->types !== 'all'&&!in_array($x->name,explode(',',$input->types))) continue;if($this->item_type_is_singular($x->name)) continue;$itemtype=(object) [ 'name'=>$x->name, ];if(!empty($x->title_single)) $itemtype->title_single=$x->title_single;if(!empty($x->title_plural)) $itemtype->title_plural=$x->title_plural;$itemtype->items=$this->db_get($x->name, [ 'columns'=>'uid,title,language', ]);$itemtypes[]=$itemtype;}$this->output(200, (object) [ 'status'=>'success', 'itemtypes'=>$itemtypes ]);}public function api__html_cache_wipe_all(){$this->html_cache_wipe_all();$this->output(200, (object) [ 'status'=>'success', ]);}public function api__fetch_seeder_stats(){$stats=(object) [];$item_schemas=$this->cms_config->item_schemas;$item_schemas[]=(object)[ 'name'=>'asset' ];foreach( $item_schemas as $x ) {$stats->{$x->name}=(object) [];$stats->{$x->name}->count=$this->db_get($x->name, [ 'columns'=>'uid', 'where'=>[], 'return'=>'count' ]);$stats->{$x->name}->dummy_count=$this->db_get($x->name, [ 'columns'=>'uid', 'where_sql'=>'WHERE dummy_generated=1 OR TAGS LIKE :x', 'return'=>'count','params'=> [ [':x', '%Dummy generated%'], ],]);$stats->{$x->name}->real_count=$stats->{$x->name}->count - $stats->{$x->name}->dummy_count;}$this->output(200, (object) [ 'status'=>'success', 'stats'=>$stats ]);}public function api__save_item($input, $mode='save') {if(empty($input->type)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: type' ]);$is_new_item=empty($input->item->uid);$is_updating_item=!$is_new_item;if(!$this->userCan('create:'.$input->type)) $this->output(401, [ 'status'=>'error', 'error'=>'no-permission' ]);$item_schemas=$this->cms_config->item_schemas;$item_schemas[]=(object)[ 'name'=>'asset' ];$item_schemas[]=(object)[ 'name'=>'cms_config', 'singular'=>TRUE ];if(empty($item_schemas)) $this->output(404, [ 'status'=>'error', 'error'=>'no such item type' ]);foreach( $item_schemas as $x ) if($x->name===$input->type ) $itemtype=$x;if(empty($itemtype)) $this->output(404, [ 'status'=>'error', 'error'=>'no such item type' ]);if(empty($input->item)) $input->item=[];$item=(object) $input->item;if($input->type=='asset'&&isset($item->title)) $item->title=$this->slugify($item->title);if(empty($item->uid)) $item->uid=$this->makeUid();if(!empty($item->created_at)) $item->updated_at=date('Y-m-d H:i:s');if(empty($item->created_at)) $item->created_at=date('Y-m-d H:i:s');if(empty($item->slug)&&empty($item->title)) $item->slug=$item->uid;if(empty($item->slug)&&!empty($item->title)) $item->slug=$this->slugify($item->title).'-'.$item->uid;if($input->type=='asset'&&isset($input->uploaded_file)) {$file_saved=$this->save_asset_file($input->uploaded_file, $item);if($file_saved->status=='success') $item=$file_saved->item;}if($input->type=='asset'&&isset($item->title)) {$existing_item=$this->db_get_item('asset',$item->uid);if(!empty($existing_item)&&$item->title !== $existing_item->title ) {$this->asset_rename_files($item->uid, $existing_item->title, $item->title);}}if($mode=='save' )$done=$this->db_save_item($itemtype->name, $item);if(empty($done)) $this->output(404, [ 'status'=>'error', 'error'=>'could not create' ]);if($input->type=='asset'&&isset($input->uploaded_file)) $this->asset_create_resizables($item->uid);$this->html_cache_wipe_from_slug($item->slug);$output=[ 'status'=>'success', 'item'=>$item ];if(!empty($this->latest_webhook_response)) $output['webhook_response']=$this->latest_webhook_response;$this->output(200, $output);}public function api__patch_item($input) {$this->api__save_item($input, 'patch');}public function api__delete_item($input) {if(empty($input->type)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: type' ]);if(empty($input->uid)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: uid' ]);if(!$this->userCan('delete:'.$input->type)) $this->output(401, [ 'status'=>'error', 'error'=>'no-permission' ]);$uids=explode(',',$input->uid);$deleted_count=0;foreach($uids as $uid){$item=$this->db_get_item($input->type, $input->uid);if(empty($item)) continue;if(isset($item->slug)) $this->html_cache_wipe_from_slug($item->slug);$done=$this->db_delete_item($input->type, $input->uid);if(!$done) continue;if($input->type=='asset') $this->rrmdir($this->content_path."/asset/$input->uid");$deleted_count++;}if($deleted_count !== count($uids)) $this->output(400, [ 'status'=>'error', 'error'=>'could not delete all requested items', 'deleted_count'=>$deleted_count ]);$output=[ 'status'=>'success' ];if(!empty($this->latest_webhook_response)) $output['webhook_response']=$this->latest_webhook_response;$this->output(200, $output);}public function api__items_modify_tag($input) {if(empty($input->type)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: type' ]);if(empty($input->tag)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: tag' ]);if(empty($input->uids)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: uids' ]);if(empty($input->mode)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: mode' ]);if(!$this->userCan('create:'.$input->type)) $this->output(401, [ 'status'=>'error', 'error'=>'no-permission' ]);$errors=[]; $updated=[];foreach(explode(',',$input->uids) as $uid) {$item=$this->db_get_item($input->type, $uid);if(empty($item)) { $errors[]=$uid.' - not found'; continue; }if($input->mode=='add') $this->item_add_tag($item, $input->tag);if($input->mode=='remove') $this->item_remove_tag($item, $input->tag);$done=$this->db_save_item($input->type, $item);if(empty($done)) { $errors[]=$uid.' - not saved'; continue; }$updated[]=$uid;}$this->output(200, [ 'status'=>'success', 'updated'=>$updated, 'errors'=>$errors ]);}public function api__copy_item($input) {if(empty($input->itemtype)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: itemtype' ]);if(empty($input->uid)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: uid' ]);if(empty($input->new_title)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: new_title' ]);if(!$this->userCan('create:'.$input->itemtype)) $this->output(401, [ 'status'=>'error', 'error'=>'no-permission' ]);$old_item=$this->db_get_item($input->itemtype, $input->uid);if(empty($old_item)) $this->output(404, [ 'status'=>'error', 'error'=>'no such item' ]);$new_item=clone $old_item;$new_item->uid=$this->makeUid();$new_item->title=$input->new_title;$new_item->created_at=date('Y-m-d H:i:s');unset($new_item->updated_at);unset($new_item->updated_at);$new_item->slug=$this->slugify($input->new_title);$done=$this->db_save_item($input->itemtype, $new_item);if(empty($done)) $this->output(404, [ 'status'=>'error', 'error'=>'could not copy' ]);$output=[ 'status'=>'success' ];if(!empty($this->latest_webhook_response)) $output['webhook_response']=$this->latest_webhook_response;$this->output(200, $output);}public function api__fetch_item_with_relations($input){if(empty($input->uid)) $this->output_missing_param('uid');if(empty($input->type)) $this->output_missing_param('type');$item=$this->db_get($input->type, [ 'limit'=>1, 'where'=>['uid'=>$input->uid], 'first'=>true ]);if(empty($item)) $this->output(404, [ 'status'=>'error', 'error'=>'not found' ]);if($input->type=='asset') $item->files=$this->asset_load_files($item->uid);if($input->type=='asset') $item->size=$this->asset_load_size($item->uid);if($input->type != 'asset') $item=$this->fetch_relations($item);$this->output(200, (object) [ 'status'=>'success', 'data'=>$item ]);}public function api__save_cms_config($input, $mode='save') {if(empty($input->cms_config)) $this->output(404, [ 'status'=>'error', 'error'=>'missing param: cms_config' ]);$cms_config=(object) $input->cms_config;if(!empty($cms_config->blocks)) $cms_config->blocks=array_filter($cms_config->blocks, function($x){ return empty($x->from_php); });if(!empty($cms_config->item_schemas)) $cms_config->item_schemas=array_filter($cms_config->item_schemas, function($x){ return empty($x->from_php); });if(empty($cms_config->languages)) $cms_config->languages=[ (object)[ 'code'=>'en', 'primary'=>TRUE ] ];if(!empty($cms_config->created_at)) $cms_config->updated_at=date('Y-m-d H:i:s');if(empty($cms_config->created_at)) $cms_config->created_at=date('Y-m-d H:i:s');$done=$this->db_config_save($cms_config);if(empty($done)) $this->output(404, [ 'status'=>'error', 'error'=>'could not save' ]);$this->output(200, [ 'status'=>'success', ]);}public function api__fetch_stats() {$stats=(object) [];$stats->db_bytes=$this->multiple_files_combined_size([ $this->content_path.'/content.sqlite' ]);$asset_files=$this->glob_exclude($this->content_path.'/asset/**/*.*', $this->content_path.'/asset/**/*.json');$stats->asset_files_bytes=$this->multiple_files_combined_size($asset_files);$backup_files=glob($this->content_path.'/backup/*.zip');$stats->backup_files_bytes=$this->multiple_files_combined_size($backup_files);$cache_files=glob($this->content_path.'/cache/*.*');$stats->cache_files_bytes=$this->multiple_files_combined_size($cache_files);$assets=$this->get('asset');$stats->assets_count=count($assets);$stats->asset_resizables_missing=$this->get_asset_resizables_missing();$stats->asset_resizables_surplus=$this->get_asset_resizables_surplus();$this->output(200, [ 'status'=>'success', 'stats'=>$stats ]);}public function get_asset_resizables_surplus(){$files=glob($this->content_path."/asset/*/w*/*.*");$resizables=$this->get_asset_img_sizes();foreach($resizables as $r) $files=array_filter($files, function($f) use($r) { return !$this->strContains($f,"/w$r/"); });return array_values($files);}public function get_asset_resizables_missing(){$assets=$this->get('asset');$resizables=$this->get_asset_img_sizes();$assets_missing=[];foreach($assets as $a) {$is_resizable_img=in_array($a->format, ['jpg','png','webp']);if(!$is_resizable_img) continue;$missing=false;foreach($resizables as $r) {$path=$this->content_path."/asset/$a->uid/w$r/*.$a->format";if(empty(glob($path))) $missing=true;}if($missing) $assets_missing[]=$a->uid;}return $assets_missing;}public function api__delete_asset_resizables_surplus() {$files=$this->get_asset_resizables_surplus();$deleted_count=$this->deleteFiles($files);$this->output(200, [ 'status'=>'success', 'deleted'=>$deleted_count ]);}public function api__create_missing_asset_resizables() {$fixed_assets_count=0;$all_uids=$this->get_asset_resizables_missing();shuffle($all_uids);$run_uids=array_splice($all_uids, 0, 3);foreach($run_uids as $uid) $this->asset_create_resizables($uid);$this->output(200, [ 'status'=>'success', 'all_uids'=>$all_uids, 'run_uids'=>$run_uids ]);}public function api__fetch_backup_files() {$backup_files=glob($this->content_path.'/backup/*.zip');$files=[];foreach( $backup_files as $f ) $files[]=(object) [ 'url'=>$this->content_url.'/backup/'.basename($f), 'filename'=>basename($f), 'bytes'=>filesize($f) ];$this->output(200, [ 'status'=>'success', 'files'=>$files ]);}public function api__create_backup($input) {$files=[];$files[]=$this->content_path.'/content.sqlite';if($input->scope=='with_asset_files' ) {$asset_files=$this->glob_exclude($this->content_path.'/asset/**/*.*', $this->content_path.'/asset/**/*.json');$files=array_merge($files, $asset_files);}$date=date('Y-m-d').'-'.date('H-i-s');$folder=$this->content_path.'/backup';if($input->scope=='with_asset_files' ) $filepath=$folder."/$date-with-asset-files.zip";if($input->scope=='no_asset_files' )$filepath=$folder."/$date-without-asset-files.zip";if (!file_exists($folder)) mkdir($folder, $this->mkdir_chmod, true);$filename=basename($filepath);$zip=new ZipArchive();if($zip->open($filepath, ZipArchive::CREATE) !== TRUE ) $this->output(404, [ 'status'=>'error', 'error'=>'cannot create zip archive' ]);foreach( $files as $f ) $zip->addFile($f);$zip->addFromString('cms_config.json', json_encode($this->cms_config));$zip->close();$this->output(200, [ 'status'=>'success', 'input'=>$input ]);}public function api__delete_backup($input) {$filename=$input->filename;$filepath=$this->content_path.'/backup/'.$filename;if(!is_file($filepath)) $this->output(404, [ 'status'=>'error', 'error'=>'file not found' ]);$done=unlink($filepath);$this->output(200, [ 'status'=>'success', ]);}public function api__generate_dummy_items($input) {if(empty($input->type)) $this->output(400, [ 'status'=>'error', 'error'=>'missing param: type' ]);if(empty($input->count)) $this->output(400, [ 'status'=>'error', 'error'=>'missing param: count' ]);$item_schemas=$this->cms_config->item_schemas;$item_schemas[]=(object)[ 'name'=>'asset' ];$languages=$this->get_languages();if(empty($languages)) $languages=[ (object)[ 'code'=>'en' ] ];foreach( $item_schemas as $s ) if($input->type===$s->name ) $schema=$s;if(empty($schema)) $this->output(400, [ 'status'=>'error', 'error'=>'no such valid item type' ]);$seeded=[];$seeded_count=0;$i=1;while( $i <= $input->count ) {if(count($languages) > 1 ) $language_grouping=$this->makeUid();foreach($languages as $l) {$item=$this->generate_dummy_item($schema);$item->language=$l->code;if(isset($language_grouping)) $item->language_grouping=$language_grouping;$saved=$this->db_save_item($input->type, $item);if(empty($saved)) continue;if($input->type=='asset') $this->asset_create_resizables($item->uid);}$seeded[]=$item;$i++;}$this->output(200, [ 'status'=>'success', 'seeded_count'=>count($seeded), 'seeded'=>$seeded, ]);}public function api__delete_dummy_items($input) {if(empty($input->type)) $this->output(400, [ 'status'=>'error', 'error'=>'missing param: type' ]);$deleted_count=0;$items=$this->db_get_items($input->type);$dummy_items=array_filter($items, function($item){$a=$this->item_has_tag($item,'Dummy generated');$b=(!empty($item->dummy_generated)&&$this->isTrue($item->dummy_generated));return ($a||$b);});foreach( $dummy_items as $item ) {$deleted=$this->db_delete_item($input->type, $item->uid);if($deleted ) $deleted_count++;}if(empty($deleted_count)) $this->output(400, [ 'status'=>'error', 'error'=>'no items deleted', 'dummy_items'=>$dummy_items, 'items'=>$items ]);$this->output(200, [ 'status'=>'success', 'deleted_count'=>$deleted_count, ]);}public function api__trigger_webhook_manual_publish() {$response=$this->trigger_webhook_manual_publish();if($response->status='error' ) return $this->output(400, $response);$this->output(200, $response);}public function api__fetch_preview_assets($input) {$uids=(isset($input->uids)) ? $input->uids : [];$a=$this->db_get('asset', ['where'=>[ ['uid','in',$uids], ], ]);$this->output(200, ['assets'=>$a]);}public function triggerWebhook( $url, $data=[] ) {$curl=curl_init();$opts=[CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => TRUE,CURLOPT_CUSTOMREQUEST => 'POST',CURLOPT_POST => 1,CURLOPT_HTTPHEADER => [ 'Content-type: application/json' ]];curl_setopt_array($curl, $opts);if(!empty($data)) curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data, true));$response=curl_exec($curl);if (curl_errno($curl)) {return (object) [ 'status'=>'error', 'error_type'=>'curl_request_error', 'request_error'=>curl_error($curl), 'request_url'=>$url, 'request_data'=>$data ];}$response_http_code=curl_getinfo($curl, CURLINFO_HTTP_CODE);curl_close($curl);return (object) [ 'status'=>'success', 'response_http_code'=>$response_http_code, 'response'=>$response, 'request_url'=>$url, 'request_data'=>$data ];}public function trigger_webhook_manual_publish() {if(empty($this->cms_config->webhook_url_manual_publish)) return (object) [ 'status'=>'error', 'error'=>'no such webhook url defined' ];$response=$this->triggerWebhook($this->cms_config->webhook_url_manual_publish, NULL);return $response;}public function load_json($filepath){if(!is_file($filepath)) return false;$json=file_get_contents($filepath);$data=json_decode($json);return $data;}public function save_json($filepath, $data){if($this->json_pretty) $json=json_encode($data, JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT );if(!$this->json_pretty) $json=json_encode($data);$folder=dirname($filepath);if (!file_exists($folder)) mkdir($folder, $this->mkdir_chmod, true);$done=file_put_contents($filepath, $json);if(!$done ) return false;return true;}public function db_init(){if(isset($this->dbe)) return $this->dbe;$this->validate_content_folder();$this->sql_queries=[];$engine='sqlite';if($engine=='sqlite') {$this->dbe=new PDO('sqlite:'.$this->content_path.'/content.sqlite');$this->dbe->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );return $this->dbe;}}public function db_get($type, $input=NULL) {$this->db_init();$this->db_validate_table_structure($type);if(empty($input)) $input=[];$input=(object) $input;$cols=isset($input->columns) ? $input->columns : '*'; if($cols=='all') $cols='*';$where=isset($input->where) ? $input->where : [];$order=isset($input->order) ? str_replace([ ',', 'random' ],[ ' ', 'random()' ], $input->order) : 'created_at DESC';$limit=!empty($input->limit) ? $input->limit : NULL;$offset=!empty($input->offset) ? $input->offset : NULL;if(empty($where)) $where_str='';if(!empty($where)) {$where_arr=[];$i=0;foreach($where as $key => $val) {$operator='=';$arr_mode=(is_array($val)&&count($val)==3);if($arr_mode) { $key=$val[0]; $operator=$val[1]; $val=$val[2]; }$json_mode=(is_string($key)&&$this->strContains($key, 'fields->'));$in_mode=$operator=='in';if($in_mode) $where_arr[]="`$key` $operator (".join(',',$this->pdo_where_in_process_arr_a($key,$val)).")";if($json_mode) $where_arr[]=str_replace('fields->','json_extract(fields, \'$.',$key) ."') $operator :".str_replace('fields->','fields_',$key).$i;if(!$json_mode&&!$in_mode)$where_arr[]="`$key` $operator :$key".$i;$i++;}$where_str=' WHERE ('.implode(' AND ', $where_arr).')';}if(isset($input->where_sql)) $where_str=' '.$input->where_sql;$order_str=!empty($order) ? ' ORDER BY '.$order : '';$limit_str=!empty($limit) ? ' LIMIT '.$limit : '';$offset_str=!empty($offset) ? ' OFFSET '.$offset : '';$sql="SELECT $cols FROM `$type`".$where_str.$order_str.$limit_str.$offset_str.";";if(isset($input->sql)) $sql=$input->sql;if(isset($input->return)&&$input->return=='sql' ) return $sql;$q=$this->dbe->prepare($sql);if(!$q) return false;if(!empty($where)) {$i=0;foreach($where as $key => $val) {$arr_mode=(is_array($val)&&count($val)==3);if($arr_mode) { $key=$val[0]; $operator=$val[1]; $val=$val[2]; }$json_mode=(is_string($key)&&$this->strContains($key, 'fields->'));$ptype=(is_string($val)) ? PDO::PARAM_STR : PDO::PARAM_INT;$in_mode=($arr_mode&&$operator=='in' );if($in_mode) {$pairs=$this->pdo_where_in_process_arr($key,$val);foreach($pairs as $p) $q->bindValue($p[0], $p[1], (is_string($p[1])) ? PDO::PARAM_STR : PDO::PARAM_INT);}if($json_mode) $q->bindValue(':'.str_replace('fields->','fields_',$key).$i, $val, $ptype);if(!$json_mode&&!$in_mode) $q->bindValue(':'.$key.$i, $val, $ptype);$i++;}}if(isset($input->params)) foreach( $input->params as $x ) $q->bindValue($x[0], $x[1], ( isset($x[2])&&$x[2]=='int' || !isset($x[2])&&is_int($x[1])) ? PDO::PARAM_INT : PDO::PARAM_STR);$done=$q->execute();$this->sql_queries[]=$sql;if(!$done) return false;$items=$q->fetchAll(PDO::FETCH_OBJ);foreach($items as $item) if(isset($item->fields)) $item->fields=json_decode($item->fields);if($type=='asset') foreach($items as $item) $item->files=$this->asset_load_files($item->uid);if($type=='asset') foreach($items as $item) $item->size=$this->asset_load_size($item->uid);if(isset($input->return)&&$input->return=='count' ) return count($items);if(!empty($input->first)) return isset($items[0]) ? $items[0] : NULL;if(!empty($input->last)) return isset($items[count($items)-1]) ? $items[count($items)-1] : NULL;return $items;}public function db_get_any_item($uid) {$this->db_init();$tablenames=$this->get_item_types();foreach($tablenames as $tablename) {$item=$this->db_get_item($tablename, $uid);if(!empty($item)) return $item;}}public function db_get_item($type, $uid) {if($type==='any') return $this->db_get_any_item($uid);return $this->db_get($type, [ 'where'=>[ 'uid'=>$uid ], 'limit'=>1, 'first'=>TRUE ]);}public function db_get_random_item($type) {return $this->db_get($type, [ 'order'=>'RANDOM()', 'limit'=>1, 'first'=>TRUE ]);}public function db_get_items($type) {return $this->db_get($type, []);}public function db_get_item_by_slug($type, $slug, $lang=NULL) {$where=[ 'slug'=>$slug ];if(!empty($lang)) $where['language']=$lang;return $this->db_get($type, [ 'where'=>$where, 'first'=>TRUE ]);}public function db_get_items_where($type, $wheres) {return $this->db_get($type, [ 'where'=>$wheres ]);}public function db_esc($x){return $this->dbe->quote($x);}public function apply_filter($filtername, $data, $params=NULL){if(empty($this->filters[$filtername])) return $data;global $klay;if(empty($params)) $params=(object)[];$data=$this->filters[$filtername]($klay,$data,$params);return $data;}public function db_save_item($itemtype, $item){$item=$this->apply_filter('item:save', $item, (object)['itemtype'=>$itemtype]);$this->db_init();$this->db_validate_table_structure($itemtype);$cols=$this->db_table_blueprint_cols($itemtype);$insertables=[];if($itemtype!=='cms_config'&&$itemtype!=='cms_tokens') {if(empty($item->uid)) $item->uid=$this->makeUid();if(empty($item->created_at)) $item->created_at=date('Y-m-d H:i:s');if(empty($item->updated_at)) $item->updated_at=date('Y-m-d H:i:s');if(empty($item->slug)) $item->slug=empty($item->title) ? $item->uid : $this->slugify($item->title);}foreach($cols as $key => $col) {$col->has_value=isset($item->{$key});if($col->has_value) $col->value=$item->{$key};if(isset($col->json)&&$this->isTrue($col->json)&&isset($col->value)) $col->value=json_encode($col->value);if($col->has_value ) $insertables[]=(object) [ 'key'=>$key, 'colonkey'=>':'.$key, 'value'=>$col->value, 'type'=>$col->type, 'pdo_type'=>$this->db_get_pdo_datatype($col->type) ];}$sql="REPLACE INTO `$itemtype` (".implode(', ',array_column($insertables,'key')).") VALUES (".implode(', ', array_column($insertables,'colonkey')).")";$q=$this->dbe->prepare($sql);if(!$q) return false;foreach($insertables as $x) {if(gettype($x->value)=='boolean') $x->value=($x->value) ? 1 : 0;if(gettype($x->value)=='array' ) $x->value=NULL;if(gettype($x->value)=='object' ) $x->value=NULL;}foreach($insertables as $x) $q->bindValue($x->colonkey, $x->value, $x->pdo_type);$done=$q->execute();if($done) {if(isset($this->events['item:saved'])) $this->events['item:saved']($this,(object)[ 'itemtype'=>$itemtype,'item'=>$item ]);if(!empty($this->cms_config->webhook_url_auto_on_item_saved)) $this->latest_webhook_response=$this->triggerWebhook($this->cms_config->webhook_url_auto_on_item_saved, (object)[ 'itemtype'=>$itemtype,'item'=>$item ]);}return $done;}public function db_delete_item($itemtype, $uid){$item=$this->db_get_item($itemtype, $uid);if(empty($item)) return FALSE;$sql="DELETE FROM `$itemtype` WHERE `uid`='$uid';";$q=$this->dbe->query($sql);if(!$q) return FALSE;$done=$q->execute();if(!$done) return FALSE;if(isset($this->events['item:deleted'])) $this->events['item:deleted']($this, (object)['itemtype'=>$itemtype,'uid'=>$uid]);if(!empty($this->cms_config->webhook_url_auto_on_item_deleted)) $this->latest_webhook_response=$this->triggerWebhook($this->cms_config->webhook_url_auto_on_item_deleted, (object)[ 'itemtype'=>$itemtype,'item'=>$item ]);return true;}public function item_has_tag($item,$tag){return ( !empty($item->tags)&&$this->strContains($item->tags, $tag));}public function item_add_tag(&$item,$tag){if($this->item_has_tag($item,$tag))return;if(empty($item->tags)) return $item->tags=$tag;$item->tags .= ','.$tag;}public function item_remove_tag(&$item,$tag){if(!$this->item_has_tag($item,$tag))return;$item->tags=str_replace($tag, '', $item->tags);$item->tags=str_replace(',,', ',', $item->tags);$item->tags=str_replace(',,', ',', $item->tags);$item->tags=str_replace(',,', ',', $item->tags);$item->tags=ltrim($item->tags, ',');$item->tags=rtrim($item->tags, ',');}public function db_table_blueprint_cols($table){$cols=(object)['uid' => (object) [ 'type'=>'text', 'flags'=>'PRIMARY KEY' ],'slug' => (object) [ 'type'=>'text' ],'title' => (object) [ 'type'=>'text' ],'language' => (object) [ 'type'=>'text' ],'language_grouping' => (object) [ 'type'=>'text' ],'fields' => (object) [ 'type'=>'text', 'json'=>true ],'tags' => (object) [ 'type'=>'text' ],'published' => (object) [ 'type'=>'int' ],'dummy_generated' => (object) [ 'type'=>'int' ],'updated_at' => (object) [ 'type'=>'text' ],'created_at' => (object) [ 'type'=>'text' ],];if($table=='asset') {$cols=(object)['uid' => (object) [ 'type'=>'text', 'flags'=>'PRIMARY KEY' ],'title' => (object) [ 'type'=>'text' ],'tags' => (object) [ 'type'=>'text' ],'format' => (object) [ 'type'=>'text' ],'dominant_color' => (object) [ 'type'=>'text' ],'filesize' => (object) [ 'type'=>'int' ],'dummy_generated' => (object) [ 'type'=>'int' ],'fields' => (object) [ 'type'=>'text', 'json'=>true ],'updated_at' => (object) [ 'type'=>'text' ],'created_at' => (object) [ 'type'=>'text' ],];}if($table=='cms_config') {$cols=(object)['id' => (object) [ 'type'=>'int', 'flags'=>'PRIMARY KEY' ],'json' => (object) [ 'type'=>'text', 'json'=>true ],'updated_at' => (object) [ 'type'=>'text' ],'created_at' => (object) [ 'type'=>'text' ],];}if($table=='cms_tokens') {$cols=(object)['id' => (object) [ 'type'=>'int', 'flags'=>'PRIMARY KEY' ],'username' => (object) (object) [ 'type'=>'text' ],'token' => (object) (object) [ 'type'=>'text' ],'created_at' => (object) [ 'type'=>'text' ],];}return $cols;}public function db_validate_table_structure($table){$this->db_init();$cols=$this->db_table_blueprint_cols($table);if(!$this->db_tableFound($table)) $this->db_createTable($table);$tablecols=$this->db_list_table_columns($table);foreach($cols as $col_key => $col) {$col->is_missing=!in_array($col_key,$tablecols);if($col->is_missing) {$sql="ALTER TABLE `$table` ADD COLUMN `$col_key` '".strtoupper($col->type)."';";$this->dbe->exec($sql);$this->sql_queries[]=$sql;}}}public function db_tableFound($x){$this->db_init();$q=$this->dbe->prepare("SELECT COUNT(*) FROM sqlite_master WHERE type='table' AND name=?");$q->execute([$x]);$count=$q->fetchColumn();return $count > 0;}public function db_createTable($x){$cols=$this->db_table_blueprint_cols($x);$create_cols=[];foreach($cols as $col_key => $col) $create_cols[]=$col_key.' '.strtoupper($col->type).(isset($col->flags) ? ' '.$col->flags : '');$cols_txt=implode(', ',$create_cols);$sql="CREATE TABLE IF NOT EXISTS `$x` ( $cols_txt );";$this->dbe->exec($sql);$this->sql_queries[]=$sql;}public function db_list_tables(){if(isset($this->found_db_tablenames)) return $this->found_db_tablenames;$this->db_init();$sql="SELECT * FROM sqlite_master WHERE type='table';";$q=$this->dbe->query($sql);$this->sql_queries[]=$sql;if(!$q) { $this->found_db_tablenames=[]; return $this->found_db_tablenames; }$tables=$q->fetchAll(PDO::FETCH_ASSOC);$tablenames=array_column($tables,'name');$this->found_db_tablenames=$tablenames;return $tablenames;}public function db_list_table_columns($table){$this->db_init();$sql="PRAGMA table_info(`$table`)";$q=$this->dbe->query($sql);$this->sql_queries[]=$sql;if(!$q) return [];if(!$q) return false;$cols=$q->fetchAll(PDO::FETCH_OBJ);$colnames=array_column($cols, 'name');return $colnames;}public function db_get_pdo_datatype($type) {if($type==='text' ) return PDO::PARAM_STR;if($type==='int' ) return PDO::PARAM_INT;}public function db_inspect_all(){$output=(object) [];$this->db_init();$tables=$this->db_list_tables();foreach($tables as $t) {$output->{$t}=[];$items=$this->db($t)->raw()->all();foreach($items as $i) {if(!empty($i->fields)) $i->fields=json_decode($i->fields);$output->{$t}[]=$i;}}return $output;}public function db_config_load(){$this->db_init();$this->db_validate_table_structure('cms_config');$sql="SELECT * FROM `cms_config` WHERE `id`=1;";$q=$this->dbe->query($sql);$this->sql_queries[]=$sql;if(!$q) return false;$config=$q->fetch(PDO::FETCH_OBJ);if(empty($config->json)) return false;$config->json=json_decode($config->json);return $config->json;}public function db_config_save($data){$this->db_init();$this->db_validate_table_structure('cms_config');$sql="REPLACE INTO `cms_config` (`id`,`json`,`updated_at`) VALUES (1, '".json_encode($data)."', \"".date('Y-m-d H:i:s')."\" )";$q=$this->dbe->query($sql);if(!$q) return false;$done=$q->execute();return $done;}public function asset_load_files($uid) {$files=$this->glob_multiple([ $this->content_path."/asset/$uid/*.*", $this->content_path."/asset/$uid/*/*.*" ]);foreach($files as &$f) {$f=str_replace($this->content_path, '', $f);$f=ltrim($f,'/');$f=$this->content_url.'/'.$f;}return $files;}public function asset_load_size($uid) {$files=glob($this->content_path."/asset/$uid/*.*");$files=array_filter($files, function($f) { $ext=pathinfo($f, PATHINFO_EXTENSION); return in_array($ext, ['jpg','jpeg','webp','png','gif']); });if(empty($files))return;$f=$files[0];$data =getimagesize($f);list($w,$h)=$data;return compact('w','h');}public function asset_rename_files($uid, $old_title, $new_title) {$item=$this->db_get_item('asset', $uid);if(empty($item))return;if($item->title===$new_title)return;$files=$this->glob_multiple([ $this->content_path."/asset/$uid/*.*", $this->content_path."/asset/$uid/*/*.*" ]);foreach($files as $f) {$from=$f;$to=str_replace( $old_title, $new_title, $from );$renamed=rename($from, $to);}}public function validate_content_folder(){$content_folder=$this->content_path;if(!is_dir($content_folder))$done=mkdir($content_folder, $this->mkdir_chmod, true);return !empty($done);}public function get_file_meta_by_id($uid){if(isset($this->assets)) $assets=$this->assets;if(empty($assets)) return false;foreach( $assets as $x ) if(isset($x->uid)&&$x->uid===$uid ) return $x;return false;}public function item_type_is_singular($name){$type=$this->get_item_type($name);if(empty($type)) return false;if(empty($type->singular)) return false;return $this->isTrue($type->singular);}public function get_item_types(){$types=[];if(empty($this->cms_config->item_schemas)) return $types;foreach( $this->cms_config->item_schemas as $x ) $types[]=$x->name;return $types;}public function get_random_item_type(){$types=$this->get_item_types();if(empty($types))return;return $this->randFromArray($types);}public function get_item_type( $name ){if(empty($this->cms_config->item_schemas)) return false;foreach( $this->cms_config->item_schemas as $x ) if($x->name===$name ) return $x;return false;}public function get_block($type){global $klay;if(empty($this->cms_config->blocks)) return false;foreach( $this->cms_config->blocks as $x ) if($x->name===$type ) return $x;return false;}public function dd($x){header('Content-Type: text/html; charset=UTF-8');global $klay;$t=debug_backtrace();$t=array_values(array_filter($t,function($x){ return !empty($x['file'])&&basename($x['file']) !== 'Klay.php'; }));$hasfiles=!empty($t[0]['file']);if($hasfiles) {$sf=file($t[0]['file']);if($sf) {$fl=intval($t[0]['line']);$cstrlen=strlen($fl);if(isset($sf[$fl+1])) $cstrlen=strlen($fl+1);if(isset($sf[$fl+2])) $cstrlen=strlen($fl+2);}}http_response_code(500);echo '<style> body { background-color:#33353E; color:rgba(232,232,255,1); } html,body { margin:0; }* { font-family: "Andale Mono", "Source Code Pro", "Ubuntu Mono", "Monaco", "Courier New", monospace; font-weight:200; font-size: 18px; margin:0; padding:0; box-sizing:border-box; }.a { color: #292A31; background-color:#DCF8C9; font-size: .9em; display:grid; grid-template-columns:1fr auto; }.a span { opacity:.3; }.a div:nth-child(2) { text-align:right; opacity:.4; }.f { background:rgba(0,0,0,0.2); color:#EFEFFF; border-bottom:1px solid #DCF8C9; }.f span.x { opacity:.4; display:inline-block: margin-right:1em; }.f span.y { opacity:.4; display:inline-block: margin-left:.5em; }.f > div:not(:last-child) { opacity:.4; }.sf { background:rgba(0,0,0,0.1); color:rgba(232,232,255,.2); border-bottom:1px solid #DCF8C9; }.sf div.l-1 { color:#DCF8C9; }.a, .f, pre.main, .sf { padding: 20px 40px; overflow-x: auto; white-space: nowrap; }pre.main { padding-bottom:6em; white-space: pre;background-image: linear-gradient(to bottom, transparent 50%, rgba(255,255,255,.03) 50%);background-size: 20px 52px;padding: 26px 40px;}pre.main code { line-height: 26px; }.sys { opacity: .3; padding: 26px 40px; }</style>';echo "<div class=\"a\"><div>Klay CMS <span>v$this->version (build $this->buildno)</span></div><div>".'$klay'."-&gt;dd()</div></div>";if($hasfiles):echo '<div class="f">';$tx='&gt;'; foreach(array_reverse($t) as $tt) { echo '<div><span class="x">'.$tx.'</span> '.$tt['file'].' <span class="y">(line '.$tt['line'].')</span></div>'; $tx .= '&gt;'; }echo '</div>';if($sf):echo '<div class="sf">';$sl=function($x) use($sf,$t,$cstrlen,$fl) { if(isset($sf[$fl + $x])) echo '<div class="l'.$x.'"><span>'.($x==-1?'>&nbsp;':'&nbsp;&nbsp;').str_pad($fl+$x,$cstrlen,'0',STR_PAD_LEFT).' | </span><code>'.$sf[$fl + $x].' </code>&nbsp;</div>'; };$sl(-3); $sl(-2); $sl(-1); $sl(0); $sl(+1); $sl(+2);echo '</div>';endif;endif;echo '<pre class="main"><code>'; print_r($x); echo '</code></pre>'; echo '<div class="sys">PHP: '.PHP_VERSION.', OS: '.PHP_OS.' '.($_SERVER['SERVER_SOFTWARE']??'').' '.(class_exists('SQLite3')?'SQLite '.SQLite3::version()['versionString']:'').'</div>';die();}public function obj_strip($obj,$removekeys){foreach($removekeys as $key) if(!empty($obj->$key)) unset($obj->$key);return $obj;}public function makeUid( $n=6 ) {$x="abcdefghijklmnopqrstuwxyz0123456789";$x=str_shuffle($x);return substr($x,0,$n);}public function render_admin(){$c=$this->config;$x=(object) [];$x->langstrings=$this->langstrings;$x->version=$this->version;$x->buildno=$this->buildno;$x->base_url=$this->base_url;$x->content_url=$this->content_url;$x->php_version=phpversion();$x->php_extensions=get_loaded_extensions();$x->langstrings=$this->langstrings;$x->logged_in_user=$this->obj_strip($this->logged_in_user, ['password']);$x->permissions=$this->permissions;$x->block_autopreviews=isset($c->block_autopreviews) ? $c->block_autopreviews : FALSE;if(isset($c->admin_logo)) $x->admin_logo=$c->admin_logo;if(isset($c->brand_color)) $x->brand_color=$c->brand_color;if(isset($c->cms_config)) $x->cms_config=$c->cms_config;if(isset($c->csrf_token)) $x->csrf_token=$c->csrf_token;if(isset($c->preview_enabled)) $x->preview_enabled=$c->preview_enabled;if(isset($c->homescreen_links)) $x->homescreen_links=$c->homescreen_links;if(isset($c->menu_links))$x->menu_links=$c->menu_links;if(isset($c->max_upload_mb))$x->max_upload_mb=$c->max_upload_mb;if(isset($c->max_upload_mb_img))$x->max_upload_mb_img=$c->max_upload_mb_img;if(isset($c->max_upload_mb_video))$x->max_upload_mb_video=$c->max_upload_mb_video;$x->asset_img_sizes=$this->get_asset_img_sizes();if(isset($this->login_disabled)) $x->login_disabled=$this->login_disabled;ob_start();?><!DOCTYPE html><html lang="en"><head><meta charset="utf-8"><meta name="format-detection" content="telephone=no"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><meta name="viewport" content="user-scalable=no,initial-scale=1,maximum-scale=1,minimum-scale=1,width=device-width,height=device-height,target-densitydpi=device-dpi"><meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"><meta name="msapplication-tap-highlight" content="no"><title>{{DOC-TITLE}}</title><link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200"><style>#app,#lbar .mid,#toast-container>div{overflow:hidden}.lbarlink,.spinner,a.lbarlink{-webkit-transition:all .3s cubic-bezier(.215,.61,.355,1)}.toast-title{font-weight:700}.toast-message{-ms-word-wrap:break-word;word-wrap:break-word}.toast-message a:hover{text-decoration:none}.toast-close-button{position:relative;right:-.3em;top:-.3em;float:right;font-size:20px;font-weight:700;opacity:.8;-ms-filter:progid:DXImageTransform.Microsoft.Alpha(Opacity=80);filter:alpha(opacity=80);line-height:1}.toast-close-button:focus,.toast-close-button:hover{text-decoration:none;cursor:pointer;opacity:.4;-ms-filter:progid:DXImageTransform.Microsoft.Alpha(Opacity=40);filter:alpha(opacity=40)}.rtl .toast-close-button{left:-.3em;float:left;right:.3em}button.toast-close-button{padding:0;cursor:pointer;background:0 0;border:0;-webkit-appearance:none}.toast-top-center{top:0;right:0;width:100%}.toast-bottom-center{bottom:0;right:0;width:100%}.toast-top-full-width{top:0;right:0;width:100%}.toast-bottom-full-width{bottom:0;right:0;width:100%}.toast-top-left{top:12px;left:12px}.toast-top-right{top:12px;right:12px}.toast-bottom-right{right:12px;bottom:12px}.toast-bottom-left{bottom:12px;left:12px}#toast-container{position:fixed;z-index:999999;pointer-events:none}#toast-container *{-webkit-box-sizing:border-box;box-sizing:border-box}#toast-container>div{position:relative;pointer-events:auto;margin:0 0 6px;padding:15px 15px 15px 50px;width:200px;border-radius:8px;background-position:15px center;background-repeat:no-repeat;-webkit-box-shadow:0 10px 30px rgba(0,0,0,.2);box-shadow:0 10px 30px rgba(0,0,0,.2);opacity:.8}#toast-container>div.rtl{direction:rtl;padding:15px 50px 15px 15px;background-position:right 15px center}#toast-container>div:hover{opacity:1;cursor:pointer}#toast-container.toast-bottom-center>div,#toast-container.toast-top-center>div{width:300px;margin-left:auto;margin-right:auto}#toast-container.toast-bottom-full-width>div,#toast-container.toast-top-full-width>div{width:96%;margin-left:auto;margin-right:auto}.toast .icon{font-size:1.2em;margin-right:.7em;display:inline-block;position:absolute;top:14px;left:14px;-webkit-animation:a2323 .3s ease-out;animation:a2323 .3s ease-out;-webkit-animation-fill-mode:both;animation-fill-mode:both;-webkit-animation-delay:.1s;animation-delay:.1s}@-webkit-keyframes a2323{from{opacity:0;-webkit-transform:scale(0c);transform:scale(0c)}}@keyframes a2323{from{opacity:0;-webkit-transform:scale(0c);transform:scale(0c)}}.toast{background-color:#030303}.toast-success{background-color:#FFF;color:#000}.toast-error{background-color:#BD362F;color:#fff}.toast-info{background-color:#000;color:#fff}.toast-warning{background-color:#F89406;color:#fff}.toast-progress{position:absolute;left:0;bottom:0;height:4px;background-color:#000;opacity:.4;-ms-filter:progid:DXImageTransform.Microsoft.Alpha(Opacity=40);filter:alpha(opacity=40)}#app,html{height:100vh}@media all and (max-width:768px){#toast-container>div{padding:10.5px 10.5px 10.5px 35px;width:140px}#toast-container .toast .icon{top:8px;left:8px}#toast-container>div.rtl{padding:15px 50px 15px 15px}}*,body{padding:0;margin:0}*,.assets-list-header select,.field input,.field select,.field textarea,.itemfield input input,.itemfield input select,.itemfield input textarea,.modal .prompt-input input,.modal .prompt-input select,.modal .prompt-input textarea,.modal-addblock input.filterinput,.modal-addblock select.filterinput,.modal-addblock textarea.filterinput,.previewframe .url,.tagfield,.typo1,button,html,input,input.assets-list-search,input.items-list-search,input.styled,select,select.assets-list-search,select.items-list-search,select.styled,textarea.assets-list-search,textarea.items-list-search,textarea.styled{font-family:Helvetica,sans-serif,Arial;font-size:16px;letter-spacing:0;font-weight:400}*{-webkit-box-sizing:border-box;box-sizing:border-box}body{background-color:#ebf0f7;color:#333b44;height:100%}body.v-ready #app{display:block}canvas,img,svg,video{display:block;width:100%;height:auto}a,a:link,a:visited{color:#000}#app.darkmode a,#app.darkmode a:link,#app.darkmode a:visited{color:#fff}#app{padding:3rem;background-color:#ebf0f7;position:absolute;top:0;left:0;width:100vw;display:none}#app.darkmode{background-color:#121518}#app.file-dropping{opacity:.7}.filedropper-overlay{position:fixed;top:30px;left:30px;width:calc(100vw - 60px);height:calc(100vh - 60px);background-color:rgba(0,0,0,.5);border:2px dashed #fff;border-radius:14px;pointer-events:none;z-index:89;display:none;-webkit-box-shadow:0 0 0 100px rgba(0,0,0,.9);box-shadow:0 0 0 100px rgba(0,0,0,.9)}#app.file-dropping .filedropper-overlay,#lbar .logolink,#lbar .logolink .logo{display:block}#lbar{position:fixed;top:0;left:0;width:150px;height:100vh;-webkit-box-shadow:0 0 20px rgba(0,0,0,.1);box-shadow:0 0 20px rgba(0,0,0,.1);background-color:#333b44;color:#ebf0f7;z-index:30;display:grid;grid-template-rows:auto 1fr auto;-webkit-animation:a8728 .2s cubic-bezier(.215,.61,.355,1);animation:a8728 .2s cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a8728{from{-webkit-transform:translateX(-100%);transform:translateX(-100%)}}@keyframes a8728{from{-webkit-transform:translateX(-100%);transform:translateX(-100%)}}#lbar .mid .scroller{height:100%;position:relative;overflow-y:auto;overflow-y:scroll;scrollbar-width:none;-ms-overflow-style:none}#lbar .mid .scroller::-webkit-scrollbar{display:none}#app.darkmode #lbar{background-color:#242930;color:#ebf0f7;-webkit-box-shadow:0 0 20px rgba(0,0,0,.1);box-shadow:0 0 20px rgba(0,0,0,.1)}#app.lbar-s #lbar{width:50px}#main{position:fixed;top:0;right:0;width:calc(100vw - 150px);height:calc(100vh - 0px);overflow-y:auto;background-color:#ebf0f7;color:#333b44;-webkit-animation:a243 .3s linear;animation:a243 .3s linear}@-webkit-keyframes a243{from{opacity:0}}@keyframes a243{from{opacity:0}}body.view-e404 #main,body.view-login #main{width:100%}#app.darkmode #main{background-color:#121518;color:#ebf0f7}#app.lbar-s #main{width:calc(100vw - 50px)}#app.preview-frame #main{width:calc(50vw - 50px);right:50vw}#main-footer,#main-header{padding:1rem 1.5rem;background-color:#ebf0f7;color:#333b44;display:none}#main-inner{padding:1.5rem}.lbarlink,a.lbarlink{font-size:1rem;background-color:rgba(0,0,0,0);border-bottom:1px solid rgba(0,0,0,.2);padding:1em .7em;min-height:3.1em;color:rgba(235,240,247,.6);overflow:hidden;white-space:nowrap;text-decoration:none;cursor:pointer;position:relative;-o-transition:all .3s cubic-bezier(.215,.61,.355,1);transition:all .3s cubic-bezier(.215,.61,.355,1);display:grid;grid-template-columns:32px 1fr;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.lbarlink.is-first,a.lbarlink.is-first{border-top:1px solid rgba(0,0,0,.2)}.lbarlink span.label,a.lbarlink span.label{display:inline-block;overflow:hidden;white-space:nowrap;-o-text-overflow:ellipsis;text-overflow:ellipsis;width:100%}.lbarlink span.icon,a.lbarlink span.icon{opacity:.5;color:currentColor;font-size:1.4rem;margin-top:-2px;-webkit-transition:opacity .2s cubic-bezier(.215,.61,.355,1);-o-transition:opacity .2s cubic-bezier(.215,.61,.355,1);transition:opacity .2s cubic-bezier(.215,.61,.355,1)}.lbarlink:hover,a.lbarlink:hover{background-color:rgba(0,0,0,.1)}.lbarlink:hover span.icon,a.lbarlink:hover span.icon{opacity:1}.lbarlink:active,a.lbarlink:active{background-color:rgba(0,0,0,.15)}.lbarlink:active span.icon,a.lbarlink:active span.icon{color:var(--brand-color);opacity:.8}.lbarlink.active,a.lbarlink.active{background-color:rgba(0,0,0,.2);color:#ebf0f7}.lbarlink.active span.icon,a.lbarlink.active span.icon{opacity:1;color:var(--brand-color)}#app.lbar-s .lbarlink span.label{white-space:nowrap;background-color:#333;color:#fff;position:absolute;top:50%;left:100%;padding:.4em .6em;-webkit-transform-origin:left center;-ms-transform-origin:left center;transform-origin:left center;-webkit-transform:translateY(-50%) scale(0);-ms-transform:translateY(-50%) scale(0);transform:translateY(-50%) scale(0);border-top-right-radius:4px;border-bottom-right-radius:4px;pointer-events:none}#app.lbar-s .lbarlink:hover span.label{-webkit-transition:all 80ms cubic-bezier(.215,.61,.355,1);-o-transition:all 80ms cubic-bezier(.215,.61,.355,1);transition:all 80ms cubic-bezier(.215,.61,.355,1);-webkit-transform:translateY(-50%) scale(.7);-ms-transform:translateY(-50%) scale(.7);transform:translateY(-50%) scale(.7)}.lbar-floatlabel{position:fixed;pointer-events:none;top:0;left:0;margin-left:50px;margin-top:12px;background-color:#000;color:#fff;padding:.7em .8em;z-index:9999;font-size:.9rem;-webkit-transform-origin:top left;-ms-transform-origin:top left;transform-origin:top left;-webkit-animation:a827 150ms cubic-bezier(.215,.61,.355,1);animation:a827 150ms cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a827{from{-webkit-transform:scaleX(.8);transform:scaleX(.8);opacity:0}}@keyframes a827{from{-webkit-transform:scaleX(.8);transform:scaleX(.8);opacity:0}}#lbar .logolink{width:clamp(40px,5vh,100px);margin:max(10px,2vh) auto}#lbar .logolink .logo svg{fill:var(--brand-color)}#app.lbar-s #lbar .logolink{width:60%;margin:.5rem auto}#lbar .bottom{display:grid;grid-template-columns:1fr 1fr;gap:1px}#app.lbar-s #lbar .bottom{grid-template-columns:1fr}#lbar .bottom .fbtn{background-color:rgba(0,0,0,.3);height:44px;display:grid;-webkit-box-align:center;-ms-flex-align:center;align-items:center;justify-items:center;cursor:pointer}#lbar .bottom .fbtn:hover{background-color:rgba(0,0,0,.2)}#lbar .bottom .fbtn:active{background-color:rgba(0,0,0,.6)}#app.lbar-s #lbar .bottom .fbtn{height:38px}#apploader{position:fixed;top:50%;left:50%;-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%);width:100px;height:100px}.apploader-spinner{position:absolute;top:50%;left:50%;width:40px;height:40px;border-radius:999px;-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%);pointer-events:none;opacity:1}.apploader-spinner div{position:absolute;top:5%;left:5%;width:90%;height:90%;border-radius:999px;border:2px solid rgba(0,0,0,.2);border-left-color:#000;-webkit-animation:a2453 .7s infinite linear;animation:a2453 .7s infinite linear}@-webkit-keyframes a2453{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes a2453{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.loading{position:relative}.loading .loading-spinner{height:30px;width:30px;border-radius:999px;border:2px solid rgba(0,0,0,.4);border-right-color:transparent;margin:2rem auto;-webkit-animation:a22242 .7s infinite linear;animation:a22242 .7s infinite linear}@-webkit-keyframes a22242{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes a22242{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}#app.darkmode .card .loading .loading-spinner{border:2px solid rgba(255,255,255,.6);border-right-color:transparent}.loading .loading-text{width:80%;max-width:300px;opacity:.3}.loading .loading-text .line{background:-webkit-gradient(linear,left top,right top,from(rgba(0,0,0,0)),color-stop(3%,rgba(0,0,0,0)),color-stop(50%,#000),color-stop(98%,rgba(0,0,0,0)),to(rgba(0,0,0,0)));background:-o-linear-gradient(left,rgba(0,0,0,0) 0,rgba(0,0,0,0) 3%,#000 50%,rgba(0,0,0,0) 98%,rgba(0,0,0,0) 100%);background:linear-gradient(to right,rgba(0,0,0,0) 0,rgba(0,0,0,0) 3%,#000 50%,rgba(0,0,0,0) 98%,rgba(0,0,0,0) 100%);background-size:100% 100%;background-position:0 0;-webkit-animation:a23123 .7s infinite linear;animation:a23123 .7s infinite linear;height:4px;margin-bottom:10px}@-webkit-keyframes a23123{to{background-position:100% 0}}@keyframes a23123{to{background-position:100% 0}}.loading .loading-text div.line1{height:8px;width:40%}.loading .loading-text div.line2{width:70%}.loading .loading-text div.line3{width:80%}.loading .loading-text div.line4{width:50%}.card{border-radius:8px;border:1px solid #c7d5e8;background-color:#FFF;color:#333b44;-webkit-animation:a9272 .3s cubic-bezier(.215,.61,.355,1);animation:a9272 .3s cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a9272{from{opacity:0;-webkit-transform:translateY(-6px);transform:translateY(-6px)}}@keyframes a9272{from{opacity:0;-webkit-transform:translateY(-6px);transform:translateY(-6px)}}.card .card-header{border-bottom:1px solid rgba(51,59,68,.2);padding:1.4rem 1.6rem 1.2rem;position:relative}.card .card-body{padding:1.6rem;position:relative}.card .card-header .icon:first-child{scale:1.4;translate:-35% 0;opacity:.7}#app.darkmode .card{background-color:#242930;color:#ebf0f7;border-color:#3e4853}#app.darkmode .card .card-header{border-bottom-color:#3e4853}.card.color2{background-color:#333b44;color:#FFF}.spinner{position:fixed;top:0;left:0;width:100%;height:100%;z-index:4444;-webkit-animation:a2f2fa .7s cubic-bezier(.215,.61,.355,1);animation:a2f2fa .7s cubic-bezier(.215,.61,.355,1);-o-transition:all .3s cubic-bezier(.215,.61,.355,1);transition:all .3s cubic-bezier(.215,.61,.355,1);opacity:0;pointer-events:none}@-webkit-keyframes a2f2fa{from{opacity:0}}@keyframes a2f2fa{from{opacity:0}}.spinner.active{opacity:1}.spinner.blocking{background-color:rgba(0,0,0,.2);pointer-events:all}.spinner .circle{position:absolute;top:50%;left:50%;-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%);height:50px;width:50px;border-radius:100%;background:#FFF;-webkit-box-shadow:0 0 20px rgba(51,59,68,.3);box-shadow:0 0 20px rgba(51,59,68,.3)}.spinner .circle div{position:absolute;top:10%;left:10%;height:80%;width:80%;border-radius:100%;border:2px solid #333b44;border-right-color:transparent;border-left-color:transparent;-webkit-animation:a242535 .7s infinite linear;animation:a242535 .7s infinite linear}@-webkit-keyframes a242535{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes a242535{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.e404,.spinner .msg{-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%)}.spinner .msg{text-align:center;position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);font-size:.8rem;margin-top:4em;pointer-events:none;color:#fff;background-color:#000;padding:.5em 1.5em}.single-item-versions-table,.stats-table,.table1{width:100%;border-collapse:collapse}.single-item-versions-table tr:nth-child(even),.stats-table tr:nth-child(even),.table1 tr:nth-child(even){background-color:rgba(235,240,247,.8)}.single-item-versions-table tr:nth-child(odd),.stats-table tr:nth-child(odd),.table1 tr:nth-child(odd){background-color:rgba(235,240,247,.4)}.single-item-versions-table th,.stats-table th,.table1 th{font-weight:500}.single-item-versions-table td,.single-item-versions-table th,.stats-table td,.stats-table th,.table1 td,.table1 th{padding:.7rem 1rem;text-align:left;vertical-align:top}.icon,.itemfield .repeater .add-row-btn *,.itemfield .repeater .rbtn *,.items-table td{vertical-align:middle}.single-item-versions-table th,.single-item-versions-table tr,.stats-table th,.stats-table tr,.table1 th,.table1 tr{border-bottom:1px solid #ebf0f7}.single-item-versions-table tr:last-of-type,.stats-table tr:last-of-type,.table1 tr:last-of-type{border-bottom:none}#app.darkmode .single-item-versions-table tr:nth-child(even),#app.darkmode .stats-table tr:nth-child(even),#app.darkmode .table1 tr:nth-child(even){background-color:rgba(235,240,247,.1)}#app.darkmode .single-item-versions-table tr:nth-child(odd),#app.darkmode .stats-table tr:nth-child(odd),#app.darkmode .table1 tr:nth-child(odd){background-color:rgba(235,240,247,.05)}#app.darkmode .single-item-versions-table th,#app.darkmode .single-item-versions-table tr,#app.darkmode .stats-table th,#app.darkmode .stats-table tr,#app.darkmode .table1 th,#app.darkmode .table1 tr{border-bottom:1px solid rgba(235,240,247,.2)}.icon{font-size:1em;color:currentColor;font-variation-settings:"FILL" 0,"wght" 500,"GRAD" 0,"opsz" 20}.assets-list .item .select-btn,.btn,.itemfield.type-asset .asset-clear-btn,.itemfield.type-asset .asset-open-btn,.itemfield.type-asset .asset-select-btn,.itemfield.type-asset .asset-swap-btn,.items-single-view .item-header .langlinks a,.items-single-view .item-header .langlinks span,.items-single-view .item-header .save-btn,.modal .confirm-btns .confirm-cancel-btn,.modal .confirm-btns .confirm-ok-btn,.modal .msg-ok-btn,.modal-addblock .add-block-btn{padding:.6em 1.2em;cursor:pointer;text-align:center;border-radius:8px;border:1px solid #c7d5e8;-webkit-transition:all 150ms cubic-bezier(.215,.61,.355,1);-o-transition:all 150ms cubic-bezier(.215,.61,.355,1);transition:all 150ms cubic-bezier(.215,.61,.355,1);background-color:#fff;color:#333b44}.assets-list .item .select-btn,.btn.--s,.itemfield.type-asset .asset-clear-btn,.itemfield.type-asset .asset-open-btn,.itemfield.type-asset .asset-select-btn,.itemfield.type-asset .asset-swap-btn,.items-single-view .item-header .langlinks a,.items-single-view .item-header .langlinks span,.items-single-view .item-header .save-btn,.modal .--s.msg-ok-btn,.modal .confirm-btns .--s.confirm-cancel-btn,.modal .confirm-btns .--s.confirm-ok-btn,.modal-addblock .--s.add-block-btn{font-size:.9rem;padding:.5em 1em}.assets-list .item .select-btn:hover,.btn:hover,.itemfield.type-asset .asset-clear-btn:hover,.itemfield.type-asset .asset-open-btn:hover,.itemfield.type-asset .asset-select-btn:hover,.itemfield.type-asset .asset-swap-btn:hover,.items-single-view .item-header .langlinks a:hover,.items-single-view .item-header .langlinks span:hover,.items-single-view .item-header .save-btn:hover,.modal .confirm-btns .confirm-cancel-btn:hover,.modal .confirm-btns .confirm-ok-btn:hover,.modal .msg-ok-btn:hover,.modal-addblock .add-block-btn:hover{opacity:.7}.assets-list .item .select-btn:active,.btn:active,.itemfield.type-asset .asset-clear-btn:active,.itemfield.type-asset .asset-open-btn:active,.itemfield.type-asset .asset-select-btn:active,.itemfield.type-asset .asset-swap-btn:active,.items-single-view .item-header .langlinks a:active,.items-single-view .item-header .langlinks span:active,.items-single-view .item-header .save-btn:active,.modal .confirm-btns .confirm-cancel-btn:active,.modal .confirm-btns .confirm-ok-btn:active,.modal .msg-ok-btn:active,.modal-addblock .add-block-btn:active{opacity:.4}.assets-list .item .v2.select-btn,.btn.v2,.itemfield.type-asset .v2.asset-clear-btn,.itemfield.type-asset .v2.asset-open-btn,.itemfield.type-asset .v2.asset-select-btn,.itemfield.type-asset .v2.asset-swap-btn,.items-single-view .item-header .langlinks .modal-addblock a.add-block-btn.selected,.items-single-view .item-header .langlinks .modal-addblock span.add-block-btn.selected,.items-single-view .item-header .langlinks a.v2,.items-single-view .item-header .langlinks span.v2,.items-single-view .item-header .save-btn,.modal .confirm-btns .v2.confirm-cancel-btn,.modal .confirm-btns .v2.confirm-ok-btn,.modal .v2.msg-ok-btn,.modal-addblock .add-block-btn.selected,.modal-addblock .items-single-view .item-header .langlinks a.add-block-btn.selected,.modal-addblock .items-single-view .item-header .langlinks span.add-block-btn.selected,.modal-addblock .v2.add-block-btn{background-color:#333b44;color:#fff;border-color:#333b44}.assets-list .item .v3.select-btn,.btn.v3,.itemfield.type-asset .asset-select-btn,.itemfield.type-asset .items-single-view .item-header .langlinks a.asset-select-btn,.itemfield.type-asset .items-single-view .item-header .langlinks span.asset-select-btn,.itemfield.type-asset .v3.asset-clear-btn,.itemfield.type-asset .v3.asset-open-btn,.itemfield.type-asset .v3.asset-swap-btn,.items-single-view .item-header .langlinks .itemfield.type-asset a.asset-select-btn,.items-single-view .item-header .langlinks .itemfield.type-asset span.asset-select-btn,.items-single-view .item-header .langlinks a.v3,.items-single-view .item-header .langlinks span.v3,.items-single-view .item-header .v3.save-btn,.modal .confirm-btns .v3.confirm-cancel-btn,.modal .confirm-btns .v3.confirm-ok-btn,.modal .v3.msg-ok-btn,.modal-addblock .v3.add-block-btn{background-color:#ebf0f7;color:#333b44;border-color:#333b44}.assets-list .item .disabled.select-btn,.btn.disabled,.itemfield.type-asset .disabled.asset-clear-btn,.itemfield.type-asset .disabled.asset-open-btn,.itemfield.type-asset .disabled.asset-select-btn,.itemfield.type-asset .disabled.asset-swap-btn,.items-single-view .item-header .disabled.save-btn,.items-single-view .item-header .langlinks a.disabled,.items-single-view .item-header .langlinks span.disabled,.modal .confirm-btns .disabled.confirm-cancel-btn,.modal .confirm-btns .disabled.confirm-ok-btn,.modal .disabled.msg-ok-btn,.modal-addblock .disabled.add-block-btn{cursor:not-allowed;opacity:.6}#app.darkmode .assets-list .item .select-btn,#app.darkmode .btn,#app.darkmode .itemfield.type-asset .asset-clear-btn,#app.darkmode .itemfield.type-asset .asset-open-btn,#app.darkmode .itemfield.type-asset .asset-select-btn,#app.darkmode .itemfield.type-asset .asset-swap-btn,#app.darkmode .items-single-view .item-header .langlinks a,#app.darkmode .items-single-view .item-header .langlinks span,#app.darkmode .items-single-view .item-header .save-btn,#app.darkmode .modal .confirm-btns .confirm-cancel-btn,#app.darkmode .modal .confirm-btns .confirm-ok-btn,#app.darkmode .modal .msg-ok-btn,#app.darkmode .modal-addblock .add-block-btn,.assets-list .item #app.darkmode .select-btn,.itemfield.type-asset #app.darkmode .asset-clear-btn,.itemfield.type-asset #app.darkmode .asset-open-btn,.itemfield.type-asset #app.darkmode .asset-select-btn,.itemfield.type-asset #app.darkmode .asset-swap-btn,.items-single-view .item-header #app.darkmode .save-btn,.items-single-view .item-header .langlinks #app.darkmode a,.items-single-view .item-header .langlinks #app.darkmode span,.modal #app.darkmode .msg-ok-btn,.modal .confirm-btns #app.darkmode .confirm-cancel-btn,.modal .confirm-btns #app.darkmode .confirm-ok-btn,.modal-addblock #app.darkmode .add-block-btn{background-color:#242930;color:#fff;border-color:#3e4853}#app.darkmode .assets-list .item .v2.select-btn,#app.darkmode .btn.v2,#app.darkmode .itemfield.type-asset .v2.asset-clear-btn,#app.darkmode .itemfield.type-asset .v2.asset-open-btn,#app.darkmode .itemfield.type-asset .v2.asset-select-btn,#app.darkmode .itemfield.type-asset .v2.asset-swap-btn,#app.darkmode .items-single-view .item-header .langlinks a.v2,#app.darkmode .items-single-view .item-header .langlinks span.v2,#app.darkmode .items-single-view .item-header .save-btn,#app.darkmode .modal .confirm-btns .v2.confirm-cancel-btn,#app.darkmode .modal .confirm-btns .v2.confirm-ok-btn,#app.darkmode .modal .v2.msg-ok-btn,#app.darkmode .modal-addblock .add-block-btn.selected,#app.darkmode .modal-addblock .v2.add-block-btn,.assets-list .item #app.darkmode .v2.select-btn,.itemfield.type-asset #app.darkmode .v2.asset-clear-btn,.itemfield.type-asset #app.darkmode .v2.asset-open-btn,.itemfield.type-asset #app.darkmode .v2.asset-select-btn,.itemfield.type-asset #app.darkmode .v2.asset-swap-btn,.items-single-view .item-header #app.darkmode .save-btn,.items-single-view .item-header .langlinks #app.darkmode a.v2,.items-single-view .item-header .langlinks #app.darkmode span.v2,.modal #app.darkmode .v2.msg-ok-btn,.modal .confirm-btns #app.darkmode .v2.confirm-cancel-btn,.modal .confirm-btns #app.darkmode .v2.confirm-ok-btn,.modal-addblock #app.darkmode .add-block-btn.selected,.modal-addblock #app.darkmode .v2.add-block-btn{background-color:#FFF;color:#333b44}#app.darkmode .assets-list .item .v3.select-btn,#app.darkmode .btn.v3,#app.darkmode .itemfield.type-asset .asset-select-btn,#app.darkmode .itemfield.type-asset .v3.asset-clear-btn,#app.darkmode .itemfield.type-asset .v3.asset-open-btn,#app.darkmode .itemfield.type-asset .v3.asset-swap-btn,#app.darkmode .items-single-view .item-header .langlinks a.v3,#app.darkmode .items-single-view .item-header .langlinks span.v3,#app.darkmode .items-single-view .item-header .v3.save-btn,#app.darkmode .modal .confirm-btns .v3.confirm-cancel-btn,#app.darkmode .modal .confirm-btns .v3.confirm-ok-btn,#app.darkmode .modal .v3.msg-ok-btn,#app.darkmode .modal-addblock .v3.add-block-btn,.assets-list .item #app.darkmode .v3.select-btn,.itemfield.type-asset #app.darkmode .asset-select-btn,.itemfield.type-asset #app.darkmode .v3.asset-clear-btn,.itemfield.type-asset #app.darkmode .v3.asset-open-btn,.itemfield.type-asset #app.darkmode .v3.asset-swap-btn,.items-single-view .item-header #app.darkmode .v3.save-btn,.items-single-view .item-header .langlinks #app.darkmode a.v3,.items-single-view .item-header .langlinks #app.darkmode span.v3,.modal #app.darkmode .v3.msg-ok-btn,.modal .confirm-btns #app.darkmode .v3.confirm-cancel-btn,.modal .confirm-btns #app.darkmode .v3.confirm-ok-btn,.modal-addblock #app.darkmode .v3.add-block-btn{background-color:#495461;color:#fff;border-color:#3e4853}.assets-list .item .select-btn .icon,.btn .icon,.itemfield.type-asset .asset-clear-btn .icon,.itemfield.type-asset .asset-open-btn .icon,.itemfield.type-asset .asset-select-btn .icon,.itemfield.type-asset .asset-swap-btn .icon,.items-single-view .item-header .langlinks a .icon,.items-single-view .item-header .langlinks span .icon,.items-single-view .item-header .save-btn .icon,.modal .confirm-btns .confirm-cancel-btn .icon,.modal .confirm-btns .confirm-ok-btn .icon,.modal .msg-ok-btn .icon,.modal-addblock .add-block-btn .icon{font-size:1.2em}.assets-list .item .depressed.select-btn,.assets-list .item .items-single-view .item-header .langlinks .current.select-btn,.btn.depressed,.itemfield.type-asset .depressed.asset-clear-btn,.itemfield.type-asset .depressed.asset-open-btn,.itemfield.type-asset .depressed.asset-select-btn,.itemfield.type-asset .depressed.asset-swap-btn,.itemfield.type-asset .items-single-view .item-header .langlinks .current.asset-clear-btn,.itemfield.type-asset .items-single-view .item-header .langlinks .current.asset-open-btn,.itemfield.type-asset .items-single-view .item-header .langlinks .current.asset-select-btn,.itemfield.type-asset .items-single-view .item-header .langlinks .current.asset-swap-btn,.items-single-view .item-header .depressed.save-btn,.items-single-view .item-header .langlinks .assets-list .item .current.select-btn,.items-single-view .item-header .langlinks .btn.current,.items-single-view .item-header .langlinks .itemfield.type-asset .current.asset-clear-btn,.items-single-view .item-header .langlinks .itemfield.type-asset .current.asset-open-btn,.items-single-view .item-header .langlinks .itemfield.type-asset .current.asset-select-btn,.items-single-view .item-header .langlinks .itemfield.type-asset .current.asset-swap-btn,.items-single-view .item-header .langlinks .modal .confirm-btns .current.confirm-cancel-btn,.items-single-view .item-header .langlinks .modal .confirm-btns .current.confirm-ok-btn,.items-single-view .item-header .langlinks .modal .current.msg-ok-btn,.items-single-view .item-header .langlinks .modal-addblock .current.add-block-btn,.items-single-view .item-header .langlinks .save-btn.current,.items-single-view .item-header .langlinks a.current,.items-single-view .item-header .langlinks a.depressed,.items-single-view .item-header .langlinks span.current,.items-single-view .item-header .langlinks span.depressed,.modal .confirm-btns .depressed.confirm-cancel-btn,.modal .confirm-btns .depressed.confirm-ok-btn,.modal .confirm-btns .items-single-view .item-header .langlinks .current.confirm-cancel-btn,.modal .confirm-btns .items-single-view .item-header .langlinks .current.confirm-ok-btn,.modal .depressed.msg-ok-btn,.modal .items-single-view .item-header .langlinks .current.msg-ok-btn,.modal-addblock .depressed.add-block-btn,.modal-addblock .items-single-view .item-header .langlinks .current.add-block-btn{-webkit-box-shadow:inset 0 7px 20px rgba(0,0,0,.15);box-shadow:inset 0 7px 20px rgba(0,0,0,.15);-webkit-transform:scale(.95);-ms-transform:scale(.95);transform:scale(.95)}.assets-list .item input.select-btn,.itemfield.type-asset input.asset-clear-btn,.itemfield.type-asset input.asset-open-btn,.itemfield.type-asset input.asset-select-btn,.itemfield.type-asset input.asset-swap-btn,.items-single-view .item-header input.save-btn,.modal .confirm-btns input.confirm-cancel-btn,.modal .confirm-btns input.confirm-ok-btn,.modal input.msg-ok-btn,.modal-addblock input.add-block-btn,input.btn{-moz-appearance:none;appearance:none;-webkit-appearance:none;border:none;display:block;width:100%;font-size:1rem}.assets-list .item a.select-btn,.itemfield.type-asset a.asset-clear-btn,.itemfield.type-asset a.asset-open-btn,.itemfield.type-asset a.asset-select-btn,.itemfield.type-asset a.asset-swap-btn,.items-single-view .item-header .langlinks a,.items-single-view .item-header a.save-btn,.modal .confirm-btns a.confirm-cancel-btn,.modal .confirm-btns a.confirm-ok-btn,.modal a.msg-ok-btn,.modal-addblock a.add-block-btn,a.btn{text-decoration:none}.btns{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;gap:.3em .6em}.txtlink{text-decoration:underline;cursor:pointer;-webkit-transition:all 150ms cubic-bezier(.215,.61,.355,1);-o-transition:all 150ms cubic-bezier(.215,.61,.355,1);transition:all 150ms cubic-bezier(.215,.61,.355,1)}.keyman .dim,.txtlink.dimmed,.txtlink.dimmednoclick{-webkit-transition:all 150ms cubic-bezier(.215,.61,.355,1);-o-transition:all 150ms cubic-bezier(.215,.61,.355,1)}.txtlink:hover{opacity:.8}.txtlink:active{opacity:.4}.txtlink.dimmed,.txtlink.dimmednoclick{text-decoration:underline;cursor:pointer;transition:all 150ms cubic-bezier(.215,.61,.355,1);opacity:.3}.txtlink.dimmed:hover,.txtlink.dimmednoclick:hover{opacity:.6}.txtlink.dimmed:active,.txtlink.dimmednoclick:active{opacity:1}.txtlink.dimmednoclick,.txtlink.noclick{pointer-events:none}.txtlink.is-l{font-size:1.6em}.txtlink.is-xl{font-size:2em}.items-list-header{display:grid;grid-template-columns:1fr 200px 200px 200px;margin-bottom:1rem;gap:20px}.grid-11,.items-single-view .item-header .cols,.loginbox .loginbtns,.modal .confirm-btns{grid-template-columns:1fr 1fr}.items-list-search{display:inline-block}.items-table td:first-child,.items-table th:first-child{width:1px}.items-table .asset-preview{width:50px;height:50px;overflow:hidden;border-radius:999px;position:relative;background-color:rgba(0,0,0,.1)}.items-table .asset-preview img,.items-table .asset-preview video{position:absolute;top:0;left:0;width:100%;height:100%;-o-object-fit:cover;object-fit:cover;-o-object-position:center;object-position:center}#app.darkmode .items-table .asset-preview{background-color:rgba(255,255,255,.15)}.items-single-view .item-header{position:relative}.items-single-view .item-header .cols{display:grid;gap:1rem}.items-single-view .item-header .cols>div:nth-child(2){justify-self:right;text-align:right}.items-single-view .item-header .type{font-size:.9em;margin-bottom:.5rem;color:currentColor;text-decoration:none;display:inline-block}.items-single-view .item-header .title{font-size:1.6rem;font-weight:600;display:inline-block;position:relative;cursor:default}.items-single-view .item-header .title .editbtn{opacity:.2;font-size:.7em;cursor:pointer}.items-single-view .item-header .title .editbtn .icon{font-size:1em}.items-single-view .item-header .title:hover .editbtn{opacity:1}.items-single-view .urledit{margin-top:.7rem;cursor:pointer}.items-single-view .urledit span.x{margin:0 .2rem}.items-single-view .item-header .langlinks,.modal .msg-ok-btn{margin-top:1em}.items-single-view .urledit .icon:nth-child(3){opacity:0}.items-single-view .urledit:hover .icon:nth-child(3){opacity:1}.assets-list .item .items-single-view .item-header .actionbtns .select-btn,.itemfield.type-asset .items-single-view .item-header .actionbtns .asset-clear-btn,.itemfield.type-asset .items-single-view .item-header .actionbtns .asset-open-btn,.itemfield.type-asset .items-single-view .item-header .actionbtns .asset-select-btn,.itemfield.type-asset .items-single-view .item-header .actionbtns .asset-swap-btn,.items-single-view .item-header .actionbtns .assets-list .item .select-btn,.items-single-view .item-header .actionbtns .btn,.items-single-view .item-header .actionbtns .itemfield.type-asset .asset-clear-btn,.items-single-view .item-header .actionbtns .itemfield.type-asset .asset-open-btn,.items-single-view .item-header .actionbtns .itemfield.type-asset .asset-select-btn,.items-single-view .item-header .actionbtns .itemfield.type-asset .asset-swap-btn,.items-single-view .item-header .actionbtns .langlinks a,.items-single-view .item-header .actionbtns .langlinks span,.items-single-view .item-header .actionbtns .modal .confirm-btns .confirm-cancel-btn,.items-single-view .item-header .actionbtns .modal .confirm-btns .confirm-ok-btn,.items-single-view .item-header .actionbtns .modal .msg-ok-btn,.items-single-view .item-header .actionbtns .modal-addblock .add-block-btn,.items-single-view .item-header .actionbtns .save-btn,.items-single-view .item-header .langlinks .actionbtns a,.items-single-view .item-header .langlinks .actionbtns span,.modal .confirm-btns .items-single-view .item-header .actionbtns .confirm-cancel-btn,.modal .confirm-btns .items-single-view .item-header .actionbtns .confirm-ok-btn,.modal .items-single-view .item-header .actionbtns .msg-ok-btn,.modal-addblock .items-single-view .item-header .actionbtns .add-block-btn{display:inline-block;margin-left:.5rem;margin-bottom:.5rem}.items-single-view .item-header .save-btn.inactive{pointer-events:none;opacity:.1}.items-single-view .item-header .langlinks a,.items-single-view .item-header .langlinks span{display:inline-block;text-transform:uppercase;margin-right:.5em}.items-single-view .item-header .langlinks .current{pointer-events:none}.items-single-view .card{position:relative}.items-single-view .published-toggle .label{font-size:11px;display:block;text-align:center;text-transform:uppercase;margin-bottom:4px}.items-single-view .published-toggle .toggle{margin:0 auto;width:50px;height:24px;background-color:rgba(0,0,0,.15);border-radius:999px;display:block;position:relative;-webkit-transition:all .1s cubic-bezier(.215,.61,.355,1);-o-transition:all .1s cubic-bezier(.215,.61,.355,1);transition:all .1s cubic-bezier(.215,.61,.355,1);cursor:pointer}.items-single-view .published-toggle .toggle:after{content:"";height:16px;width:20px;top:4px;left:4px;border-radius:999px;background-color:rgba(0,0,0,.3);position:absolute;-webkit-transition:all .2s cubic-bezier(.215,.61,.355,1);-o-transition:all .2s cubic-bezier(.215,.61,.355,1);transition:all .2s cubic-bezier(.215,.61,.355,1);pointer-events:none}.e404,.loginbox{position:absolute;top:50%;width:min(400px,90vw)}.field .label.has-helper .helpicon,.itemfield input .label.has-helper .helpicon,.tabs .tab{-webkit-transition:all .3s cubic-bezier(.215,.61,.355,1);-o-transition:all .3s cubic-bezier(.215,.61,.355,1);cursor:pointer}.items-single-view .published-toggle.published .toggle:after{left:24px;background-color:#000}.single-item-versions-table .create-version-btn,.single-item-versions-table .version-delete-btn,.single-item-versions-table .version-preview-btn{cursor:pointer;text-decoration:underline}.single-item-versions-table .create-version-btn:hover,.single-item-versions-table .version-delete-btn:hover,.single-item-versions-table .version-preview-btn:hover{opacity:.8}.single-item-versions-table .create-version-btn:active,.single-item-versions-table .version-delete-btn:active,.single-item-versions-table .version-preview-btn:active{opacity:.5}.e404{left:50%;transform:translate(-50%,-50%)}.loginbox,.modal-asset .asset-preview.is-other-format .title{-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%)}.e404 .code{opacity:.6;text-transform:uppercase;font-size:.7rem;margin-bottom:.4em}.e404 .title{font-weight:600;font-size:1.2rem;margin-bottom:.4em}.loginbox{left:50%;transform:translate(-50%,-50%);background-color:#333b44;padding:2rem;border-radius:8px;-webkit-animation:.5s a9682 cubic-bezier(.215,.61,.355,1);animation:.5s a9682 cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a9682{from{opacity:0;-webkit-transform:translate(-50%,-55%);transform:translate(-50%,-55%)}}@keyframes a9682{from{opacity:0;-webkit-transform:translate(-50%,-55%);transform:translate(-50%,-55%)}}.itemfield .loginbox.error input,.loginbox.error .field,.loginbox.error .itemfield input{-webkit-animation:170ms a9787 infinite linear;animation:170ms a9787 infinite linear}.itemfield .loginbox.error input input,.loginbox.error .field input,.loginbox.error .itemfield input input{background-color:#ECC}@-webkit-keyframes a9787{0%,100%{-webkit-transform:rotate(0);transform:rotate(0)}33%{-webkit-transform:rotate(-2deg);transform:rotate(-2deg)}66%{-webkit-transform:rotate(2deg);transform:rotate(2deg)}}@keyframes a9787{0%,100%{-webkit-transform:rotate(0);transform:rotate(0)}33%{-webkit-transform:rotate(-2deg);transform:rotate(-2deg)}66%{-webkit-transform:rotate(2deg);transform:rotate(2deg)}}.loginbox .logo{max-width:100px;margin:0 auto}.loginbox .logo svg{fill:var(--brand-color)}.loginbox .hint{font-size:.8rem;text-align:center;opacity:.7}.loginbox .loginbtns{display:grid;gap:1rem 1rem}.loginbox .hint-text{text-align:center}#app:not(.darkmode) .loginbox{background-color:#6a717a}#app:not(.darkmode) .loginbox .field .label,#app:not(.darkmode) .loginbox .hint,#app:not(.darkmode) .loginbox .itemfield input .label,.itemfield #app:not(.darkmode) .loginbox input .label{color:rgba(235,240,247,.8)}#app.darkmode .loginbox{background-color:#585f68}#app.darkmode .loginbox .field .label,#app.darkmode .loginbox .hint,#app.darkmode .loginbox .itemfield input .label,.itemfield #app.darkmode .loginbox input .label{color:rgba(235,240,247,.8)}.field,.itemfield input{position:relative;width:min(20rem,100%)}.field.full,.itemfield input.full{width:100%}.field .label,.itemfield input .label{font-size:.85rem;margin-bottom:.6rem}.assets-list-header select,.field input,.field select,.field textarea,.itemfield input input,.itemfield input select,.itemfield input textarea,.modal .prompt-input input,.modal .prompt-input select,.modal .prompt-input textarea,.modal-addblock input.filterinput,.modal-addblock select.filterinput,.modal-addblock textarea.filterinput,input.assets-list-search,input.items-list-search,input.styled,select.assets-list-search,select.items-list-search,select.styled,textarea.assets-list-search,textarea.items-list-search,textarea.styled{display:block;width:100%;border:none;background-color:#ebf0f7;color:#333b44;padding:.8em 1em;border-radius:8px}#app.darkmode .assets-list-header select,#app.darkmode .field input,#app.darkmode .field select,#app.darkmode .field textarea,#app.darkmode .itemfield input input,#app.darkmode .itemfield input select,#app.darkmode .itemfield input textarea,#app.darkmode .modal .prompt-input input,#app.darkmode .modal .prompt-input select,#app.darkmode .modal .prompt-input textarea,#app.darkmode .modal-addblock input.filterinput,#app.darkmode .modal-addblock select.filterinput,#app.darkmode .modal-addblock textarea.filterinput,#app.darkmode input.assets-list-search,#app.darkmode input.items-list-search,#app.darkmode input.styled,#app.darkmode select.assets-list-search,#app.darkmode select.items-list-search,#app.darkmode select.styled,#app.darkmode textarea.assets-list-search,#app.darkmode textarea.items-list-search,#app.darkmode textarea.styled,.assets-list-header #app.darkmode select,.field #app.darkmode input,.field #app.darkmode select,.field #app.darkmode textarea,.itemfield #app.darkmode input input,.itemfield #app.darkmode input select,.itemfield #app.darkmode input textarea,.itemfield input #app.darkmode input,.itemfield input #app.darkmode select,.itemfield input #app.darkmode textarea,.modal .prompt-input #app.darkmode input,.modal .prompt-input #app.darkmode select,.modal .prompt-input #app.darkmode textarea,.modal-addblock #app.darkmode input.filterinput,.modal-addblock #app.darkmode select.filterinput,.modal-addblock #app.darkmode textarea.filterinput{background-color:#333b44;color:#fff}.field .label.has-helper,.itemfield input .label.has-helper{width:100%;display:inline-block;position:relative}.field .label.has-helper .helpicon,.itemfield input .label.has-helper .helpicon{position:absolute;top:-4px;right:0;height:20px;width:20px;font-size:12px;line-height:20px;text-align:center;border-radius:999px;background-color:rgba(0,0,0,.2);opacity:.3;transition:all .3s cubic-bezier(.215,.61,.355,1)}.tagfield,.tagfield .tagbtn{font-size:1rem;border-radius:8px}.field .label.has-helper .helpicon:hover,.itemfield input .label.has-helper .helpicon:hover{opacity:.7}.field .label.has-helper .helpicon:active,.itemfield input .label.has-helper .helpicon:active{opacity:.35}textarea.codearea{display:block;width:100%;background-color:#000;color:#AAA;font-family:monospace;font-weight:300;padding:1em;border:none;height:max(50vh,400px)}textarea.codearea.invalid{background-color:#300}.tagfield{background-color:#ebf0f7;color:#333b44;padding:.8em 1em}#app.darkmode .tagfield{background-color:#333b44;color:#fff}.tagfield .tagbtns{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;gap:.3em .3em}.tagfield .tagbtn{position:relative;background-color:rgba(0,0,0,.2);padding:.4em .8em;overflow:hidden}.tagfield .tagbtn:not(.--add){padding-right:2.3em}.tagfield .tagbtn .label{pointer-events:none}.tagfield .tagbtn .remove{position:absolute;top:0;background-color:rgba(0,0,0,.1);right:0;opacity:.5;padding:.4em .5em .4em .4em;cursor:pointer}.tagfield .tagbtn .remove:hover{opacity:1}.tagfield .tagbtn .remove:active{opacity:.4}.tagfield .tagbtn.--add{opacity:.5;cursor:pointer}.tagfield .tagbtn.--add:hover{opacity:1}.tagfield .tagbtn.--add:active{opacity:.2}.code-editor{position:relative;min-height:300px;-webkit-animation:ao9282 .2s cubic-bezier(.215,.61,.355,1);animation:ao9282 .2s cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes ao9282{from{opacity:0}}@keyframes ao9282{from{opacity:0}}.code-editor.unready textarea{opacity:0}.code-editor .invalid-code{background-color:rgba(255,0,0,.3);color:red;padding:.8em 1.3em;position:absolute;top:20px;right:20px}.modal-asset .asset-preview.is-other-format{aspect-ratio:3/2;background-color:rgba(0,0,0,.2);color:#333b44;display:grid;-webkit-box-align:center;-ms-flex-align:center;align-items:center;justify-items:center;position:relative}.modal-asset .asset-preview.is-other-format .format{position:absolute;top:0;right:0;padding:.5em 1em;text-transform:uppercase;font-size:.7rem;background-color:#000;color:#fff}.modal-asset .asset-preview.is-other-format .title{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}#app.darkmode .modal-asset .asset-preview.is-other-format{background-color:rgba(0,0,0,.2);color:#fff}.assets-list-header{display:grid;grid-template-columns:1fr 200px 200px;gap:15px;margin-bottom:1rem}@media (max-width:700px){.assets-list-header{grid-template-columns:1fr}}.assets-list-search{display:inline-block}.assets-list{display:grid;grid-template-columns:repeat(auto-fill,minmax(150px,1fr));gap:2rem 2rem}.assets-list .item{background-color:#fff;aspect-ratio:1/1;position:relative;-webkit-box-shadow:5px 0 20px rgba(0,0,0,.1);box-shadow:5px 0 20px rgba(0,0,0,.1);cursor:pointer;overflow:hidden;-webkit-transition:all .2s cubic-bezier(.215,.61,.355,1);-o-transition:all .2s cubic-bezier(.215,.61,.355,1);transition:all .2s cubic-bezier(.215,.61,.355,1)}.assets-list .item:hover{opacity:.9}.assets-list .item:active{opacity:.7}#app.darkmode .assets-list .item{background-color:#333b44}.assets-list .item .format{padding:.4em .8em .3em;position:absolute;top:0;left:0;background-color:rgba(0,0,0,.7);color:#fff;pointer-events:none;text-transform:uppercase;font-size:.8rem;letter-spacing:.1em}.assets-list .item .title{position:absolute;top:50%;left:0;width:100%;padding:.3em .5em;text-align:center;-webkit-transform:translateY(-50%);-ms-transform:translateY(-50%);transform:translateY(-50%);color:#000;pointer-events:none;font-size:.7rem;word-break:break-word}.assets-list .item .select-btn,.keyman .modal,.modal .popup{-webkit-transform:translate(-50%,-50%)}#app.darkmode .assets-list .item .title{color:#fff}.assets-list .item .asset-preview{position:absolute;top:0;left:0;width:100%;height:100%;background-color:#DDD}.assets-list .item .asset-preview img,.assets-list .item .asset-preview video{position:absolute;top:0;left:0;width:100%;height:100%;-o-object-fit:contain;object-fit:contain;-o-object-position:center;object-position:center;pointer-events:none}#app.darkmode .assets-list .item .asset-preview{background-color:rgba(0,0,0,.5)}.assets-list .item .select-btn{position:absolute;top:50%;left:50%;-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%)}.assets-list .item .select-overlay{position:absolute;top:0;left:0;width:100%;height:100%}.assets-list .item .checkmark{height:30px;width:30px;position:absolute;bottom:0;left:0;background-color:rgba(255,255,255,.8);color:#000;font-size:0;cursor:pointer;text-align:center;-ms-flex-line-pack:center;align-content:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;display:none;opacity:.8;-webkit-transform-origin:bottom left;-ms-transform-origin:bottom left;transform-origin:bottom left;-webkit-animation:a22342 .2s cubic-bezier(.215,.61,.355,1);animation:a22342 .2s cubic-bezier(.215,.61,.355,1)}.modal,.modal .dim{width:100%;height:100%;top:0;left:0}.assets-list .item .checkmark:hover{opacity:1}@-webkit-keyframes a22342{from{-webkit-transform:translateX(-100%);transform:translateX(-100%)}}@keyframes a22342{from{-webkit-transform:translateX(-100%);transform:translateX(-100%)}}.keyman .modal,.modal .popup{-ms-transform:translate(-50%,-50%)}.assets-list .item:hover .checkmark,.assets-list.has-checked-items .item .checkmark{display:grid}.assets-list .item.checked .checkmark{font-size:16px}#app.darkmode .assets-list .item .checkmark{background-color:rgba(0,0,0,.8);color:#fff}.modal{position:fixed}.modal .dim{position:absolute;background-color:rgba(51,59,68,.3);-webkit-animation:a8242 .3s cubic-bezier(.215,.61,.355,1);animation:a8242 .3s cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a8242{from{opacity:0}}@keyframes a8242{from{opacity:0}}#app.darkmode .modal .dim{background-color:rgba(0,0,0,.5)}.modal.no-dim-click .dim{pointer-events:none}.modal .popup{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:90%;max-width:400px;max-height:90vh;background:#FFF;color:#333b44;overflow-y:auto;border-radius:8px;-webkit-box-shadow:0 10px 30px rgba(0,0,0,.15);box-shadow:0 10px 30px rgba(0,0,0,.15);-webkit-animation:a8221321 .2s cubic-bezier(.215,.61,.355,1);animation:a8221321 .2s cubic-bezier(.215,.61,.355,1)}@-webkit-keyframes a8221321{from{opacity:0;-webkit-transform:translate(-50%,-55%);transform:translate(-50%,-55%)}}@keyframes a8221321{from{opacity:0;-webkit-transform:translate(-50%,-55%);transform:translate(-50%,-55%)}}.modal .popup>.title{padding:1.5rem;background-color:#CCC;color:#333b44;position:relative}.modal .popup>.inner{padding:1.5rem}.modal .popup>.closer{position:absolute;top:10px;right:10px;width:36px;height:36px;line-height:36px;text-align:center;background-color:transparent;color:#333b44;border-radius:999px;cursor:pointer}.modal .popup>.closer:hover{opacity:.8}.modal .popup>.closer:active{opacity:.6}.modal .popup>.title .closer{top:50%;-webkit-transform:translateY(-50%);-ms-transform:translateY(-50%);transform:translateY(-50%);background-color:transparent;right:10px}#app.darkmode .modal .popup{background-color:#282e35;color:#FFF}#app.darkmode .modal .popup .title{background-color:#333b44;color:#CCC}#app.darkmode .modal .popup .closer{background-color:transparent;color:#CCC}.modal.type-msg .confirm,.modal.type-msg .inner{text-align:center}.modal .prompt-input{margin-top:2em}.modal .confirm-btns{margin-top:2em;display:grid;gap:1rem}.modal-fields .popup{width:90%;max-width:700px;max-height:90vh}.itemfield .modal-fields input,.modal-fields .field,.modal-fields .itemfield input{width:100%}.modal-asset .popup,.modal-assets .popup{width:90%;max-width:1000px}.modal-assets .popup{max-height:90vh}.modal-assets .popup .assets-list{max-height:50vh;overflow-y:auto}.itemfield .modal-addtag input,.modal-addtag .field,.modal-addtag .itemfield input{width:100%}.previewframe{z-index:80}.modal{z-index:83}.modal-addblock,.modal-cloner{z-index:84}.modal-fields{z-index:85}.modal-assets{z-index:86}.modal-asset{z-index:87}.modal-richtext{z-index:88}.modal-addtag,.modal-x{z-index:89}.blockpreview .richtext,.itemfield .richtext-preview,.richtext-preview-content{font-family:Helvetica,sans-serif,Arial;font-size:16px;letter-spacing:0;font-weight:400}.blockpreview .richtext *,.itemfield .richtext-preview *,.richtext-preview-content *{font-size:inherit;font-family:inherit;letter-spacing:inherit;font-weight:inherit}.blockpreview .richtext h1,.itemfield .richtext-preview h1,.richtext-preview-content h1{font-size:1.6em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext h2,.itemfield .richtext-preview h2,.richtext-preview-content h2{font-size:1.5em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext h3,.itemfield .richtext-preview h3,.richtext-preview-content h3{font-size:1.4em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext h4,.itemfield .richtext-preview h4,.richtext-preview-content h4{font-size:1.3em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext h5,.itemfield .richtext-preview h5,.richtext-preview-content h5{font-size:1.2em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext h6,.itemfield .richtext-preview h6,.richtext-preview-content h6{font-size:1.1em;font-weight:700;margin-bottom:.3em;line-height:1em}.blockpreview .richtext ol,.blockpreview .richtext p,.blockpreview .richtext ul,.itemfield .richtext-preview ol,.itemfield .richtext-preview p,.itemfield .richtext-preview ul,.richtext-preview-content ol,.richtext-preview-content p,.richtext-preview-content ul{margin-bottom:1em}.blockpreview .richtext b,.blockpreview .richtext strong,.itemfield .richtext-preview b,.itemfield .richtext-preview strong,.richtext-preview-content b,.richtext-preview-content strong{font-weight:900}.blockpreview .richtext em,.blockpreview .richtext i,.itemfield .richtext-preview em,.itemfield .richtext-preview i,.richtext-preview-content em,.richtext-preview-content i{font-style:italic}.blockpreview .richtext ol,.blockpreview .richtext ul,.itemfield .richtext-preview ol,.itemfield .richtext-preview ul,.richtext-preview-content ol,.richtext-preview-content ul{margin-left:1.5em}.modal-richtext .popup{max-width:1000px}.modal-richtext .richtext-container{min-height:400px;margin-bottom:1rem}.modal-richtext .tox-statusbar__branding{opacity:.3;pointer-events:none}#app.darkmode .modal-richtext .popup{background-color:#DDD;color:#000}.icon-preview{background-color:rgba(51,59,68,.1);font-size:.8rem;height:2.2rem;width:2.2rem;border-radius:999px;display:grid;-webkit-box-align:center;-ms-flex-align:center;align-items:center;justify-items:center;pointer-events:none}#app.darkmode .icon-preview{background-color:rgba(255,255,255,.05)}.modal-addblock .popup{padding:12px}.modal-addblock .popup>.inner{padding:0}.modal-addblock .filterinput{margin-bottom:12px}.modal-addblock .add-block-btns{overflow-y:auto}.modal-addblock .add-block-btns .inner{max-height:200px;display:grid;grid-template-columns:1fr;gap:.5em .5em}.modal-addblock .add-block-btn{text-align:left}.previewframe{position:fixed;top:0;right:0;height:100vh;width:50vw;background-color:#333b44;display:none;overflow:hidden}#app.preview-frame .previewframe{display:block}.previewframe iframe{position:absolute;left:0;width:100%;top:38px;height:calc(100% - 38px);border:none}#app.preview-frame-mobile-mode .previewframe iframe{left:calc(50% - 300px);width:600px}.previewframe .topbar{height:38px;line-height:36px;position:absolute;top:0;left:0;width:100%;background-color:#333b44;display:grid;grid-template-columns:50px 1fr 50px 50px 50px;gap:2px}.itemfield.type-asset .asset-field-container,.tabs{position:relative}.previewframe .url{height:36px;line-height:36px;border-radius:0;background-color:transparent;padding:0 1em;border:none;background-color:rgba(0,0,0,.2);color:#fff}.previewframe .url:focus{outline:0}.previewframe .close-btn,.previewframe .home-btn,.previewframe .mobile-btn,.previewframe .refresh-btn{height:36px;line-height:36px;font-size:18px;text-align:center;background-color:rgba(255,255,255,.1);color:#fff;cursor:pointer}.blockpreview .richtext,.itemfield .richtext-preview{font-size:11px;max-height:7em;overflow:hidden}.previewframe .close-btn:hover,.previewframe .home-btn:hover,.previewframe .mobile-btn:hover,.previewframe .refresh-btn:hover{opacity:.8}.previewframe .close-btn:active,.previewframe .home-btn:active,.previewframe .mobile-btn:active,.previewframe .refresh-btn:active{opacity:.6}.items-single-view .item-header .langlinks .previewframe .close-btn.current,.items-single-view .item-header .langlinks .previewframe .home-btn.current,.items-single-view .item-header .langlinks .previewframe .mobile-btn.current,.items-single-view .item-header .langlinks .previewframe .refresh-btn.current,.previewframe .close-btn.depressed,.previewframe .home-btn.depressed,.previewframe .items-single-view .item-header .langlinks .close-btn.current,.previewframe .items-single-view .item-header .langlinks .home-btn.current,.previewframe .items-single-view .item-header .langlinks .mobile-btn.current,.previewframe .items-single-view .item-header .langlinks .refresh-btn.current,.previewframe .mobile-btn.depressed,.previewframe .refresh-btn.depressed{opacity:.4}.itemfields{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr))}.itemfield{padding:1.5rem;border:1px solid rgba(0,0,0,.1)}#app.darkmode .itemfield{border:1px solid rgba(255,255,255,.1)}.tabs{-webkit-box-shadow:inset 0 -2px rgba(51,59,68,.3);box-shadow:inset 0 -2px rgba(51,59,68,.3);margin-bottom:1.3rem}.tabs .tab{display:inline-block;padding:.7em .8em;transition:all .3s cubic-bezier(.215,.61,.355,1);color:rgba(51,59,68,.3)}.tabs .tab:hover{color:rgba(51,59,68,.5);-webkit-box-shadow:inset 0 -4px rgba(51,59,68,.4);box-shadow:inset 0 -4px rgba(51,59,68,.4)}.tabs .tab:active{opacity:.4}.tabs .tab.active{color:#333b44;-webkit-box-shadow:inset 0 -4px #333b44;box-shadow:inset 0 -4px #333b44}#app.darkmode .tabs{-webkit-box-shadow:inset 0 -2px rgba(255,255,255,.1);box-shadow:inset 0 -2px rgba(255,255,255,.1)}#app.darkmode .tabs .tab{color:rgba(255,255,255,.3)}#app.darkmode .tabs .tab:hover{color:rgba(255,255,255,.5);-webkit-box-shadow:inset 0 -4px rgba(255,255,255,.4);box-shadow:inset 0 -4px rgba(255,255,255,.4)}#app.darkmode .tabs .tab.active{color:#fff;-webkit-box-shadow:inset 0 -4px #fff;box-shadow:inset 0 -4px #fff}.itemfield .asset-preview{background-color:rgba(0,0,0,.1);padding:8px}.itemfield .asset-preview img,.itemfield .asset-preview video{max-width:300px;margin:0 auto}.itemfield .richtext-preview{background-color:#ebf0f7;padding:1em;border-radius:4px;margin-bottom:1rem;cursor:pointer}.itemfield .richtext-preview a{pointer-events:none}#app.darkmode .itemfield .richtext-preview{background-color:#333b44}.field.type-checkbox input,.itemfield input.type-checkbox input{margin:1rem 0 1.5rem;height:1.35rem;width:1.35rem}.itemfield.type-asset .asset-field-container.-set{min-height:80px;background-color:rgba(0,0,0,.1)}.itemfield.type-asset .asset-clear-btn,.itemfield.type-asset .asset-open-btn,.itemfield.type-asset .asset-swap-btn{position:absolute;padding:6px;border:none;border-radius:4px;-webkit-box-shadow:0 2px 6px rgba(0,0,0,.2);box-shadow:0 2px 6px rgba(0,0,0,.2)}.itemfield.type-asset .asset-clear-btn{top:14px;right:14px}.itemfield.type-asset .asset-open-btn{top:14px;left:14px}.itemfield.type-asset .asset-swap-btn{top:44px;left:14px}.itemfield.type-color .colorfield{display:grid;grid-template-columns:50px 1fr;gap:10px 10px}.itemfield.type-color .colorfield input:nth-child(1){border:1px solid #777;padding:0;height:2.6rem;overflow:hidden;border-radius:1px}.itemfield .repeater{margin-top:.5em}.itemfield .repeater .rows{display:grid;grid-template-columns:1fr;gap:10px 10px}.itemfield .repeater .row{position:relative;padding-top:32px;border-radius:6px;overflow:hidden}.itemfield .repeater .row-clicker{position:absolute;top:0;left:0;width:32px;width:100%;height:32px;line-height:32px;font-size:.8rem;padding:0 1em;cursor:pointer;background-color:#ebf0f7}.itemfield .repeater .row-clicker:hover{background-color:#d9e2f0}.itemfield .repeater .row-clicker:active{background-color:#c7d5e8}#app.darkmode .itemfield .repeater .row-clicker{background-color:rgba(255,255,255,.1)}#app.darkmode .itemfield .repeater .row-clicker:hover{background-color:rgba(255,255,255,.15)}#app.darkmode .itemfield .repeater .row-clicker:active{background-color:rgba(255,255,255,.1)}.itemfield .repeater .row-num{position:absolute;top:0;left:0;display:inline-block;white-space:nowrap;overflow:hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;width:32px;height:32px;line-height:32px;font-size:.8rem;padding:0 1em;background-color:rgba(51,59,68,.1);pointer-events:none}.itemfield .repeater .row-autotitle,.itemfield .repeater .row-title,.itemfield .repeater .row-titlepreview{position:absolute;top:0;left:32px;display:inline-block;white-space:nowrap;overflow:hidden;-o-text-overflow:ellipsis;width:calc(100% - 148px);text-overflow:ellipsis;height:32px;line-height:32px;font-size:.8rem;padding:0 .5em;pointer-events:none}.itemfield .repeater .row-titlepreview .text{font-size:1em;overflow:hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis}.itemfield .repeater .row-titlepreview .asset{position:relative;height:32px;z-index:0}.itemfield .repeater .row-titlepreview .asset .img{position:relative;height:100%;-webkit-box-shadow:inset -70px 0 40px -30px #EAEBEC;box-shadow:inset -70px 0 40px -30px #EAEBEC}.itemfield .repeater .row-titlepreview .asset .img img{position:absolute;top:0;left:0;width:100%;height:100%;-o-object-fit:cover;object-fit:cover;-o-object-position:center;object-position:center;z-index:-1}#app.darkmode .itemfield .repeater .row-titlepreview .asset .img{-webkit-box-shadow:inset -70px 0 40px -30px #3E434A;box-shadow:inset -70px 0 40px -30px #3E434A}.itemfield .repeater .row-blockname{position:absolute;top:0;left:29px;display:inline-block;width:auto;white-space:nowrap;max-width:calc(100% - 100px);overflow:hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;height:32px;line-height:32px;font-size:.8rem;padding:0 1em;pointer-events:none}.itemfield .repeater .rbtns{position:absolute;top:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;height:32px;line-height:32px}.itemfield .repeater .rbtn{width:28px;height:32px;line-height:32px;text-align:center;color:#333b44;cursor:pointer}#app.darkmode .itemfield .repeater .rbtn,.tippy-box{color:#fff}.itemfield .repeater .rbtn:hover{background-color:rgba(51,59,68,.2)}.itemfield .repeater .rbtn:active{background-color:rgba(51,59,68,.4)}.itemfield .repeater .rbtn.sure{background-color:#F99}.itemfield .repeater .rbtn.cannot{opacity:.3}.itemfield .repeater .rbtn *{font-size:.9rem}#app.darkmode .itemfield .repeater .rbtn:hover{background-color:rgba(255,255,255,.2)}#app.darkmode .itemfield .repeater .rbtn:active{background-color:rgba(255,255,255,.4)}#app.darkmode .itemfield .repeater .rbtn.sure{background-color:#F99}.itemfield .repeater .add-row-btn{display:inline-block;cursor:pointer;width:100%;height:32px;line-height:32px;padding:0 .5em;text-align:center;font-size:.8rem;background-color:#ebf0f7;border-radius:6px}.itemfield .repeater .add-row-btn:hover{background-color:#d9e2f0}.itemfield .repeater .add-row-btn:active{background-color:#c7d5e8}#app.darkmode .itemfield .repeater .add-row-btn{background-color:rgba(255,255,255,.05)}#app.darkmode .itemfield .repeater .add-row-btn:hover{background-color:rgba(255,255,255,.1)}#app.darkmode .itemfield .repeater .add-row-btn:active{background-color:rgba(255,255,255,.05)}.field.type-blocks,.itemfield input.type-blocks{margin:0 auto;width:min(600px,100%)}.itemfield.type-blocks .add-block-btns,.itemfield.type-blocks .blocks{max-width:700px}.itemfield.type-blocks .blocks{margin-top:.5em;position:relative}.itemfield.type-blocks .blocks .rows{display:grid;grid-template-columns:1fr;gap:0 0}.itemfield.type-blocks .blocks .row{position:relative;padding-top:32px}.itemfield.type-blocks .blocks .add-row-btn{background-color:transparent;opacity:0;height:24px;line-height:24px}.itemfield.type-blocks .blocks .add-row-btn:hover{opacity:1;background-color:rgba(0,0,0,.025)}.itemfield.type-blocks .blocks .add-row-btn:active{opacity:.6}.itemfield.type-blocks .add-row-btn.before{height:24px;line-height:24px;opacity:.5;margin-bottom:5px}.itemfield.type-blocks .add-row-btn.before:hover{opacity:1}.itemfield.type-blocks .row:last-of-type .add-row-btn{height:24px;line-height:24px;opacity:.5;margin-top:5px}.itemfield.type-blocks .row:last-of-type .add-row-btn:hover{opacity:1}.itemfield.type-blocks .blocks.empty .add-row-btn.before{opacity:1;background-color:rgba(0,0,0,.05);height:32px;line-height:32px}.itemfield.type-blocks .blockpreview-container{position:relative;cursor:pointer;background-color:rgba(0,0,0,.1)}.itemfield.type-blocks .blockpreview-container:hover{opacity:.8}.itemfield.type-blocks .blockpreview-container:not(.has-preview){display:none}#app.darkmode .blockpreview-container{background-color:rgba(255,255,255,.06)}.blockpreview{padding:20px;font-size:12px;line-height:1.3;pointer-events:none}.blockpreview .cols-auto{position:relative;display:grid;gap:1rem;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));-webkit-box-align:center;-ms-flex-align:center;align-items:center;justify-items:center}.blockpreview .img,.blockpreview .video{max-width:200px;margin:0 auto}.geomap-container{position:relative}.geomap-container .map{background-color:rgba(0,0,0,.1);width:100%;aspect-ratio:1.5/1;min-height:25vh}.geomap-container .crosshair{position:absolute;width:30px;height:30px;border:2px solid #000;margin-left:-15px;margin-top:-15px;pointer-events:none;top:50%;left:50%;border-radius:999px}.geomap-container .crosshair:after,.geomap-container .crosshair:before{content:"";display:block;width:80px;height:80px}.geomap-container .crosshair:before{position:absolute;top:-67px;left:-67px;-webkit-box-shadow:inset -1px -1px 0 0 rgba(0,0,0,.6);box-shadow:inset -1px -1px 0 0 rgba(0,0,0,.6)}.geomap-container .crosshair:after{position:absolute;top:12px;left:12px;-webkit-box-shadow:inset 1px 1px 0 0 rgba(0,0,0,.6);box-shadow:inset 1px 1px 0 0 rgba(0,0,0,.6)}.spacer{height:1.5rem}.spaced{display:grid;gap:1.5rem}div[class*=grid-]{display:grid;gap:40px}.grid-111{grid-template-columns:1fr 1fr 1fr}.grid-1111{grid-template-columns:1fr 1fr 1fr 1fr}.grid-211{grid-template-columns:2fr 1fr 1fr}.grid-112{grid-template-columns:1fr 1fr 2fr}.grid-223{grid-template-columns:2fr 2fr 3fr}@media (max-width:700px){.grid-11,.grid-111,.grid-1111,.grid-112,.grid-211,.grid-223{grid-template-columns:1fr}}.pagination{font-size:0;text-align:center;margin-top:1rem}.pagination .next,.pagination .num,.pagination .prev{font-size:.8rem;display:inline-block;height:2.5em;width:2.5em;line-height:2.5em;background-color:rgba(51,59,68,.1);opacity:.4;cursor:pointer}.pagination .next:hover,.pagination .num:hover,.pagination .prev:hover{opacity:1}.pagination .next:active,.pagination .num:active,.pagination .prev:active{opacity:.3}.pagination .next.active,.pagination .num.active,.pagination .prev.active{opacity:1;background-color:rgba(51,59,68,.2);pointer-events:none}.pagination .next.off,.pagination .num.off,.pagination .prev.off{opacity:.3;pointer-events:none}#app.darkmode .pagination .next,#app.darkmode .pagination .num,#app.darkmode .pagination .prev{background-color:rgba(255,255,255,.1)}#app.darkmode .pagination .next.active,#app.darkmode .pagination .num.active,#app.darkmode .pagination .prev.active{background-color:rgba(255,255,255,.2)}.filedropzone{position:fixed;top:0;left:0;width:100vw;height:100vh;z-index:9999}.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#1a1e22;border-radius:6px;font-size:12px;line-height:1.4;white-space:normal;outline:0;-webkit-transition-property:visibility,opacity,-webkit-transform;-o-transition-property:transform,visibility,opacity;transition-property:transform,visibility,opacity;transition-property:transform,visibility,opacity,-webkit-transform}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;-webkit-transform-origin:center top;-ms-transform-origin:center top;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;-webkit-transform-origin:center bottom;-ms-transform-origin:center bottom;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;-webkit-transform-origin:center left;-ms-transform-origin:center left;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;-webkit-transform-origin:center right;-ms-transform-origin:center right;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{-webkit-transition-timing-function:cubic-bezier(.54,1.5,.38,1.11);-o-transition-timing-function:cubic-bezier(.54,1.5,.38,1.11);transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#1a1e22}.tippy-arrow:before{content:"";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 12px;z-index:1}.tippy-box[data-animation=scale-subtle][data-placement^=top]{-webkit-transform-origin:bottom;-ms-transform-origin:bottom;transform-origin:bottom}.tippy-box[data-animation=scale-subtle][data-placement^=bottom]{-webkit-transform-origin:top;-ms-transform-origin:top;transform-origin:top}.tippy-box[data-animation=scale-subtle][data-placement^=left]{-webkit-transform-origin:right;-ms-transform-origin:right;transform-origin:right}.tippy-box[data-animation=scale-subtle][data-placement^=right]{-webkit-transform-origin:left;-ms-transform-origin:left;transform-origin:left}.tippy-box[data-animation=scale-subtle][data-state=hidden]{-webkit-transform:scale(.8);-ms-transform:scale(.8);transform:scale(.8);opacity:0}.keyman{position:fixed;top:0;left:0;width:100vw;height:100vh;z-index:5555;pointer-events:none;background-color:transparent}.keyman.visible{pointer-events:all}.keyman .dim{position:absolute;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,.1);opacity:0;transition:all 150ms cubic-bezier(.215,.61,.355,1)}.keyman.visible .dim{opacity:1}.keyman .modal{position:absolute;top:50%;left:50%;width:300px;height:auto;background-color:rgba(255,255,255,.7);-webkit-backdrop-filter:blur(20px);backdrop-filter:blur(20px);color:#000;border-radius:10px;z-index:5555;padding:2rem;-webkit-box-shadow:0 0 30px rgba(0,0,0,.2);box-shadow:0 0 30px rgba(0,0,0,.2);opacity:0;transform:translate(-50%,-50%);text-align:center;-webkit-transition:all 150ms cubic-bezier(.215,.61,.355,1);-o-transition:all 150ms cubic-bezier(.215,.61,.355,1);transition:all 150ms cubic-bezier(.215,.61,.355,1)}.keyman.visible .modal{-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%);opacity:1}.keyman .input{display:block;width:100%;font-size:2rem;font-weight:700;text-align:center;border:none;background-color:transparent}.keyman .matches,.keyman .nomatches{font-size:1rem;padding:.4em 0;margin-top:1rem;line-height:1.1}.keyman .input:focus{outline:0}.keyman .nomatches{opacity:.5}.keyman .matches .match{margin:.5em 0}.keyman .matches .match.focused{background-color:rgba(0,0,0,.1)}.license-needed{position:fixed;bottom:0;left:0;width:100vw;padding:1em;background-color:#f88;color:#fff!important;z-index:9999999;text-align:center;text-decoration:none}.hide{display:none}.align-r{text-align:right}.align-c{text-align:center}</style><!--ADMIN-INJECTABLE-CSS--></head><body><div id="apploader" v-if="show_apploader"><div class="apploader-spinner"><div></div></div></div><div id="app" :class="app_cls" v-if="!show_apploader" @dragenter="onFileDragEnter($event)" @dragover.stop="onFileDragOver($event)" @dragleave.stop="onFileDragLeave($event)" @drop.stop="onfileDropped($event)"><left-bar v-if="show_lbar"></left-bar><div id="main" v-if="show_main"><div id="main-header">Main header</div><div id="main-inner"><view-home v-if="isView('home')"></view-home><items-list v-if="isView('items-list')" :key="'itemslist-'+url_params.type"></items-list><item-single v-if="isView('item-single')" :key="'itemslist-'+url_params.type+'-uid-'+url_params.uid"></item-single><view-settings v-if="isView('settings')"></view-settings><view-settings-assets v-if="isView('settings-assets')"></view-settings-assets><view-language v-if="isView('language')"></view-language><view-strings v-if="isView('strings')"></view-strings><view-custom v-if="isView('custom')" :key="url_params?.slug"></view-custom><assets v-if="isView('assets')"></assets><template v-if="isView('code-editor')"><loading type="spinner" v-if="!cms_config"></loading><view-code-editor v-if="cms_config"></view-code-editor></template><template v-if="isView('e404')"><div class="e404"><div class="code">{{str('e404_pretitle')}}</div><div class="title">{{str('e404_title')}}</div><div class="text">{{str('e404_text')}}</div><p></p></div></template></div><div id="main-footer">Main footer</div></div><view-login v-if="isView('login')"></view-login><div class="previewframe" v-if="previewFrame.active"><div class="topbar"><div class="home-btn" @click="setPreviewFrameHome()"><ic>home</ic></div><input class="url" type="text" :value="$store.state.previewFrame.url"><div class="refresh-btn" @click="refreshPreviewFrame()"><ic>refresh</ic></div><div class="mobile-btn" @click="togglePreviewFrameMobileMode()" :class="{depressed:$store.state.previewFrame.mobile_mode}"><ic>smartphone</ic></div><div class="close-btn" @click="setPreviewFrame(false)"><ic>close</ic></div></div><div class="loader"></div><iframe :src="previewFrame.url"></iframe></div><modal-cloner v-if="$store.state.modal_cloner.active"></modal-cloner><modal-assets v-if="$store.state.modal_assets.active"></modal-assets><modal-asset v-if="$store.state.modal_asset.active"></modal-asset><modal-fields v-if="$store.state.modal_fields.active"></modal-fields><modal-richtext v-if="$store.state.modal_richtext.active"></modal-richtext><modal-addblock v-if="$store.state.modal_addblock.active"></modal-addblock><modal-addtag v-if="$store.state.modal_addtag.active"></modal-addtag><keyman></keyman><div v-if="fileDraggedOver" class="filedropper-overlay"></div></div><script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js" integrity="sha512-bLT0Qm9VnAYZDflyKcBaQ2gg0hSYNQrJ8RilYldYQ1FxQYoCLtUjuuRuZo+fjqhx/qtq/1itJ0C2ejDxltZVFg==" crossorigin="anonymous"></script><script src="//cdnjs.cloudflare.com/ajax/libs/object-path/0.11.8/index.js" integrity="sha512-AO2T+DtwpdfxTkxMucC1r4NYzn21jgjtaSyvnlm8aUJIAao2qGVSnUQNIOyrK4o5FCDellRX77QbVGC3gn7Ppg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script src="//cdnjs.cloudflare.com/ajax/libs/vue/2.6.12/vue.min.js" crossorigin="anonymous"></script><script src="//cdnjs.cloudflare.com/ajax/libs/vuex/3.6.2/vuex.min.js" integrity="sha512-Tkxwo8dZEZTmje5QT9uodCqe2XGbZdBXU8uC4nskBt0kwR99Anzkz8JCSMByfoqjLTHcTuIB8fsmED3b9Ljp3g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js" integrity="sha512-lbwH47l/tPXJYG9AcFNoJaTMhGvYWhVM9YI43CT+uteTRRaiLCui8snIgyAN8XWgNjNhCqlAUdzZptso6OCoFQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js" integrity="sha512-6UofPqm0QupIL0kzS/UIzekR73/luZdC6i/kXDbWnLOJoqwklBK6519iUnShaYceJ0y4FaiPtX/hRnV/X/xlUQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/tippy.js/6.3.7/tippy.umd.min.js" integrity="sha512-2TtfktSlvvPzopzBA49C+MX6sdc7ykHGbBQUTH8Vk78YpkXVD5r6vrNU+nOmhhl1MyTWdVfxXdZfyFsvBvOllw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js" integrity="sha512-Eezs+g9Lq4TCCq0wae01s9PuNWzHYoCMkE97e2qdkYthpI0pzC3UGB03lgEHn2XM85hDOUF6qgqqszs+iXU4UA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><script>var klayphp2js = 'php-injected-data-here';</script><script>"use strict";function ownKeys(t,e){var i,n=Object.keys(t);return Object.getOwnPropertySymbols&&(i=Object.getOwnPropertySymbols(t),e&&(i=i.filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),n.push.apply(n,i)),n}function _objectSpread(t){for(var e=1;e<arguments.length;e++){var i=null!=arguments[e]?arguments[e]:{};e%2?ownKeys(Object(i),!0).forEach(function(e){_defineProperty(t,e,i[e])}):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(i)):ownKeys(Object(i)).forEach(function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(i,e))})}return t}function _createForOfIteratorHelper(e,t){var i;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(i=_unsupportedIterableToArray(e))||t&&e&&"number"==typeof e.length){i&&(e=i);var n=0,s=function(){};return{s:s,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:s}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var a,o=!0,l=!1;return{s:function(){i=e[Symbol.iterator]()},n:function(){var e=i.next();return o=e.done,e},e:function(e){l=!0,a=e},f:function(){try{o||null==i.return||i.return()}finally{if(l)throw a}}}}function _toConsumableArray(e){return _arrayWithoutHoles(e)||_iterableToArray(e)||_unsupportedIterableToArray(e)||_nonIterableSpread()}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function _iterableToArray(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}function _arrayWithoutHoles(e){if(Array.isArray(e))return _arrayLikeToArray(e)}function _slicedToArray(e,t){return _arrayWithHoles(e)||_iterableToArrayLimit(e,t)||_unsupportedIterableToArray(e,t)||_nonIterableRest()}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function _unsupportedIterableToArray(e,t){if(e){if("string"==typeof e)return _arrayLikeToArray(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);return"Object"===i&&e.constructor&&(i=e.constructor.name),"Map"===i||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?_arrayLikeToArray(e,t):void 0}}function _arrayLikeToArray(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function _iterableToArrayLimit(e,t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e)){var i=[],n=!0,s=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(n=(o=l.next()).done)&&(i.push(o.value),!t||i.length!==t);n=!0);}catch(e){s=!0,a=e}finally{try{n||null==l.return||l.return()}finally{if(s)throw a}}return i}}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _defineProperty(e,t,i){return t in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i,e}function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function setCookie(e,t,i){var n,s="";i&&((n=new Date).setTime(n.getTime()+24*i*60*60*1e3),s="; expires="+n.toUTCString()),document.cookie=e+"="+(t||"")+s+"; path=/"}function getCookie(e){for(var t=e+"=",i=document.cookie.split(";"),n=0;n<i.length;n++){for(var s=i[n];" "==s.charAt(0);)s=s.substring(1,s.length);if(0==s.indexOf(t))return s.substring(t.length,s.length)}return null}function clearCookies(){!function(){for(var e=document.cookie.split("; "),t=0;t<e.length;t++)for(var i=window.location.hostname.split(".");0<i.length;){var n=encodeURIComponent(e[t].split(";")[0].split("=")[0])+"=; expires=Thu, 01-Jan-1970 00:00:01 GMT; domain="+i.join(".")+" ;path=",s=location.pathname.split("/");for(document.cookie=n+"/";0<s.length;)document.cookie=n+s.join("/"),s.pop();i.shift()}}()}function ucfirst(e){return e?e.charAt(0).toUpperCase()+e.slice(1):e}function slugify(e){return e?e=(e=(e=(e=(e=(e=(e=(e=(e=(e=(e=e.toLowerCase()).split("ø").join("oe")).split("æ").join("ae")).split("å").join("aa")).split("_").join("-")).split("/").join("-")).replace(/\s+/g,"-")).replace(/[^\w\-]+/g,"")).replace(/\-\-+/g,"-")).replace(/^-+/,"")).replace(/-+$/,""):e}function unslugify(e){return e=ucfirst(e=(e=(e=(e=e.split("-").join(" ")).split("oe").join("ø")).split("ae").join("æ")).split("aa").join("å"))}function deepMerge(e){function t(e){return e&&"object"==_typeof(e)&&!Array.isArray(e)}for(var i=arguments.length,n=new Array(1<i?i-1:0),s=1;s<i;s++)n[s-1]=arguments[s];if(!n.length)return e;var a=n.shift();if(t(e)&&t(a))for(var o in a)t(a[o])?(e[o]||Object.assign(e,_defineProperty({},o,{})),deepMerge(e[o],a[o])):Object.assign(e,_defineProperty({},o,a[o]));return deepMerge.apply(void 0,[e].concat(n))}function deepClone(e){if(null==e||"object"!=_typeof(e))return e;var t=new e.constructor;for(var i in e)e.hasOwnProperty(i)&&(t[i]=deepClone(e[i]));return t}function deepClone2(e){if(!e)return e;var t,i=Array.isArray(e)?[]:{};for(var n in e)t=e[n],i[n]="object"==_typeof(t)?copy(t):t;return i}function deepClone3(e){return JSON.parse(JSON.stringify(e))}function deepClone4(t){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:new WeakMap;if(Object(t)!==t)return t;if(i.has(t))return i.get(t);var e=t instanceof Set?new Set(t):t instanceof Map?new Map(Array.from(t,function(e){var t=_slicedToArray(e,2);return[t[0],deepClone(t[1],i)]})):t instanceof Date?new Date(t):t instanceof RegExp?new RegExp(t.source,t.flags):t.constructor?new t.constructor:Object.create(null);return i.set(t,e),Object.assign.apply(Object,[e].concat(_toConsumableArray(Object.keys(t).map(function(e){return _defineProperty({},e,deepClone(t[e],i))}))))}function flattenObj(e){var t={};for(var i in e)if(e.hasOwnProperty(i))if("object"==_typeof(e[i])&&null!==e[i]){var n=flattenObj(e[i]);for(var s in n)n.hasOwnProperty(s)&&(t[i+"."+s]=n[s])}else t[i]=e[i];return t}function arraymove(e,t,i){var n=e[t];e.splice(t,1),e.splice(i,0,n)}function rand(e,t){return Math.floor(Math.random()*(t-e+1))+e}function randFromArray(e){return e[Math.floor(Math.random()*e.length)]}function shuffleArray(e){for(var t,i,n=e.length;0!==n;)i=Math.floor(Math.random()*n),t=e[--n],e[n]=e[i],e[i]=t;return e}function shuffleArrayUntilDifferentOutcome(e){for(var t,i=JSON.stringify(e),n=0;n<30;n++)if(t=shuffleArray(e),JSON.stringify(t)!==i)return t;return t}function array_strip_duplicates(e){var t=[];return e.forEach(function(e){t.includes(e)||t.push(e)}),t}function array_objs_strip_duplicates2(e,t){var i=[],n={};for(var s in e)n[e[s][t]]=e[s];for(s in n)i.push(n[s]);return i}function array_objs_strip_duplicates(e){return _toConsumableArray(new Set(e))}function generate_uid(){return"xxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)})}function removeTrailingSlash(e){return e.replace(/\/+$/,"")}function throttle(i,n,s){var a,o,l,r=null,c=0;s=s||{};function d(){c=!1===s.leading?0:Date.now(),r=null,l=i.apply(a,o),r||(a=o=null)}return function(){var e=Date.now();c||!1!==s.leading||(c=e);var t=n-(e-c);return a=this,o=arguments,t<=0||n<t?(r&&(clearTimeout(r),r=null),c=e,l=i.apply(a,o),r||(a=o=null)):r||!1===s.trailing||(r=setTimeout(d,t)),l}}function scrollTo(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:700,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"easeInOutCubic";$("html, body").stop().animate({scrollTop:e},t,i)}function formatBytes(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:2;if(0===e)return"0 Bytes";var i=t<0?0:t,n=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,n)).toFixed(i))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][n]}function isTrue(e){return"true"===e||"TRUE"===e||!0===e||1===e||"1"===e}function isFalse(e){return"false"===e||"FALSE"===e||!1===e||0===e||"0"===e}function isArray(e){return void 0!==e&&Array.isArray(e)}function isObject(e){return e&&"object"===_typeof(e)&&!Array.isArray(e)}function isStr(e){return e&&"string"==typeof e||e instanceof String}function clamp(e,t,i){return Math.min(Math.max(e,t),i)}function is_valid_json_str(e){try{JSON.parse(e)}catch(e){return!1}return!0}function url_filename(e){return e.substring(e.lastIndexOf("/")+1)}function getSelectValues(e){for(var t,i=[],n=e&&e.options,s=0,a=n.length;s<a;s++)(t=n[s]).selected&&i.push(t.value||t.text);return i}!function(e){function t(){}function a(e,t){for(var i=e.length;i--;)if(e[i].listener===t)return i;return-1}function i(e){return function(){return this[e].apply(this,arguments)}}var n=t.prototype,s=e.EventEmitter;n.getListeners=function(e){var t,i,n=this._getEvents();if(e instanceof RegExp)for(i in t={},n)n.hasOwnProperty(i)&&e.test(i)&&(t[i]=n[i]);else t=n[e]||(n[e]=[]);return t},n.flattenListeners=function(e){for(var t=[],i=0;i<e.length;i+=1)t.push(e[i].listener);return t},n.getListenersAsObject=function(e){var t,i=this.getListeners(e);return i instanceof Array&&((t={})[e]=i),t||i},n.addListener=function(e,t){if(!function e(t){return"function"==typeof t||t instanceof RegExp||!(!t||"object"!=_typeof(t))&&e(t.listener)}(t))throw new TypeError("listener must be a function");var i,n=this.getListenersAsObject(e),s="object"==_typeof(t);for(i in n)n.hasOwnProperty(i)&&-1===a(n[i],t)&&n[i].push(s?t:{listener:t,once:!1});return this},n.on=i("addListener"),n.addOnceListener=function(e,t){return this.addListener(e,{listener:t,once:!0})},n.once=i("addOnceListener"),n.defineEvent=function(e){return this.getListeners(e),this},n.defineEvents=function(e){for(var t=0;t<e.length;t+=1)this.defineEvent(e[t]);return this},n.removeListener=function(e,t){var i,n,s=this.getListenersAsObject(e);for(n in s)s.hasOwnProperty(n)&&-1!==(i=a(s[n],t))&&s[n].splice(i,1);return this},n.off=i("removeListener"),n.addListeners=function(e,t){return this.manipulateListeners(!1,e,t)},n.removeListeners=function(e,t){return this.manipulateListeners(!0,e,t)},n.manipulateListeners=function(e,t,i){var n,s,a=e?this.removeListener:this.addListener,o=e?this.removeListeners:this.addListeners;if("object"!=_typeof(t)||t instanceof RegExp)for(n=i.length;n--;)a.call(this,t,i[n]);else for(n in t)t.hasOwnProperty(n)&&(s=t[n])&&("function"==typeof s?a.call(this,n,s):o.call(this,n,s));return this},n.removeEvent=function(e){var t,i=_typeof(e),n=this._getEvents();if("string"===i)delete n[e];else if(e instanceof RegExp)for(t in n)n.hasOwnProperty(t)&&e.test(t)&&delete n[t];else delete this._events;return this},n.removeAllListeners=i("removeEvent"),n.emitEvent=function(e,t){var i,n,s,a,o=this.getListenersAsObject(e);for(a in o)if(o.hasOwnProperty(a))for(i=o[a].slice(0),s=0;s<i.length;s++)!0===(n=i[s]).once&&this.removeListener(e,n.listener),n.listener.apply(this,t||[])===this._getOnceReturnValue()&&this.removeListener(e,n.listener);return this},n.trigger=i("emitEvent"),n.emit=function(e){var t=Array.prototype.slice.call(arguments,1);return this.emitEvent(e,t)},n.setOnceReturnValue=function(e){return this._onceReturnValue=e,this},n._getOnceReturnValue=function(){return!this.hasOwnProperty("_onceReturnValue")||this._onceReturnValue},n._getEvents=function(){return this._events||(this._events={})},t.noConflict=function(){return e.EventEmitter=s,t},"function"==typeof define&&define.amd?define(function(){return t}):"object"==("undefined"==typeof module?"undefined":_typeof(module))&&module.exports?module.exports=t:e.EventEmitter=t}("undefined"!=typeof window?window:{});var language_options=[{code:"af",name:"Afrikaans"},{code:"ar",name:"Arabic"},{code:"bg",name:"Bulgarian"},{code:"bo",name:"Tibetan"},{code:"ca",name:"Catalan"},{code:"ch",name:"Chamorro"},{code:"cs",name:"Czech"},{code:"cy",name:"Welsh"},{code:"da",name:"Danish"},{code:"de",name:"German"},{code:"el",name:"Greek"},{code:"en",name:"English"},{code:"es",name:"Spanish"},{code:"eu",name:"Basque"},{code:"fa",name:"Persian"},{code:"fi",name:"Finnish"},{code:"fj",name:"Fijian"},{code:"fr",name:"French"},{code:"hi",name:"Hindi"},{code:"ht",name:"Haitian"},{code:"id",name:"Indonesian"},{code:"is",name:"Icelandic"},{code:"it",name:"Italian"},{code:"ja",name:"Japanese"},{code:"ko",name:"Korean"},{code:"lo",name:"Lao"},{code:"mi",name:"Maori"},{code:"ml",name:"Malayalam"},{code:"mn",name:"Mongolian"},{code:"ms",name:"Malay"},{code:"ne",name:"Nepali"},{code:"nl",name:"Dutch"},{code:"no",name:"Norwegian"},{code:"nv",name:"Navajo"},{code:"pl",name:"Polish"},{code:"pt",name:"Portuguese"},{code:"ro",name:"Romanian"},{code:"sk",name:"Slovak"},{code:"sl",name:"Slovenian"},{code:"sm",name:"Samoan"},{code:"so",name:"Somali"},{code:"sq",name:"Albanian"},{code:"su",name:"Sundanese"},{code:"sv",name:"Swedish"},{code:"th",name:"Thai"},{code:"tr",name:"Turkish"},{code:"ty",name:"Tahitian"},{code:"uk",name:"Ukrainian"},{code:"vi",name:"Vietnamese"},{code:"zh",name:"Chinese"}];function load_file(e){Array.isArray(e)||(e=[e]);var t=e.map(function(n){return n.includes(".js")?new Promise(function(e,t){var i=document.createElement("script");i.src=n,i.async=!0,i.onload=function(){e()},i.onerror=function(){t()},document.getElementsByTagName("head")[0].appendChild(i)}):n.includes(".css")?new Promise(function(e,t){var i=document.createElement("link");i.href=n,i.rel="stylesheet",i.onload=function(){e()},i.onerror=function(){t()},document.getElementsByTagName("head")[0].appendChild(i)}):void 0});return Promise.all(t)}var mixins={};mixins.basic={computed:{base_url:function(){return this.$store.state.base_url},admin_language:function(){return this.$store.state.admin_language},fetched_content:function(){return this.$store.state.fetched_content},cms_config:function(){return this.$store.getters.cms_config},item_schemas:function(){return this.$store.getters.item_schemas},item_schemas_only_singular:function(){return this.$store.getters.item_schemas_only_singular},item_schemas_only_non_singular:function(){return this.$store.getters.item_schemas_only_non_singular},compactSidebar:function(){return this.$store.state.compactSidebar},darkMode:function(){return this.$store.state.darkMode},url_route:function(){return this.$store.getters.url_route},url_params:function(){return this.$store.getters.url_params},languages:function(){return this.$store.getters.languages},primary_language:function(){return this.$store.getters.primary_language},strings:function(){return this.$store.getters.strings},is_multilingual:function(){return this.$store.getters.is_multilingual},user:function(){return this.$store.state.user},ui_active_lang:function(){return this.$store.state.ui_active_lang},logged_in:function(){return!(!this.$store.state.user.token||!this.$store.state.user.token.length)&&this.$store.state.user},logged_in_user:function(){return this.$store.state.logged_in_user},permissions:function(){return this.$store.state.permissions},login_disabled:function(){return this.$store.state.login_disabled},preview_enabled:function(){return this.$store.state.preview_enabled},previewFrame:function(){return this.$store.state.previewFrame},previewFrame_url:function(){return this.$store.state.previewFrame.url},filedropzoneEnabled:function(){return this.$store.state.filedropzoneEnabled},uploadingFileActive:function(){return this.$store.state.uploadingFileActive},uploadingFileList:function(){return this.$store.state.uploadingFileList},active_item_schemas:function(){var e=this.item_schemas;return e?e=e.filter(function(e){return void 0===e.active||isTrue(e.active)}):[]}},methods:{str:function(e,t){return t=(t=t||this.$store.state.admin_language)||"en",this.$store.getters.get_langstring(e,t)},user_can:function(e){return this.$store.getters.user_can(e)},schema_is_singular:function(e){return this.$store.getters.schema_is_singular(e)},get_string:function(e,t,i){return this.$store.getters.get_string(e,t,i)},gotoView:function(e){window.location.hash="#"+e},gotoItemType:function(e){var t,i,n,s,a=this.schema_is_singular(e);a&&(t=this.ui_active_lang,i=this.$store.getters.get_items(e.name),n=this.$store.getters.get_items_where(e.name,{language:t}),s=void 0,i&&i.length&&(s=i[0]),n&&n.length&&(s=n[0]),s&&this.gotoView("item-"+e.name+"-uid-"+s.uid),s||this.gotoView("items-"+e.name)),a||this.gotoView("items-"+e.name)},isView:function(e){return this.$store.getters.view===e},get_language:function(e){return this.$store.getters.get_language(e)},get_language_name:function(e){var t=this.get_language(e);return t?t.name:e},get_item_url:function(e,t){return this.$store.getters.get_item_url(e,t)},items_filter_trashed:function(e){return this.$store.getters.items_filter_trashed(e)},items_filter_untrashed:function(e){return this.$store.getters.items_filter_untrashed(e)},block_title:function(e){var t=this.$store.getters.get_block_schema(e);return t&&void 0!==t.title?ucfirst(t.title):ucfirst(e)},on_logged_in:function(){this.fetch_cms_config()},toggleDarkMode:function(){this.$store.commit("toggleDarkMode"),localStorage.setItem("darkmode",this.$store.state.darkMode?"enabled":"disabled")},setDarkMode:function(e){this.$store.commit("setDarkMode",e),localStorage.setItem("darkmode",this.$store.state.darkMode?"enabled":"disabled")},toggleCompactSidebar:function(){this.$store.commit("toggleCompactSidebar"),localStorage.setItem("compactsidebar",this.$store.state.compactSidebar?"enabled":"disabled")},setPreviewFrame:function(e){this.$store.commit("setPreviewFrame",e)},togglePreviewFrame:function(){this.$store.commit("togglePreviewFrame")},togglePreviewFrameMobileMode:function(){this.$store.commit("togglePreviewFrameMobileMode")},refreshPreviewFrame:function(){var e=document.querySelector(".previewframe iframe");e&&e.contentWindow.location.reload()},setPreviewFrameHome:function(){var e=document.querySelector(".previewframe iframe");e&&(e.contentWindow.location.href=this.previewFrame_url)},setFiledropzoneEnabled:function(e){this.$store.commit("set_filedropzoneEnabled",e)},asset_is_video:function(e){return!!e&&["mp4"].includes(e.format)},asset_is_img:function(e){return!(!e||!e.format)&&["webp","jpg","jpeg","png","gif","apng"].includes(e.format.toLowerCase())},asset_preview_video_url:function(e){var t=e.files,i="";e.updated_at&&(i="?"+e.updated_at.replace(/\D/g,""));var n,s=_createForOfIteratorHelper(t);try{for(s.s();!(n=s.n()).done;){var a=n.value;if(a.includes(".mp4"))return a+i}}catch(e){s.e(e)}finally{s.f()}},asset_preview_img_url:function(e){if(e&&e.files){var t=e.files,i=["webp","png","jpg","jpeg","gif","apng"],n="";e.updated_at&&(n="?"+e.updated_at.replace(/\D/g,""));for(var s=0,a=[250,300,350,400,450,500,550,600,700];s<a.length;s++){var o,l=a[s],r=_createForOfIteratorHelper(i);try{for(r.s();!(o=r.n()).done;){var c,d=o.value,u=_createForOfIteratorHelper(t);try{for(u.s();!(c=u.n()).done;){var _=c.value;if(_.includes("."+d)&&_.includes("/w"+l+"/"))return _+n}}catch(e){u.e(e)}finally{u.f()}}}catch(e){r.e(e)}finally{r.f()}}for(var f=0,p=i;f<p.length;f++){var m,h=p[f],v=_createForOfIteratorHelper(t);try{for(v.s();!(m=v.n()).done;){var g=m.value;if(g.includes("."+h))return g+n}}catch(e){v.e(e)}finally{v.f()}}}},asset_preview_or:function(e,t){var i=this.asset_preview(e);return i||t},asset_preview:function(e){var t=this;isStr(e)&&(e={uid:e}),isObject(e)||(e={uid:e});var i=e.uid;if(i)return klay.vue.$nextTick(function(){t.load_fetchable_asset_previews()}),'<span class="fetchable-asset-preview" data-uid="'+i+'"></span>'},load_fetchable_asset_previews:function(){var t,o=this,e=$(".fetchable-asset-preview");e&&(t=[],e.each(function(){var e=$(this).attr("data-uid");e&&t.push(e)}),t.length&&this.api_post("fetch_preview_assets",{uids:t}).done(function(e){var t,i=_createForOfIteratorHelper(e.assets);try{for(i.s();!(t=i.n()).done;)(function(){var i=t.value,e=$('.fetchable-asset-preview[data-uid="'+i.uid+'"]');if(!e.length)return;var n=o.asset_is_img(i),s=o.asset_is_video(i),a=!n&&!s;e.each(function(e,t){n&&$(t).replaceWith('<div class="img"><img src="'+o.asset_preview_img_url(i)+'" /></div>'),s&&$(t).replaceWith('<div class="video"><video src="'+o.asset_preview_video_url(i)+'" controls muted preload="metadata"></video></div>'),a&&$(t).replaceWith("")})})()}catch(e){i.e(e)}finally{i.f()}}))},item_type_title:function(e,t){var i=0<arguments.length&&void 0!==e?e:"?",n=1<arguments.length&&void 0!==t?t:"single";return"single"==n?i.title_single||i.title||i.name:"plural"==n?i.title_plural||i.title||i.name:"single,plural"==n?i.title_single||i.title_plural||i.title||i.name:"plural,single"==n?i.title_plural||i.title_single||i.title||i.name:void 0},item_icon_preview:function(e){var t="?";return e.title&&(t=e.title.slice(0,1)),t=t.toUpperCase()},item_preview_asset:function(){},toast:function(e){klay.toast(e)},msg:function(e){klay.msg(e)},confirm:function(e){klay.confirm(e)},spinner:function(e){klay.spinner(e)},el_is_checkbox:function(e){return e.type&&"checkbox"===e.type},showCloneUi:function(t,e,i){var n=this,s="da"==this.admin_language,a=this.$store.getters.get_item_schema(t),o="";e.title&&(o=e.title+(s?" (kopi)":" (copy)"));var l,r=this.str("Copy [item]").replace("[item]",a.title_single?a.title_single:a.name);(o=prompt(r,o))&&(this.spinner({active:!0,blocking:!0}),(l=this).api_post("copy_item",{itemtype:t,uid:e.uid,new_title:o}).done(function(e){n.toast({text:l.str("copied"),icon:"check_circle"}),n.fetch_content({type:t}),n.spinner({active:!1,blocking:!1})}).fail(function(e){n.toast({text:l.str("error_try_again"),icon:"warning",type:"error"}),n.spinner({active:!1,blocking:!1})}))},get_item:function(e,t){return this.$store.getters.get_item(e,t)},item_get_type:function(e){return this.$store.getters.item_get_type(e)},get_asset:function(e){return this.$store.getters.get_asset(e)},set_modal_cloner:function(e){this.$store.commit("set_modal_cloner",e)},set_modal_asset_active:function(e){this.$store.commit("set_modal_asset_active",e)},set_modal_richtext_active:function(e){this.$store.commit("set_modal_richtext_active",e)},set_modal_fields_active:function(e){this.$store.commit("set_modal_fields_active",e)},set_modal_backup_active:function(e){this.$store.commit("set_modal_backup_active",e)},api_get:function(e,t){return t.api_endpoint=e,$.ajax({type:"GET",url:this.base_url,data:t,dataType:"json"})},api_put:function(e,t){return t.api_endpoint=e,$.ajax({type:"PUT",url:this.base_url,data:t,dataType:"json"})},api_post:function(e,t){return t.api_endpoint=e,$.ajax({type:"POST",url:this.base_url,data:JSON.stringify(t),dataType:"json",contentType:"application/json; charset=utf-8"})},api_patch:function(e,t){return t.api_endpoint=e,$.ajax({type:"PATCH",url:this.base_url,data:t,dataType:"json"})},api_delete:function(e,t){return t.api_endpoint=e,$.ajax({type:"DELETE",url:this.base_url,data:t,dataType:"json"})},api_post_multipart:function(e,t,i){t.api_endpoint=e;var n=new FormData;if(n.append("multipart_data",JSON.stringify(t)),i)for(var s in i)n.append(s,i[s]);return $.ajax({type:"POST",url:this.base_url,data:n,processData:!1,contentType:!1})},fetch_content:function(e){var t=_objectSpread(_objectSpread({},t={api_endpoint:"fetch_content",type:e.type}),e);return $.get(this.base_url,t).done(function(e){}).fail(function(e){})},fetch_cms_config:function(){var t=this;return this.fetch_content({type:"cms_config"}).then(function(e){t.$store.commit("set_fetched_content",{type:"cms_config",data:e.data})})},clear_fetched_content:function(e){this.$store.commit("clear_fetched_content",e)},logout:function(){confirm("Log out?")&&(setCookie("t836724",void 0,9999),this.$store.commit("set_user_token",void 0),setTimeout(function(){window.location.reload()},0))},fetch_relations:function(e){var a=this;return!e||"object"!==_typeof(e)?e:Array.isArray(e)?e.map(function(e){return a.fetch_relations(e)}):Object.fromEntries(Object.entries(e).flatMap(function(e){var t=_slicedToArray(e,2),i=t[0],n=t[1];if("uid"!==i)return[[i,a.fetch_relations(n)]];var s=a.$store.getters.get_item("any",n);return Object.entries(s||[[i,n]])}))},fetch_relations2:function(e,t){if(null==t&&(t=0),99<++t)return e;if(!e)return e;var i;!isObject(e)||void 0===e.uid||(i=this.$store.getters.get_item("any",e.uid))&&(e=deepMerge(deepClone(e),deepClone(i)));var n,s=deepClone(e);if(isObject(e)||isArray(e))for(var a in e){(isObject(e[a])||isArray(e[a]))&&(console.log(t),n=this.fetch_relations(deepClone(e[a]),t),s[a]=n)}return deepMerge(deepClone(e),deepClone(s))},fetch_relations3:function(s){var e,t=this;return isObject(s)?void 0!==s.uid?(e=this.$store.getters.get_item("any",s.uid),Object.entries(e).forEach(function(e){var t=_slicedToArray(e,2),i=t[0],n=t[1];s[i]=n})):Object.values(s).forEach(function(e){t.fetch_relations(e)}):isArray(s)&&s.forEach(function(e){t.fetch_relations(e)}),s},uploadFile:function(t){var n=this,e=(t=t||{}).file,i=t.asset,s=e.size/1048576,a=t.file.name.split(".").pop().toLowerCase(),o="jpg"==a||"jpeg"==a||"webp"==a||"png"==a,l="mp4"==a,r=this.$store.state.phpdata.max_upload_mb,c=this.$store.state.phpdata.max_upload_mb_img,d=this.$store.state.phpdata.max_upload_mb_video;if(o&&c&&(r=c),l&&d&&(r=d),r&&r<s)return klay.toast({text:this.str("file_too_large").replace("$A",s.toFixed(1)).replace("$B",r.toFixed(1)),icon:"warning",type:"error"});this.spinner(t.spinner||{active:!0,blocking:!0}),this.$store.commit("set_uploadingFileActive",!0),this.$store.commit("set_uploadingFileList",[].concat([e.name],this.uploadingFileList));var u={type:"asset",item:i};return this.api_post_multipart("save_item",u,{uploaded_file:e}).done(function(e){return t.onSuccess?t.onSuccess():(window.onFilesUploaded||n.toast({text:n.str("file_uploaded"),icon:"check_circle"}),window.onFilesUploaded||n.fetch_content({type:"asset"}),n.spinner({active:!1,blocking:!1}),void(window.filesUploadedDone=(window.filesUploadedDone||0)+1))}).fail(function(e,t,i){window.onFilesUploaded||n.toast({text:n.str("could_not_upload_file"),icon:"warning",type:"error"}),n.spinner({active:!1,blocking:!1}),window.filesUploadedError=(window.filesUploadedError||0)+1,console.log({m:"uploadFile:error",r:e,b:t,c:i})}).always(function(e){n.$store.commit("set_uploadingFileActive",!1),n.$store.commit("set_uploadingFileList",n.uploadingFileList.slice(1)),!n.uploadingFileList.length&&window.onFilesUploaded&&(window.onFilesUploaded(),window.onFilesUploaded=void 0),n.uploadingFileList.length||mitter.emit("assets-list-refresh")})},strings_overlap_charcount:function(e,t){var i=0;for(var n in e)t.includes(e[n])&&i++;return i}},created:function(){}},Vue.component("left-bar",{template:'<div id="lbar">\n\n        <div class="top">\n\n            <a class="logolink" :href="base_url">\n                <logo tag="span"></logo>\n            </a>\n\n        </div>\n\n        <div class="mid">\n\n            <div class="scroller">\n                \n                <div class="lbarlink is-first" @click="gotoView(\'home\')" :class="{active:isView(\'home\')}" @mouseenter="link_mouseover($event)" @mouseleave="link_mouseout($event)">\n                    <ic>home</ic>\n                    <span class="label">{{str(\'home\')}}</span>                \n                </div>\n\n                <div class="lbarlink" v-if="item_schemas" v-for="(t,i) in active_item_schemas" :class="{active:is_active_type(t)}" @click="gotoItemType(t)" @mouseenter="link_mouseover($event)" @mouseleave="link_mouseout($event)">\n                    <ic>{{ (t.icon) ? t.icon : \'topic\' }}</ic>\n                    <span class="label">{{ucfirst(item_type_title(t,\'plural,single\'))}}</span>\n                </div>\n\n                <div class="lbarlink" @click="gotoView(\'assets\')" :class="{active:isView(\'assets\')}" @mouseenter="link_mouseover($event)" @mouseleave="link_mouseout($event)">\n                    <ic>perm_media</ic>\n                    <span class="label">{{str(\'assets\')}}</span>\n                </div>\n                \n                <template v-if="customLinks">\n                    <a class="lbarlink" v-for="(x) in customLinks" :href="x.url" @click="customLinkClick($event,x)" :target="x.target||\'self\'">\n                        <ic v-if="x.icon">{{x.icon}}</ic>\n                        <span class="label">{{x.label}}</span>\n                    </a>\n                </template>\n                \n                <div class="lbarlink" @click="triggerPublishWebhook()" v-if="cms_config && cms_config.webhook_url_manual_publish" @mouseenter="link_mouseover($event)" @mouseleave="link_mouseout($event)">\n                    <ic>cloud_upload</ic>\n                    <span class="label">{{str(\'publish\')}}</span>\n                </div>\n\n            </div>\n            \n        </div>       \n\n        <div class="bottom">\n            <div class="fbtn" @click="gotoView(\'settings\')" :class="{active:isView(\'settings\')}" v-tooltip="str(\'settings\')">\n                <ic>settings</ic>\n            </div>\n            <div class="fbtn" @click="toggleCompactSidebar()" v-if="!(previewFrame_url && previewFrame.active)">\n                <ic>{{compactSidebar?\'chevron_right\':\'chevron_left\'}}</ic>\n            </div>\n        </div>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{}},computed:{customLinks:function(){var e;return(null!==(e=this.$store.state.customLinks)&&void 0!==e?e:[]).filter(function(e){return e.position&&"menubar"==e.position})}},watch:{},methods:{customLinkClick:function(e,t){if(t.onClick)return e.preventDefault(),t.onClick(),!1},is_active_type:function(e){return!!(this.isView("items-list")&&this.url_params&&this.url_params.type&&this.url_params.type==e.name)||!!(this.isView("item-single")&&this.url_params&&this.url_params.type&&this.url_params.type==e.name)},triggerPublishWebhook:function(){var t=this;return this.spinner({active:!0,blocking:!0}),this.api_post("trigger_webhook_manual_publish",{}).done(function(e){t.toast({text:t.str("webhook_publish_triggered"),icon:"check_circle"}),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("unknown_error_try_again"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})},link_mouseover:function(e){var t,i,n,s;!this.compactSidebar||(i=(t=$(e.target)).find(".label").text())&&(n=t.offset(),(s=$('<div class="lbar-floatlabel">'+i+"</div>")).css({left:n.left,top:n.top}),$("body").append(s))},link_mouseout:function(){var e=$(".lbar-floatlabel");e&&e.remove()}},mounted:function(){},created:function(){}}),Vue.component("card",{template:'<div class="card" :key="key" :class="cls">\n        <div class="card-header" v-if="(title || icon)">\n            <ic v-if="icon">{{icon}}</ic>{{title? \' \'+title : \'\'}}\n            <slot name="header"></slot>\n        </div>\n        <div class="card-body">\n            <slot></slot>\n        </div>\n    </div>',props:{title:{type:String,default:void 0},icon:{type:String,default:void 0},cls:{type:String,default:void 0}},computed:{key:function(){return parseInt(9999*Math.random())}}}),Vue.component("loading",{template:'<div class="loading">\n      \n      <div v-if="type==\'spinner\'" class="loading-spinner">\n         <div></div>\n      </div>\n\n      <div v-if="type==\'text\'" class="loading-text">\n         <div class="line line1"></div>\n         <div class="line line2"></div>\n         <div class="line line3"></div>\n         <div class="line line4"></div>\n      </div>\n\n    </div>',props:{type:{type:String,default:"spinner"}},mixins:[mixins.basic],data:function(){return{}},computed:{},methods:{},created:function(){}}),Vue.component("ic",{template:'<span class="material-symbols-outlined icon"><slot></slot></span>',props:{}}),Vue.component("item-fields",{template:'<div class="itemfields-container" v-if="localdata">\n        \n        <pre v-if="0"><b>localdata:</b><br>{{localdata}}</pre>\n        <pre v-if="0"><b>fields:</b><br>{{fields}}</pre>\n\n        <div class="tabs" v-if="has_grouping">\n            <div class="tab" v-for="(group) in groups" @click="activeGroup=group" :class="{active:(activeGroup==group)}">\n               <ic v-if="group_icon(group)">{{group_icon(group)}}</ic><span class="label" v-if="group_label(group)">{{group_label(group)}}</span>\n            </div>\n        </div>\n\n        <div class="itemfields">\n            <div class="itemfield"\n                v-for="(field,field_i) in fields"\n                :key="\'itemfield\'+field_i"\n                v-if="itemfield_show(field)"\n                :class="itemfield_cls(field)"\n                :style="itemfield_css(field)"\n            >\n\n                <div class="field" \n                v-if="[\'text\',\'number\',\'range\',\'select\',\'checkbox\',\'textarea\',\'asset\',\'richtext\',\'relation\',\'repeater\',\'blocks\',\'date\',\'color\',\'geolocation\',\'preview\',\'note\'].includes(field.type)"\n                :class="field_cls(field)"\n                >\n                    \n                    <div class="label" v-if="!field.help">{{field.label}}</div>\n                    <div class="label has-helper" v-if="field.help">{{field.label}}<span class="helpicon" @click="help_click(field)">?</span></div>\n                    \n                    <div class="note" v-if="field.type===\'note\'" v-html="field.note"></div>\n\n                    <input type="text" v-if="field.type===\'text\'" v-model="localdata[field.name]" @change="onChanged2(field,$event)" />\n                    \n                    <input type="number" v-if="field.type===\'number\'" v-model="localdata[field.name]" :min="field.min" :max="field.max" :step="field.step" @change="onChanged2(field,$event)"/>\n                    \n                    <input type="range" v-if="field.type===\'range\'" v-model="localdata[field.name]" :min="field.min" :max="field.max" :step="field.step" @change="onChanged2(field,$event)"/>\n                    <input type="number" v-if="field.type===\'range\'" v-model="localdata[field.name]" :min="field.min" :max="field.max" :step="field.step" @change="onChanged2(field,$event)"/>\n                    \n                    <input type="checkbox" v-if="field.type===\'checkbox\'" :checked="isChecked(field)" @change="onChanged(field,$event)"/>\n                    \n                    <textarea v-if="field.type===\'textarea\'" :value="getValue(field)" @change="onChanged(field,$event)"/>\n\n                    <input type="date" v-if="field.type===\'date\'" v-model="localdata[field.name]" @change="onChanged2(field,$event)"/>\n                    <input type="text" v-if="field.type===\'date\'" v-model="localdata[field.name]" @change="onChanged2(field,$event)"/>\n                    \n                    <div class="colorfield" v-if="field.type===\'color\'">\n                        <input type="color" v-model="localdata[field.name]" @change="onChanged2(field,$event)"/>\n                        <input type="text" v-model="localdata[field.name]" @change="onChanged2(field,$event)"/>\n                    </div>\n                    \n                    <select v-if="field.type===\'select\'" v-model="localdata[field.name]" @change="onChanged2(field,$event)" :multiple="field.multiple">\n                        <option v-for="(o,oi) in select_options(field)" :value="o.value">{{o.label}}</option>\n                    </select>\n                    \n\n                    <item-field-relation v-if="field.type===\'relation\'" :field="field" :data="localdata[field.name]" @updated="relationFieldUpdated(field,$event)"></item-field-relation>\n                    \n                    <div v-if="0">\n                            <div v-if="field.type===\'relation\' && !load_relation_options">\n                                <template v-if="!relation_item(field)">\n                                    <div class="btn" @click="load_relation_options=true"><ic>edit</ic> {{ str(\'select\') }} </div>\n                                </template>\n                                <template v-if="relation_item(field)">\n                                    <div class="btn" @click="load_relation_options=true"><ic>edit</ic> {{relation_item_title(field)}} </div>\n                                </template>\n                            </div>\n                            <select v-if="field.type===\'relation\' && load_relation_options" v-model="localdata[field.name]" @change="onRelationFieldChange(field,$event)" :multiple="field.multiple">\n                                <option value="">Undefined</option>\n                                <optgroup v-for="(og,ogi) in relation_options(field)" :label="og.label">\n                                    <option v-for="(o,oi) in og.options" :value="o.value">{{o.label}}</option>\n                                </optgroup>\n                            </select>\n                    </div>\n\n\n                    <template v-if="field.type===\'asset\'">\n                        <div class="asset-field-container -empty" v-if="!localdata[field.name]">\n                            <div class="asset-select-btn" @click="open_assets_modal(field)"><ic>folder</ic> Select</div>\n                        </div>\n                        <div class="asset-field-container -set" v-if="localdata[field.name]">\n                            <asset-preview :uid="localdata[field.name].uid"></asset-preview>\n                            <div class="asset-clear-btn" @click="setValue(field,undefined)"><ic>clear</ic></div>\n                            <div class="asset-open-btn" @click="open_asset(localdata[field.name])"><ic>edit</ic></div>\n                            <div class="asset-swap-btn" v-if="0" @click="asset_swap(field.name, localdata, localdata[field.name])"><ic>swap_horiz</ic></div>\n                        </div>\n                    </template>\n                    \n                    \n                    <div v-if="field.type===\'richtext\'">\n                        <div class="richtext-preview" v-html="getValue(field)" @click="open_richtext_modal(field)"></div>\n                        <div class="btn" v-if="0" @click="open_richtext_modal(field)">Edit</div>\n                    </div>\n\n                    <div v-if="field.type==\'geolocation\'">\n                        <geomap @change="mapOnChange($event,field)" :lat="get_mapvalue(\'lat\',field)" :lng="get_mapvalue(\'lng\',field)" :zoom="get_mapvalue(\'zoom\',field)" ></geomap>                        \n                    </div>\n                    \n                    <div class="preview-field" v-if="field.type==\'preview\'" v-html="preview_field_html({ field:field, data:localdata })"></div>\n\n                \n\n                    <div class="repeater" v-if="field.type==\'repeater\'">\n                        <pre v-if="0">field:{{getValue(field)}}</pre>                \n                        <div class="no-rows" v-if="0 && !repeaterHasRows(field)">No rows</div>\n                        <div class="rows">\n                            <div class="row" v-if="repeaterHasRows(field)" v-for="(row,row_i) in localdata[field.name]" :key="\'row\'+row_i" :class="{closed:(openRepeaterRow !== field.name+row_i)}">\n\n                                <div class="row-clicker" @click="toggleOpenRepeaterRow(field,row_i)"></div>\n\n                                <div class="row-num">\n                                    {{row_i+1}}\n                                </div>\n                                \n                                <div class="row-title" v-if="repeater_row_title(field,row_i)">{{repeater_row_title(field,row_i)}}</div>                                \n                                <div class="row-titlepreview" v-if="repeater_row_preview_html(field,row_i)" v-html="repeater_row_preview_html(field,row_i)"></div>\n                                <div class="row-autotitle" v-if="!repeater_row_title(field,row_i) && !repeater_row_preview_html(field,row_i)"></div>\n\n                                <div class="slidable" style="display:none;">\n                                    <item-fields v-if="showRepeaterSlidableContent"\n                                        :data2="localdata[field.name]" \n                                        :old_data="getValue(field)" \n                                        :data="localdata[field.name][row_i]" \n                                        :fields="getField(field.name).fields"\n                                        :key="\'rowItemFields\'+row_i"\n                                        @updated="onChildUpdated($event,field,row_i)"\n                                    ></item-fields>\n                                </div>\n\n                                <div class="rbtns">\n                                    <div class="rbtn --dupe" @click="repeaterDuplicateRow(field,row_i)" v-tooltip="str(\'duplicate\')"><ic>control_point_duplicate</ic></div>\n                                    <div class="rbtn --move-up" @click="repeaterMoveRowUp(field,row_i)" v-tooltip="str(\'move\')" :class="{cannot:!rowCanMoveUp(field,row_i)}"><ic>arrow_upward</ic></div>\n                                    <div class="rbtn --move-down" @click="repeaterMoveRowDown(field,row_i)" v-tooltip="str(\'move\')" :class="{cannot:!rowCanMoveDown(field,row_i)}"><ic>arrow_downward</ic></div>\n                                    <div class="rbtn --delete" @click="repeaterDeleteRow(field,row_i)" v-tooltip="str(\'remove\')" @mouseout="deletableRow=undefined" :class="{sure:(deletableRow===field.name+row_i)}"><ic>clear</ic></div>\n                                </div>\n                                \n\n                            </div>\n                            <div class="add-row-btn" v-if="repeaterCanAddRow(field)" @click="repeaterAddRow(field)"><ic>add</ic></div>\n                        </div>\n                    </div>\n                \n\n\n                    <div class="blocks" v-if="field.type==\'blocks\'" :class="{\'has-rows\':repeaterHasRows(field), empty:!repeaterHasRows(field) }">\n                        \n                        <div class="repeater">\n                            <div class="no-rows" v-if="0 && !repeaterHasRows(field)">No blocks</div>\n                            <div class="add-row-btn before" @click="showAddBlockButtons(field,0)"><ic>add</ic></div>\n                            <div class="rows" :class="{empty:!repeaterHasRows(field)}">\n                                <div class="row" v-if="repeaterHasRows(field)" v-for="(row,row_i) in getValue(field)" :class="{closed:(openRepeaterRow !== field.name+row_i)}">\n                                    \n                                    <div class="row-clicker" @click="open_block_row(field,row_i)"></div>\n                                    <div class="row-num">{{row_i+1}}</div>\n                                    <div class="row-blockname">{{block_title(localdata[field.name][row_i]._type)}}</div>\n\n                                    <div class="rbtns">\n                                        <div class="rbtn --custom"\n                                            v-for="(btn,btn_i) in block_custom_btns({type:localdata[field.name][row_i]._type})"\n                                            @click="btn.onClick({ data:localdata[field.name][row_i], localdata, field, row_i, update:block_update })"\n                                            v-tooltip="btn.tooltip"\n                                        >\n                                            <ic>{{btn.icon}}</ic>\n                                        </div>\n                                        <div class="rbtn --previewframe" v-if="previewFrame.active" v-tooltip="str(\'preview\')" @click="block_previewFrame_scrollTo(row_i)"><ic>visibility</ic></div>\n                                        <div class="rbtn --dupe" @click="repeaterDuplicateRow(field,row_i)" v-tooltip="str(\'duplicate\')"><ic>control_point_duplicate</ic></div>\n                                        <div class="rbtn --move-up" @click="repeaterMoveRowUp(field,row_i)" v-tooltip="str(\'move\')" :class="{cannot:!rowCanMoveUp(field,row_i)}"><ic>arrow_upward</ic></div>\n                                        <div class="rbtn --move-down" @click="repeaterMoveRowDown(field,row_i)" v-tooltip="str(\'move\')" :class="{cannot:!rowCanMoveDown(field,row_i)}"><ic>arrow_downward</ic></div>\n                                        <div class="rbtn --delete" @click="repeaterDeleteRow(field,row_i)" v-tooltip="str(\'remove\')" @mouseout="deletableRow=undefined" :class="{sure:(deletableRow===field.name+row_i)}"><ic>clear</ic></div>\n                                    </div>\n                                    \n                                    <div class="blockpreview-container" \n                                        v-html="block_preview_html({type:localdata[field.name][row_i]._type, data:localdata[field.name][row_i], index:row_i, alldata:localdata, field:field, })"\n                                        :class="{\'has-preview\': block_preview_html({type:localdata[field.name][row_i]._type, data:localdata[field.name][row_i], index:row_i, alldata:localdata, field:field, }) }"\n                                        @click="open_block_row(field,row_i)"\n                                    ></div>\n\n                                    <div class="add-row-btn mid" @click="showAddBlockButtons(field,row_i+1)"><ic>add</ic></div>\n\n                                </div>     \n                            </div>\n                        </div>\n                        \n                        <pre v-if="0">{{get_block_options(field)}}</pre>\n                    </div>\n\n                </div>\n\n\n            </div>\n        </div>\n\n    </div>',props:{data:{type:Object,default:void 0},fields:{type:Object,default:void 0},rootpath:{type:String,default:void 0}},mixins:[mixins.basic],data:function(){return{localdata:void 0,openRepeaterRow:void 0,deletableRow:void 0,addingBlock:!1,activeGroup:"icon(settings)",load_relation_options:!1,showRepeaterSlidableContent:!0}},computed:{groups:function(){var e=[],t=[];if(!this.fields)return e;var i,n=_createForOfIteratorHelper(this.fields);try{for(n.s();!(i=n.n()).done;){var s=i.value;s.group&&e.push(s.group)}}catch(e){n.e(e)}finally{n.f()}var a,o=_createForOfIteratorHelper(this.fields);try{for(o.s();!(a=o.n()).done;){var l=a.value;l.group||t.push(l)}}catch(e){o.e(e)}finally{o.f()}return e=_toConsumableArray(new Set(e)),e.length&&t.length&&e.push("icon(settings)"),e=array_strip_duplicates(e),e},has_grouping:function(){return this.groups&&this.groups.length&&1<this.groups.length}},methods:{itemfield_show:function(e){return void 0===e.active||!isFalse(e.active)},itemfield_cls:function itemfield_cls(field){var cls={},exp,exp,valid,visible;return cls["type-"+field.type]=!0,void 0===field.show_if&&void 0===field.hide_if||(exp=field.show_if?field.show_if:field.hide_if,exp=exp.split("$").join("this.localdata."),exp=exp.split("`").join('"'),valid=eval(exp),void 0!==field.hide_if&&(valid=!valid),cls.hide=!valid),this.has_grouping&&(visible=field.group&&field.group==this.activeGroup,field.group||"icon(settings)"!=this.activeGroup||(visible=!0),field.group||this.activeGroup||(visible=!0),cls.hide=!visible),cls},itemfield_css:function(e){var t={};return e.cms_view&&e.cms_view.col&&(t["grid-column"]=e.cms_view.col),t},field_cls:function(e){var t={};return t["type-"+e.type]=!0,t},fieldPath:function(e){var t="";return this.rootpath&&(t+=this.rootpath),t+=e.name},getField:function(e){var t,i=_createForOfIteratorHelper(this.fields);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.name===e)return n}}catch(e){i.e(e)}finally{i.f()}},getValue:function(e){var t=(t=deepClone(this.localdata))||{},i=this.fieldPath(e);return objectPath.get(t,i)},setValue:function(e,t,i){var n=(n=deepClone(this.localdata))||{},s=this.fieldPath(e);void 0!==i&&(s+="."+i),objectPath.set(n,s,t),this.$set(this,"localdata",n),this.$emit("updated",{localdata:n,path:s,value:t,field:e,index:i})},isChecked:function(e){var t=this.getValue(e);return!!isTrue(t)||void 0!==e.true_value&&t===e.true_value},onChanged:function(e,t){var i,n=t.target;"text"===e.type&&(i=$(n).val()),"number"===e.type&&(i=Number($(n).val()||"")),"checkbox"===e.type&&((i=!0===(i=$(n).get(0).checked))?void 0!==e.true_value&&(i=e.true_value):void 0!==e.false_value&&(i=e.false_value)),"select"===e.type&&(i=$(n).val()),"textarea"===e.type&&(i=$(n).val()),"relation"===e.type&&(i=$(n).val()),this.setValue(e,i)},onChanged2:function(e){this.setValue(e,this.localdata[e.name]),this.load_relation_options&&(this.load_relation_options=!1)},relationFieldUpdated:function(e,t){var i=this;this.setValue(e,t),Vue.nextTick(function(){i.repeaterRowSlidablesRefresh()})},onRelationFieldChange:function(e,t){return this.onChanged2(e,t)},onChildUpdated:function(e,t,i){var n=this.getValue(t);(n=deepClone(n))[i][e.field.name]=e.value,this.setValue(t,n)},repeaterRowCount:function(e){return void 0!==this.localdata[e.name]&&Array.isArray(this.localdata[e.name])&&this.localdata[e.name].length?this.localdata[e.name].length:0},repeaterHasRows:function(e){return this.repeaterRowCount(e)},repeaterCanAddRow:function(e){return!(e.max&&this.repeaterRowCount(e)>=e.max)},toggleOpenRepeaterRow:function(e,t){if(!this.$store.state.modal_fields.active)return this.open_repeater_row(e,t);var i=this.openRepeaterRow,n=e.name+t;i===n&&(n=void 0),this.openRepeaterRow=n,setTimeout(this.syncRepeaterRowSlidables,0)},open_repeater_row:function(t,i){var n=this,e=this.getValue(t)[i];this.$store.commit("set_modal_fields_fields",t.fields),this.$store.commit("set_modal_fields_data",e),this.$store.commit("set_modal_fields_active",!0),this.$store.commit("set_modal_fields_update_callback",function(e){n.$store.commit("set_modal_assets_active",!1),console.log({data:e,field:t}),n.setValue(t,e,i)})},syncRepeaterRowSlidables:function(){$(".repeater .row.closed > .slidable").slideUp(100),$(".repeater .row:not(.closed) > .slidable").slideDown(100)},repeaterRowSlidablesRefresh:function(){var e=this;this.showRepeaterSlidableContent=!1,Vue.nextTick(function(){e.showRepeaterSlidableContent=!0,Vue.nextTick(e.repeater_auto_row_titles)})},repeaterAddRow:function(e){void 0===this.localdata[e.name]&&this.$set(this.localdata,e.name,[]),Array.isArray(this.localdata[e.name])||this.$set(this.localdata,e.name,[]),this.localdata[e.name].push({}),this.setValue(e,this.localdata[e.name]),this.repeaterRowSlidablesRefresh()},repeaterDeleteRow:function(e,t){var i;this.deletableRow===e.name+t?(this.deletableRow=void 0,(i=deepClone(i=this.getValue(e))).splice(t,1),this.setValue(e,i),this.repeaterRowSlidablesRefresh()):this.deletableRow=e.name+t},rowCanMoveUp:function(e,t){if(0==t)return!1;var i=this.getValue(e);return i&&i.length&&1<i.length},rowCanMoveDown:function(e,t){var i=this.getValue(e);return i&&i.length&&1<i.length&&t<i.length-1},repeaterMoveRowUp:function(e,t){var i,n,s,a;this.rowCanMoveUp(e,t)&&(i=!0,$(".modal-fields").length&&(i=!1),n=$("#main").scrollTop(),s=$(".blocks .rows .row").eq(t-1).outerHeight(),arraymove(a=deepClone(a=this.getValue(e)),t,t-1),this.setValue(e,a),this.repeaterRowSlidablesRefresh(),i&&setTimeout(function(){$("#main").scrollTop(n-s)},0))},repeaterMoveRowDown:function(e,t){var i,n,s,a;this.rowCanMoveDown(e,t)&&(i=!0,$(".modal-fields").length&&(i=!1),n=$("#main").scrollTop(),s=$(".blocks .rows .row").eq(t+1).outerHeight(),arraymove(a=deepClone(a=this.getValue(e)),t,t+1),this.setValue(e,a),this.repeaterRowSlidablesRefresh(),i&&setTimeout(function(){$("#main").scrollTop(n+s)},0))},repeater_row_title:function(e,t){if(!e.row_singular_title)return!1;var i=this.getValue(e);return!!i&&(!!i[t]&&(!!Object.values(i[t])&&(!!i[t][e.row_singular_title]&&i[t][e.row_singular_title])))},repeater_row_preview_html:function(t,e){if(!t.row_preview_field_name)return!1;var i=t.fields.filter(function(e){return e.name===t.row_preview_field_name});if(i=i.length?i[0]:void 0){var n=this.getValue(t);if(!n)return!1;if(!n[e])return!1;if(!Object.values(n[e]))return!1;if(!n[e][t.row_preview_field_name])return!1;var s=n[e][t.row_preview_field_name];if("text"==i.type)return'<div class="text">'+s+"</div>";if("asset"==i.type){if(!s||!s.uid)return;var a=this.asset_preview({uid:s.uid});if(a)return'<div class="asset">'+a+"</div>"}return"number"==i.type?'<div class="number">'+s+"</div>":"richtext"==i.type?'<div class="richtext">'+s+"</div>":void 0}},repeater_auto_row_titles:function(){$(".field.type-repeater").each(function(){$(this).find(".rows .row").each(function(){var e,t=$(this),i=t.find(".row-autotitle");i.length&&((e=t.find(".field input")).length&&i.text(e.eq(0).val()),(e=t.find(".field select")).length&&i.text(e.eq(0).find(":selected").text()))})})},repeaterDuplicateRow:function(e,t){var i=this.getValue(e);(i=deepClone(i)).splice(t,0,i[t]),this.setValue(e,i),this.repeaterRowSlidablesRefresh()},block_previewFrame_scrollTo:function(e){var t,i=klay.get_previewframe_block(e);i&&(t=i.offset().top,klay.scroll_previewframe_to(t,300,"easeInOutCubic"))},open_assets_modal:function(t){var i=this;this.$store.commit("set_modal_assets_active",!0),this.$store.commit("set_asset_selection_callback",function(e){i.setValue(t,{type:"asset",uid:e.uid}),i.$store.commit("set_modal_assets_active",!1)})},open_asset:function(e){this.$store.commit("set_modal_asset",deepClone(e)),this.$store.commit("set_modal_asset_active",!0)},open_richtext_modal:function(t){var i=this;this.$store.commit("set_modal_richtext_value",this.getValue(t)),this.$store.commit("set_modal_richtext_active",!0),this.$store.commit("set_modal_richtext_update_callback",function(e){i.setValue(t,e),i.$store.commit("set_modal_richtext_active",!1)})},open_block_row:function(t,i){var n=this,e=this.getValue(t)[i],s=e._type,a=this.$store.getters.get_block_schema(s);a?(this.$store.commit("set_modal_fields_fields",a.fields),this.$store.commit("set_modal_fields_data",e),this.$store.commit("set_modal_fields_active",!0),this.$store.commit("set_modal_fields_update_callback",function(e){n.setValue(t,e,i),n.$store.commit("set_modal_assets_active",!1)})):this.toast({text:"Block type no longer available, please delete the block and use another.",icon:"warning",type:"error"})},asset_swap:function(e){if(console.log({m:"asset_wrap",data:e}),!window.x9782)return window.x9782=e;e=window.x9782,window.x9782=void 0},init_blocks_sortable:function(i){var n=this;$(".field.type-blocks .rows").each(function(){var e=$(this).get(0);$(this).attr("data-fieldname"),new Sortable(e,{animation:150,draggable:".row",onStart:function(e){console.log("onStart",e)},onEnd:function(e){console.log("onEnd",e),console.log("from: "+e.oldIndex+" to: "+e.newIndex);var t=n.getValue(i);arraymove(t=deepClone(t),e.oldIndex,e.newIndex),n.setValue(i,t)},onChange:function(e){console.log("onChange",e)}});console.log("rows sortabled")})},stripHtml:function(e){if(!e)return"";var t=document.createElement("DIV");return t.innerHTML=e,t.textContent||t.innerText||""},select_options:function(e){var t=[],i=this.getValue(e),n=Array.isArray(e.options);for(var s in e.options){var a=e.options[s],o=n?e.options[s]:s,l=o===i;t.push({label:a,value:o,selected:l,options:e.options})}return t},relation_item:function(e){var t=this.getValue(e);if(t&&t.uid&&t.uid)return this.get_item("any",t.uid)},relation_item_title:function(e){var t=this.relation_item(e);if(e)return t.title?t.title:"Unnamed item"},relation_options:function(e){console.log({msg:"loading relation_options ...",field:e,field_types:e.types,field_types_str:e.types?e.types.join(","):"all",active_item_uid:this.url_params.uid});var t={types:e.types?e.types.join(","):"all",ignore_uid:this.url_params.uid};this.api_get("fetch_relations_field_items",t).done(function(e){console.log({msg:"loading fetch_relations_field_items done",r:e})}).fail(function(e){console.log({msg:"loading fetch_relations_field_items fail",r:e})})},is_selected:function(e,t,i){return!!e.selected||(!!(this.localdata&&this.localdata[i.name]&&Array.isArray(this.localdata[i.name])&&this.localdata[i.name].includes(e.value))||void 0)},showAddBlockButtons:function(t,i){var n=this,e=this.get_block_options(t);this.$store.commit("set_modal_addblock_blocktypes",e),this.$store.commit("set_modal_addblock_field",t),this.$store.commit("set_modal_addblock_active",!0),this.$store.commit("set_modal_addblock_onselected",function(e){n.addBlock(t,e,i)})},get_block_options:function(e){var t=[];if(!this.cms_config.blocks)return t;var i,n=_createForOfIteratorHelper(this.cms_config.blocks);try{for(n.s();!(i=n.n()).done;){var s=i.value;e.only&&!e.only.includes(s.name)||e.not&&e.not.includes(s.name)||t.push(s)}}catch(e){n.e(e)}finally{n.f()}return t},addBlock:function(e,t,i){void 0===this.localdata[e.name]&&this.$set(this.localdata,e.name,[]),Array.isArray(this.localdata[e.name])||this.$set(this.localdata,e.name,[]);var n={_type:t.name};this.localdata[e.name].splice(i,0,n),this.setValue(e,this.localdata[e.name])},group_icon:function(e){if(-1!==e.indexOf("icon("))return e.substring(e.indexOf("icon(")+5,e.lastIndexOf(")"))},group_label:function(e){return this.group_icon(e)?e.replace(this.group_icon(e),"").replace("icon()",""):e},help_click:function(e){this.toast({icon:"info",text:e.help,position:"bottom-center"})},get_mapvalue:function(e,t){var i=this.getValue(t);if(i)return i[e]},mapOnChange:function(e,t){this.setValue(t,e)},preview_field_html:function(e){if(e&&e.field&&e.field.name){var t=e.field.name.split("-").join("_");return klay.field_previews[t]?klay.field_previews[t](e):""}},block_preview_cls:function(){return{johnny:!0}},block_preview_css:function(){return{backgroundColor:"red"}},block_custom_btns:function(e){if(e&&e.type){var t=e.type.split("-").join("_"),i=klay.block_custom_btns[t];if(i)return i}},block_preview_html:function(e){if(e&&e.type){var t=e.type.split("-").join("_"),i=function(e){return e};e.data=i(e.data),e.alldata=i(e.alldata),e.asset_preview=this.asset_preview,e.asset_preview_or=this.asset_preview_or;var n=klay.block_previews["before_"+t]||klay.block_previews[t]||klay.block_previews["after_"+t];if(n||this.$store.state.block_autopreviews){var s=this.block_auto_preview_html(e),a=s&&s.length;if(n||a){var o=["type-"+e.type];klay.block_previews.cls&&(o=o.concat(klay.block_previews.cls(e))),klay.block_previews["cls_"+t]&&(o=o.concat(klay.block_previews["cls_"+t](e)));var l={};klay.block_previews.css&&(l=deepMerge(l,klay.block_previews.css(e))),klay.block_previews["css_"+t]&&(l=deepMerge(l,klay.block_previews["css_"+t](e)));var r=(r=$("<div></div>").css(l).attr("style"))||"",c='<div class="blockpreview '+o.join(" ")+'" style="'+r+'">';return klay.block_previews.before&&(c+=klay.block_previews.before(e)),klay.block_previews["before_"+t]&&(c+=klay.block_previews["before_"+t](e)),klay.block_previews[t]&&(c+=klay.block_previews[t](e)),!klay.block_previews[t]&&a&&(c+=s),klay.block_previews.after&&(c+=klay.block_previews.after(e)),klay.block_previews["after_"+t]&&(c+=klay.block_previews["after_"+t](e)),c+="</div>"}}}},block_auto_preview_html:function(e){var t=this.$store.getters.get_block_schema(e.type);if(t&&t.fields){var i=t.fields.filter(function(e){return isTrue(e.cms_autopreview)});if(i.length){var n="";for(var s in n+='<div class="cols-auto">',i){var a=i[s],o=e.data[a.name];"asset"==a.type&&(n+=this.asset_preview_or(o,"<div></div>")),"richtext"==a.type&&(n+='<div class="richtext">'+(o||"")+"</div>"),"text"==a.type&&(n+='<div class="richtext">'+(o||"")+"</div>")}return n+="</div>"}}},set_item_fields_data:function(e){this.$set(this,"localdata",e),this.$emit("updated",{localdata:this.localdata})},set_item_blocks_data:function(e){var t=(t=this.localdata.blocks?this.localdata.blocks:[]).concat(e);this.$set(this.localdata,"blocks",t),this.$emit("updated",{localdata:this.localdata})},block_update:function(e){this.setValue(e.field,e.data,e.row_i)}},watch:{data:function(){console.log({fn:"watch: data changed"}),Vue.nextTick(this.repeater_auto_row_titles)}},mounted:function(){var t=this;this.$set(this,"localdata",deepClone(this.data)),this.localdata||this.$set(this,"localdata",{});var e,i=_createForOfIteratorHelper(this.fields);try{for(i.s();!(e=i.n()).done;){var n=e.value;void 0===this.localdata[n.name]&&this.$set(this.localdata,n.name,n.default?n.default:void 0)}}catch(e){i.e(e)}finally{i.f()}this.has_grouping&&(this.activeGroup=this.groups[0]),$win.resize(throttle(this.syncRepeaterRowSlidables,500)),Vue.nextTick(this.repeater_auto_row_titles),mitter.on("repeater-auto-row-titles",this.repeater_auto_row_titles),mitter.on("repeater-row-slidables-refresh",this.repeaterRowSlidablesRefresh),mitter.on("single-item-set-fields",function(e){t.set_item_fields_data(e)}),mitter.on("single-item-set-blocks",function(e){t.set_item_blocks_data(e)})}}),Vue.component("item-field-relation",{template:'\n            <div>\n    \n                <select v-if="itemtypes" @change="onChange($event)" v-once :multiple="field.multiple">\n                    <option value="" :selected="(!data)">-</option>\n                    <optgroup v-for="(itemtype,itemtype_i) in itemtypes" :label="itemtype.name" v-if="itemtype.items">\n                        <option v-for="(item,item_i) in itemtype.items" :value="itemtype.name+\'-\'+item.uid" :selected="itemSelected(item)">\n                            {{itemTitle(item)}}\n                        </option>\n                    </optgroup>\n                </select>\n        \n                <pre v-if="0">Relation component</pre>\n                <pre v-if="0">data:{{data}}</pre>\n                <pre v-if="0">itemtypes:{{itemtypes}}</pre>\n                <pre v-if="0">field:{{field}}</pre>\n    \n            </div>\n        ',mixins:[mixins.basic],props:{field:{type:Object,default:void 0},data:{type:Object,default:void 0}},data:function(){return{itemtypes:void 0}},computed:{},methods:{itemTitle:function(e){return this.is_multilingual||e.language&&e.language!==this.primary_language.code?e.title+" ("+this.get_language_name(e.language||"Default language")+")":e.title},load_items:function(){var t=this,e={types:this.field.types?this.field.types.join(","):"all"};this.api_get("fetch_relations_field_items",e).done(function(e){t.itemtypes=e.itemtypes,Vue.nextTick(function(){mitter.emit("repeater-auto-row-titles")})}).fail(function(e){})},itemSelected:function(e){if(!this.data)return!1;if(this.data.uid&&this.data.uid===e.uid)return!0;if(Array.isArray(this.data)){var t,i=_createForOfIteratorHelper(this.data);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.uid&&n.uid===e.uid)return!0}}catch(e){i.e(e)}finally{i.f()}}return!1},onChange:function(e){var t=getSelectValues(e.target);if(!t||!t.length)return this.$emit("updated",void 0);var i,n=[],s=_createForOfIteratorHelper(t);try{for(s.s();!(i=s.n()).done;){var a=i.value.split("-");2===a.length&&n.push({type:a[0],uid:a[1]})}}catch(e){s.e(e)}finally{s.f()}return n.length?this.field.multiple?void this.$emit("updated",n):this.$emit("updated",n[0]):void 0}},watch:{data:function(){Vue.nextTick(function(){mitter.emit("repeater-row-slidables-refresh")})}},created:function(){this.load_items()},mounted:function(){}}),Vue.component("asset-preview",{template:'<div class="asset-preview" :class="cls" :data-format="format">\n      \n        <img v-if="is_img" :src="asset_preview_img_url(asset_local)" alt="" />\n        \n        <video v-if="is_video" controls muted preload="metadata">\n            <source :src="asset_preview_video_url(asset_local)" type="video/mp4" />\n        </video>\n\n        <div class="format" v-if="is_other_format">{{format}}</div>\n        \n        <div class="title" v-if="is_other_format">{{asset_local.title}}.{{format}}</div>\n\n    </div>',props:{asset:{type:Object,default:void 0},uid:{type:String,default:void 0}},mixins:[mixins.basic],data:function(){return{asset_local:void 0}},computed:{cls:function(){var e={};return this.is_img&&(e["is-img"]=1),this.is_video&&(e["is-video"]=1),this.is_other_format&&(e["is-other-format"]=1),e},format:function(){return this.asset_local?this.asset_local.format:void 0},is_img:function(){return this.asset_local&&this.asset_is_img(this.asset_local)},is_video:function(){return this.asset_local&&this.asset_is_video(this.asset_local)},is_other_format:function(){return this.asset_local&&!this.is_img&&!this.is_video}},methods:{},mounted:function(){var e,t=this;this.asset&&!this.uid&&(this.asset_local=this.asset),!this.asset&&this.uid&&(this.asset_local=this.get_asset(this.uid)),!this.asset&&this.uid&&((e=window.asset_previews_fetched["uid:"+this.uid])&&Vue.set(this,"asset_local",e),e||(window.asset_previews_queue.push(this.uid),window["asset_preview_onfetched_"+this.uid]=function(e){console.log({m:"ASSET PREVIEW QUEUE - FETCHED",uid:t.uid,a:e}),Vue.set(t,"asset_local",e)},klay.vue.$nextTick(function(){window.fetch_asset_previews_queue()})))},created:function(){}}),Vue.component("assets",{template:'<div class="assets">\n      \n      <div>\n        <input id="fileinput" class="hide" type="file" @change="fileinput_onchange($event)">\n        <div class="btn" @click="triggerFileInputClick()"><ic>file_upload</ic> {{str(\'upload_file\')}}...</div>\n      </div>\n\n      <div class="spacer"></div>\n      \n      <card :title="card_title">\n          \n          <div class="assets-list-header">\n            <div></div>\n            <div>\n               <select v-model="filter_asset_tag" v-if="asset_tags" @change="on_tag_filter_changed">\n                <option :value="undefined">{{str(\'show_all\')}}</option>\n                <option value="only-empty">{{str(\'untagged\')}}</option>\n                <option v-for="(tag,tag_i) in asset_tags" :value="tag">{{tag}}</option>\n               </select>\n            </div>\n            <div>\n                <input class="assets-list-search" type="text" :placeholder="str(\'search\')" v-model="filter_asset_search" @change="on_search_changed">\n            </div>\n          </div>\n\n          <div class="assets-list" :class="list_cls">\n              <div class="item" v-for="(asset,asset_i) in assets_visible" :class="item_cls(asset,asset_i)" :key="\'x67s67\'+asset.uid">\n                  <div class="format" v-if="0">{{asset.format}}</div>\n                  <asset-preview :asset="asset" @click.native="open_asset(asset)"></asset-preview>\n                  <div class="open-btn" v-if="0" @click="open_asset(asset)">Open</div>\n                  <div class="select-overlay" v-if="selecting_asset" @click="select_asset(asset)"></div>\n                  <div class="select-btn" v-if="selecting_asset" @click="select_asset(asset)"><ic>done</ic> Select</div>\n                  <div class="checkmark" v-if="1" @click="toggle_checked(asset.uid)"><ic>done</ic></div>\n              </div>\n          </div>\n          <div v-if="!assets_visible || !assets_visible.length">\n            No assets found...\n          </div>\n\n          <br>\n          <div class="btn" @click="fetchMore()" v-if="has_more_to_load">{{str(\'load_more\')}}</div>\n\n          <div class="pagination" v-if="0">\n            <span class="prev" :class="{off:!(pagination.page_index > 0)}" @click="paginate_prev"><ic>west</ic></span>\n            <span class="num" v-for="(i) in pagination_pages" @click="paginate_to(i-1)" :class="{active:((i-1)==pagination.page_index)}" :key="\'4j2b\'+i">{{i}}</span>\n            <span class="next" :class="{off:!(pagination.page_index < (pagination_pages-1))}" @click="paginate_next"><ic>east</ic></span>            \n          </div>\n          <pre v-if="0">pagination:{{pagination}}</pre>\n          <pre v-if="0">pagination_pages:{{pagination_pages}}</pre>\n          <pre v-if="0">assets_filtered.length:{{assets_filtered.length}}</pre>\n      </card>\n      \n      <card v-if="has_checked_items">\n        <div class="btns">\n            <div class="btn" @click="uncheck_all()">{{str(\'uncheck_all\')}}</div>\n            <div class="btn" @click="check_all()">{{str(\'check_all\')}}</div>\n            <div class="btn" @click="items_modify_tag(\'add\')">{{str(\'add_tag\')}}</div>\n            <div class="btn" @click="items_modify_tag(\'remove\')">{{str(\'remove_tag\')}}</div>\n            <div class="btn" v-if="0" @click="delete_multiple_assets()">{{str(\'delete_selected\')}}</div>\n        </div>\n      </card>\n\n      <card title="Dev: assets" v-if="0"><pre>{{assets}}</pre></card>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{assets:[],asset_tags:void 0,filter_asset_tag:void 0,filter_asset_search:void 0,pagination_limit:80,pagination_offset:0,all_loaded:!1,has_more_to_load:!1,checked_items:[]}},computed:{assets_filtered:function(){var e=this.assets;return e},pagination_pages:function(){return 1},asset_selection_callback:function(){return this.$store.state.asset_selection_callback},selecting_asset:function(){return this.asset_selection_callback},pagination:function(){return this.$store.state.assets.pagination},assets_visible:function(){var e=this.assets_filtered;return e||e},card_title:function(){return this.assets&&this.assets.length?this.assets.length+" "+this.str("assets"):this.str("assets")},has_checked_items:function(){return this.checked_items.length},list_cls:function(){var e={};return this.has_checked_items&&(e["has-checked-items"]=1),e}},methods:{open_asset:function(e){this.$store.commit("set_modal_asset",deepClone(e)),this.$store.commit("set_modal_asset_active",!0)},select_asset:function(e){this.$store.commit("set_modal_asset_active",!1),this.$store.state.asset_selection_callback(e),this.$store.commit("set_asset_selection_callback",void 0)},fileinput_onchange:function(e){var t=e.target.files[0],i=this.$store.state.assets_lib.search_tag&&this.$store.state.assets_lib.search_tag.length&&"only-empty"!==this.$store.state.assets_lib.search_tag?this.$store.state.assets_lib.search_tag:void 0;this.uploadFile({file:t,asset:{tags:i}})},triggerFileInputClick:function(){$("#fileinput").trigger("click")},on_search_changed:function(){this.filter_asset_tag&&(this.filter_asset_tag=void 0),this.assets=[],this.pagination_offset=0,this.fetch(),this.uncheck_all()},on_tag_filter_changed:function(){this.filter_asset_search&&(this.filter_asset_search=void 0),this.assets=[],this.pagination_offset=0,this.fetch(),this.uncheck_all()},paginate_to:function(e){this.$store.commit("set_assets_pagination_page_index",clamp(e,0,this.pagination_pages))},paginate_next:function(){this.paginate_to(this.pagination.page_index+1)},paginate_prev:function(){this.paginate_to(this.pagination.page_index-1)},fetch_asset_tags:function(){var t=this;return this.api_get("fetch_content_tags",{type:"asset"}).done(function(e){t.asset_tags=e.tags}).fail(function(e){})},fetch:function(){var n=this,e={type:"asset",columns:"*",limit:this.pagination_limit+1,offset:this.pagination_offset};this.filter_asset_search&&(e.search=this.filter_asset_search),this.filter_asset_tag&&this.filter_asset_tag.length&&(e.tagged=this.filter_asset_tag),this.loading_content=!0,this.fetch_content(e).then(function(e){var t=e.data;n.has_more_to_load=t.length>n.pagination_limit,n.has_more_to_load&&(t=t.slice(0,-1)),n.$set(n,"assets",n.assets.concat(t))}).catch(function(e,t,i){404==e.status&&(n.all_loaded=!0)}).always(function(){n.loading_content=!1,n.savePersistantState()})},fetchMore:function(){this.pagination_offset+=this.pagination_limit,this.fetch()},refetch:function(){this.$set(this,"assets",[]),this.fetch()},savePersistantState:function(){this.$store.commit("set_assets_lib_search_str",this.filter_asset_search),this.$store.commit("set_assets_lib_search_tag",this.filter_asset_tag),this.$store.commit("set_assets_lib_loaded_asset_tags",this.asset_tags)},loadPersistantState:function(){this.filter_asset_search=this.$store.state.assets_lib.search_str,this.filter_asset_tag=this.$store.state.assets_lib.search_tag,this.asset_tags=this.$store.state.assets_lib.loaded_asset_tags},item_cls:function(e){var t={};return this.is_checked(e.uid)&&(t.checked=1),t},is_checked:function(e){return this.checked_items.includes(e)},toggle_checked:function(t,e){null==e&&(e=!this.is_checked(t));var i=this.is_checked(t);!e&&i&&this.$set(this,"checked_items",this.checked_items.filter(function(e){return e!==t})),e&&!i&&this.checked_items.push(t)},uncheck_all:function(){this.$set(this,"checked_items",[])},check_all:function(){var e,t=[],i=_createForOfIteratorHelper(this.assets);try{for(i.s();!(e=i.n()).done;){var n=e.value;t.push(n.uid)}}catch(e){i.e(e)}finally{i.f()}this.$set(this,"checked_items",t)},items_modify_tag:function(e){var t=this;console.log(this.checked_items);var i=prompt("?");if(i&&i.length)return this.spinner({active:!0,blocking:!0}),this.api_post("items_modify_tag",{type:"asset",mode:e,tag:i,uids:this.checked_items.join(",")}).done(function(e){t.toast({icon:"check_circle",text:t.str("updated")}),t.refetch(),t.fetch_asset_tags(),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:"Could not perform requested action...",icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})},delete_multiple_assets:function(){console.log(this.checked_items),this.toast({text:"Feature coming soon."})}},mounted:function(){this.loadPersistantState(),this.fetch(),this.fetch_asset_tags(),mitter.on("assets-list-refresh",this.refetch),mitter.on("assets-tags-refresh",this.fetch_asset_tags)},created:function(){},destroyed:function(){this.selecting_asset&&this.$store.commit("set_asset_selection_callback",void 0)}}),Vue.component("languages",{template:'<div>\n\n    <table class="table1" v-if="languages_local && languages_local.length">\n        <thead>\n            <tr>\n                <th>{{str(\'language\')}}</th>\n                <th>{{str(\'code\')}}</th>\n                <th>{{str(\'primary\')}}</th>\n                <th>Item(s)</th>\n                <th>String(s)</th>\n                <th></th>\n            </tr>\n        </thead>\n        <tr v-for="(lang,lang_i) in languages_local">\n            <td>{{get_language_name(lang.code)}}</td>\n            <td>{{lang.code}}</td>\n            <td>\n                <span v-if="lang.primary" class="txtlink noclick"><ic>radio_button_checked</ic></span>\n                <span v-else class="txtlink dimmed" @click="setPrimaryLanguage(lang.code)"><ic>radio_button_unchecked</ic></span>\n            </td>\n            <td>-</td>\n            <td>-</td>\n            <td><span class="txtlink" @click="removeLanguage(lang.code)" v-if="languages_local && languages_local.length > 1"><ic>highlight_off</ic></span></td>\n        </tr>        \n    </table>\n\n    <div v-if="languages_local && !languages_local.length">\n        No language(s) defined. Defaulting to english.\n    </div>\n\n    <div class="spacer"></div>\n    \n    <div v-if="!addingLanguage">\n        <span class="btn" @click="setAddingLanguage(true)"><ic>add</ic> {{str(\'add\')}}</span>\n    </div>               \n    <div v-if="addingLanguage">\n        <div class="field">\n            <select ref="langselect">\n                <option v-for="(lang, lang_i) in language_options" v-if="!lang_is_active(lang.code)" :value="lang.code">{{lang.name}}</option>\n            </select>\n        </div>\n        <div class="spacer"></div>\n        <span class="btn" @click="addingLanguage=false"><ic>close</ic></span>\n        <span class="btn" @click="addLanguageFromSelect()"><ic>done</ic></span>\n    </div>\n    \n    <div class="spacer"></div>\n    \n    <span class="btn v2" @click="save()"><ic>save</ic> {{str(\'save\')}}</span>\n    \n    <pre v-if="0"><br><br>{{languages_local}}</pre>\n    \n    </div>',props:{},mixins:[mixins.basic],data:function(){return{languages_local:void 0,addingLanguage:!1,language_options:void 0}},computed:{langcodes:function(){return this.languages_local&&this.languages_local.length?this.languages_local.map(function(e,t){return e.code}):[]},languages:function(){return this.$store.getters.languages},strings:function(){return this.$store.getters.strings},primary_language:function(){if(this.languages_local&&this.languages_local.length)return this.languages_local.filter(function(e){return!0===e.primary})[0]},OLD____languages_listed:function(){var e=[],t=[],i=this.languages,n=this.$store.getters.get_item_languages(this.$store.getters.all_items);for(var s in i){var a=i[s],o=this.$store.getters.get_language_items(s);e.push({code:a.code,name:a.name,primary:!0===a.primary||"true"===a.primary,active:!0,items_count:o.length,strings_count:0}),t.push(a.code)}var l,r=_createForOfIteratorHelper(n);try{for(r.s();!(l=r.n()).done;){var c,d=l.value;t.includes(d)||(c=this.$store.getters.get_language_items(d),e.push({code:d,name:this.$store.getters.get_language(d).name,primary:!1,active:!1,items_count:c.length,strings_count:0}))}}catch(e){r.e(e)}finally{r.f()}return e.push({name:"Unassigned language",primary:!1,active:!1,items_count:this.$store.getters.all_item_unassigned_language.length,strings_count:0}),e.sort(function(e,t){return e.name>t.name}),e}},methods:{lang_is_active:function(e){return this.langcodes&&this.langcodes.length&&this.langcodes.includes(e)},setAddingLanguage:function(e){var t=this;(this.addingLanguage=e)&&setTimeout(function(){t.$refs.langselect.focus()},0)},set_languages_local:function(){var e=(e=deepClone(this.languages))||[];this.$set(this,"languages_local",e)},removeLanguage:function(t){var i=this;this.languages_local.length<2?this.toast({text:"At least one language definition is required.",icon:"warning",type:"error"}):klay.confirm({text:"Er du sikker?",onOkay:function(){var e=(e=i.languages_local).filter(function(e){return e.code!==t});i.$set(i,"languages_local",e),i.setPrimaryLanguageIfNotDefined()}})},addLanguageFromSelect:function(){var e,t=this.$refs.langselect.value;for(var i in language_options)language_options[i].code===t&&(e=language_options[i]);this.addLanguage(e),this.addingLanguage=!1},addLanguage:function(e){this.lang_is_active(e.code)||(this.languages_local||this.$set(this,"languages_local",[]),this.languages_local.push({code:e.code}),1==this.languages_local.length&&this.$set(this.languages_local[0],"primary",!0),this.sortLanguages())},sortLanguages:function(){var i=this;this.languages_local.sort(function(e,t){return i.get_language_name(e.name)>i.get_language_name(t.name)}),this.$set(this,"languages_local",this.languages_local)},setPrimaryLanguageIfNotDefined:function(){this.languages_local&&this.languages_local.length&&(this.primary_language||this.setPrimaryLanguage(this.languages_local[0].code))},setPrimaryLanguage:function(e){var t,i=_createForOfIteratorHelper(this.languages_local);try{for(i.s();!(t=i.n()).done;){var n=t.value;this.$set(n,"primary",void 0),n.code===e&&this.$set(n,"primary",!0)}}catch(e){i.e(e)}finally{i.f()}},save:function(){var t=this,e=deepMerge(deepClone(this.cms_config),deepClone({languages:this.languages_local}));return this.spinner({active:!0,blocking:!0}),this.api_post("save_cms_config",{cms_config:e}).done(function(e){t.toast({text:t.str("saved"),icon:"check_circle"}),t.fetch_cms_config(),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("could_not_save"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})}},watch:{languages:function(){this.set_languages_local()}},mounted:function(){},created:function(){this.language_options=language_options,this.set_languages_local()}}),Vue.component("logo",{template:'<component :is="tag" class="logo" v-html="svg"></component>',props:{tag:{type:String,default:"div"}},mixins:[mixins.basic],data:function(){return{default_svg:'<svg fill="none" height="71" viewBox="0 0 71 71" width="71" xmlns="http://www.w3.org/2000/svg"><g><path fill="#fff" clip-rule="evenodd" d="m58.1546 5.8269h-45.2274c-3.86594 0-6.99995 3.13401-6.99995 7v45.2274c0 3.8659 3.13401 7 7.00005 7h45.2273c3.866 0 7-3.1341 7-7.0001v-45.2273c0-3.86599-3.134-7-7-7zm-45.2274-4.999996c-6.62737 0-11.999954 5.372586-11.999954 11.999996v45.2274c0 6.6274 5.372594 12 12.000054 12h45.2273c6.6274 0 12-5.3726 12-12.0001v-45.2273c0-6.62741-5.3726-11.999996-12-11.999996z" fill-rule="evenodd"/><path fill="#DCF8C9" d="m48.6621 35.2936-3.633-2.625 3.171-3.717-4.767-1.281 1.386-4.263 4.557 1.869-.315-4.956h4.494l-.315 4.956 4.536-1.869 1.386 4.263-4.746 1.281 3.15 3.717-3.633 2.625-2.625-4.116z"/><path fill="#fff" d="m17.9197 50.5606v-30.24h5.061v14.028l12.075-14.028h6.216l-12.999 14.826 13.881 15.414h-6.426l-12.747-14.112v14.112z"/></g></svg>'}},computed:{svg:function(){var e=[this.$store.state.admin_logo,this.default_svg].filter(function(e){return null!=e})[0];return this.compactSidebar,e}}}),Vue.component("seeder",{template:'<div class="seeder">\n      \n        <loading type="spinner" v-if="loading_stats && !stats" />\n\n        <card v-if="item_schemas" v-if="stats">\n            <table class="stats-table">\n                <thead>\n                    <tr>\n                        <th class="align-l">Type</th>\n                        <th class="align-c">Actual items</th>\n                        <th class="align-c">Dummy items</th>\n                        <th class="align-c">Create dummy items</th>\n                        <th class="align-c">Delete dummy items</th>\n                    </tr>\n                </thead>\n                <tr v-for="(t,i) in types">\n                    <td>\n                        {{ucfirst(item_type_title(t,\'plural,single\'))}}\n                    </td>\n                    <td class="align-c">\n                        {{get_actual_items_count(t.name)}}\n                    </td>\n                    <td class="align-c">\n                        {{get_dummy_items_count(t.name)}}\n                    </td>\n                    <td class="align-c">\n                        <span class="txtlink" @click="seedplz(t)"><ic>add_circle</ic></span>\n                    </td>\n                    <td class="align-c">\n                        <span class="txtlink" :class="{dimmednoclick:!get_dummy_items_count(t.name)}" @click="deleteplz(t)"><ic>delete</ic></span>\n                    </td>\n                </tr>   \n            </table>\n        </card>\n\n        <div class="spacer" v-if="item_schemas && seededData"></div>\n        \n        <card v-if="item_schemas && seededData" title="Generated items">\n            <pre v-html="seededData"></pre>\n        </card>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{stats:void 0,loading_stats:!1,activeItemType:void 0,itemsCount:1,seededData:void 0}},computed:{types:function(){var e=this.item_schemas_only_non_singular;return e.push(_defineProperty({name:"asset",title_plural:this.str("assets")},"title_plural",this.str("assets"))),console.log(e),e},btn_title:function(){return this.itemsCount&&this.activeItemType&&0!=this.itemsCount?1==this.itemsCount?"Generate "+this.itemsCount+" "+this.item_type_title(this.activeItemType,"single,plural")+"...":"Generate "+this.itemsCount+" "+this.item_type_title(this.activeItemType,"plural,single")+"...":"Select type and number of items..."},delete_btn_title:function(){return this.activeItemType?"Delete all dummy "+this.item_type_title(this.activeItemType,"plural,single")+"...":"Select item type..."},plural_s:function(){return this.itemsCount&&1<this.itemsCount?"s":""}},methods:{get_actual_items_count:function(e){return this.stats&&this.stats[e]?this.stats[e].real_count:0},get_dummy_items_count:function(e){return this.stats&&this.stats[e]?this.stats[e].dummy_count:0},updateSeedableCount:function(e,t){var i=parseInt(t.target.value);this.$set(this.seedables,e.name,i)},seedplz:function(t){var i=this,n=prompt(this.str("how_many_items_to_create"));if(n=parseInt(n))return this.spinner({active:!0,blocking:!0}),this.seededData=void 0,this.api_get("generate_dummy_items",{type:t.name,count:n}).done(function(e){i.toast({text:"Seeded "+n+" dummy "+i.item_type_title(t,"plural,single"),icon:"check_circle"}),i.fetch_stats(),i.spinner({active:!1,blocking:!1}),i.seededData=e.seeded}).fail(function(e){i.toast({text:"Could not seed "+i.item_type_title(t,"plural,single"),icon:"warning",type:"error"}),i.spinner({active:!1,blocking:!1})});this.toast({text:"Invalid input.",icon:"warning",type:"error"})},deleteplz:function(t){var i=this;if(this.get_dummy_items_count(t.name)){var e=confirm(this.str("sure"));if(e&&confirm(this.str("sure")))return this.spinner({active:!0,blocking:!0}),this.seededData=void 0,this.api_get("delete_dummy_items",{type:t.name}).done(function(e){i.toast({text:"Deleted "+e.deleted_count+" dummy "+i.item_type_title(t,"plural,single"),icon:"check_circle"}),i.fetch_stats(),i.spinner({active:!1,blocking:!1})}).fail(function(e){i.toast({text:"Could not delete dummy "+i.item_type_title(t,"plural,single"),icon:"warning",type:"error"}),i.spinner({active:!1,blocking:!1})})}},fetch_stats:function(){var t=this;return this.loading_stats=!0,this.api_get("fetch_seeder_stats",{}).done(function(e){t.stats=e.stats,t.loading_stats=!1}).fail(function(e){alert("ERROR 235")})}},mounted:function(){this.fetch_stats()},created:function(){}}),Vue.component("trash",{template:'<div class="trash">\n      \n        <card :title="str(\'trash\')" icon="delete">\n            \n            <table class="table1">\n                <tr v-if="items.length">\n                  <td>\n                    Type\n                  </td>\n                  <td class="align-r">\n                    Title\n                  </td>\n                  <td class="align-r"><span class="txtlink recover-btn" @click="recover()">{{str(\'recover\')}}</span></td>\n                  <td class="align-r"><span class="txtlink delete-btn" @click="deleteItem()">{{str(\'delete\')}}</span></td>\n               </tr>\n               <tr v-if="!items.length">\n                  <td colspan="4">{{str(\'no_items_found\')}}</td>\n               </tr>               \n            </table>\n\n\n            <br>\n\n            <div class="btn" v-if="items.length" @click="deleteAllItems()">Permanently delete all trashed items</div>\n\n        </card>\n        \n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{items:[]}},computed:{},methods:{recover:function(){alert("This feature is still in beta.")},deleteItem:function(){alert("This feature is still in beta.")},deleteAllItems:function(){alert("This feature is still in beta.")}}}),Vue.component("geomap",{template:'<div class="geomap-container">\n      <div class="map" :id="map_id"></div>\n      <div class="crosshair"></div>\n      <input type="text" v-if="false" ref="textInput" @change="onTextChange()" />\n    </div>',props:{lat:{type:Object,default:void 0},lng:{type:Object,default:void 0},zoom:{type:Object,default:void 0}},mixins:[mixins.basic],data:function(){return{map_id:void 0,map:void 0,loaded:!1,moveend_count:0,token:void 0,markers:[]}},computed:{},methods:{add_marker:function(){var e=(new mapboxgl.Marker).setLngLat([-21.9270884,64.1436456]).addTo(this.map);this.markers.push(e)},geolocate_me:function(){},onTextChange:function(){},mapbox_load_lib:function(){load_file(["//api.tiles.mapbox.com/mapbox-gl-js/v2.6.1/mapbox-gl.js","https://api.tiles.mapbox.com/mapbox-gl-js/v2.6.1/mapbox-gl.css"]).then(this.init)},init:function(){var a=this;this.token&&this.map_id&&window.mapboxgl&&(mapboxgl.accessToken=this.token,this.map=new mapboxgl.Map({container:this.map_id,style:"mapbox://styles/mapbox/streets-v11",center:[this.lng,this.lat],zoom:this.zoom,attributionControl:!1}),this.map.on("error",function(e){klay.toast({text:e.error.message,icon:"warning",type:"error"})}),this.add_marker(),this.map.on("moveend",function(e){var t=a.map.getCenter(),i=a.map.getZoom(),n=t.lng,s=t.lat;a.$emit("change",{lat:s,lng:n,zoom:i}),a.moveend_count++}),console.log("init map"),console.log(this.map),this.map.on("zoomend",function(e){}),window.map=this.map)}},created:function(){},mounted:function(){var e=this;this.lng||(this.lng=12),this.lat||(this.lat=55),this.zoom||(this.zoom=16),!this.token&&this.cms_config.mapbox_api_token&&(this.token=this.cms_config.mapbox_api_token),this.map_id="map"+parseInt(9999999*Math.random()),Vue.nextTick(function(){e.mapbox_load_lib()})}}),Vue.component("code-editor",{template:'<div class="code-editor" :class="{ready:ready, unready:!ready}">\n\n        <loading type="spinner" v-if="!ready" />\n\n        <div class="codemirrorholder">\n            <textarea ref="codemirror_textarea" v-html="localCode" v-once></textarea>\n            <div class="invalid-code" v-if="!valid_code">INVALID CODE</div>\n        </div>\n\n    </div>',props:{code:{type:String,default:void 0},format:{type:String,default:void 0}},mixins:[mixins.basic],data:function(){return{uid:void 0,codemirror:void 0,localCode:void 0,ready:!1}},computed:{valid_code:function(){return"json"!=this.format||is_valid_json_str(this.localCode)}},watch:{},methods:{load_codemirror:function(){var e=this;if(window["codemirror_"+this.uid])return this.on_codemirror_loaded();load_file(["https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.18.3/codemirror.min.js","https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.18.3/codemirror.min.css","https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.18.3/theme/twilight.min.css"]).then(function(){e.on_codemirror_loaded(),window["codemirror_"+e.uid]=!0})},on_codemirror_loaded:function(){var e,s=this;this.codemirror||(e="application/json","json"==this.format&&(e="application/json"),this.codemirror=CodeMirror.fromTextArea(this.$refs.codemirror_textarea,{mode:e,theme:"twilight",indentWithTabs:!0,lineNumbers:!0,gutters:["CodeMirror-lint-markers"],tabSize:4,lint:!0}),this.ready=!0,this.codemirror.on("change",function(e,t,i){var n=s.codemirror.getValue();s.localCode=n,s.$emit("updated",{value:n,valid:s.valid_code})}))}},created:function(){this.uid="uid"+parseInt(9999*Math.random()),this.localCode=this.code},mounted:function(){this.load_codemirror()}}),Vue.component("items-list",{template:'<div class="items-list-view">\n\n      <loading type="spinner" v-if="loading_content" />\n    \n      <card v-if="items && items.length && !loading_content" :title="title" :icon="itemtype_icon">\n      \n        <div class="items-list-header">\n            <div></div>\n            <div>\n                <div class="field" v-if="all_item_tags && all_item_tags.length">\n                    <select :value="filter_tag" @change="filter_tags_onchange">\n                        <option :value="undefined">{{str(\'show_all_tags\')}}</option>\n                        <option v-for="(tag,tag_i) in all_item_tags" :value="tag">{{tag}}</option>\n                    </select>\n                </div>\n            </div>\n            <div>\n                <div class="field" v-if="schema_type_multilingual_enabled">\n                    <select v-model="filter_lang" v-if="is_multilingual" @change="filter_lang_onchange">\n                        <option v-for="(o) in lang_filter_options" :value="o.value">{{o.label}}</option>                \n                    </select>\n                </div>\n            </div>\n            <input class="items-list-search" type="text" :placeholder="str(\'search\')" v-model="filter_str">\n        </div>\n\n        <p v-if="0 && schema_type_multilingual_disabled">\n            schema_type_multilingual_disabled\n        </p>\n\n        <table class="table1 items-table" v-if="items_visible && items_visible.length" :key="Math.random()">\n            <thead>\n                <tr>\n                    <th></th>\n                    <th v-if="0"></th>\n                    <th>Title</th>\n                    <th v-if="is_multilingual && !filter_lang">{{str(\'language\')}}</th>\n                    <th>Status</th>\n                    <th v-if="item_type_has_url_slug">Link</th>\n                    <th>{{str(\'created\')}}</th>\n                </tr>\n            </thead>\n            <tr v-for="(item,item_i) in items_visible">\n                <td v-if="1">  \n                    <div class="icon-preview">{{item_icon_preview(item)}}</div>\n                </td>  \n                <td v-if="0">  \n                    <asset-preview v-if="0" :asset="item_preview_asset(item,item_type)"></asset-preview>\n                </td>  \n                <td>  \n                    <a class="link txtlink" :href="\'#item-\'+item_type+\'-uid-\'+item.uid" >\n                        {{item.title || \'Unnamed\'}}\n                    </a>\n                </td>  \n                <td v-if="is_multilingual && !filter_lang"> \n                    {{item.language ? get_language(item.language).name : \'Default language\'}}\n                </td> \n                <td v-if="item_type_has_url_slug">\n                    <ic>{{is_published(item) ? \'visibility\' : \'drive_file_rename_outline\'}}</ic> {{ is_published(item) ? str(\'public\') : str(\'draft\')}}\n                </td>  \n                <td>  \n                    <div v-if="is_published(item)">\n                        <a class="link txtlink" :href="get_item_url(item_schema, item)">\n                            <ic>arrow_outward</ic>\n                        </a>\n                    </div>\n                </td>  \n                <td>  \n                    {{item.created_at ? item.created_at : \'-\'}}\n                </td>  \n            </tr>\n        </table>\n        \n        <div class="pagination" v-if="items_visible && items_visible.length && pagination_pages > 1">\n            <span class="prev" :class="{off:!(pagination.page_index > 0)}" @click="paginate_prev"><ic>west</ic></span>\n            <span class="num" v-for="(i) in pagination_pages" @click="paginate_to(i-1)" :class="{active:((i-1)==pagination.page_index)}" :key="\'4j2b\'+i">{{i}}</span>\n            <span class="next" :class="{off:!(pagination.page_index < (pagination_pages-1))}" @click="paginate_next"><ic>east</ic></span>\n        </div>\n\n        <div v-if="!items_visible || !items_visible.length">\n          {{str(\'no_items_found\')}}\n        </div>\n\n        <div v-if="0">Todo here plz: Cards view alternative to list view</div>\n\n      </card>\n\n      <div class="spacer"></div>\n\n      <span class="btn" @click="create_item()" v-if="user_can_create && !loading_content">\n          <ic>{{itemtype_icon}}</ic>\n          {{create_new_item_title}}\n      </span>\n\n      <pre v-if="false">\n        user_can_create: {{user_can_create}} \n        user_can_create2: {{user_can(\'create:\'+item_type)}} \n      </pre>   \n\n      <br>\n\n      <card v-if="0" title="Dev: items"><pre>{{items}}</pre></card>\n      <card v-if="0" title="Dev: item_schema"><pre>{{item_schema}}</pre></card>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{loading_content:!1,items:void 0,all_item_tags:void 0,filter_str:void 0,filter_lang:void 0,filter_tag:void 0,pagination:{page_index:0,items_max:80}}},computed:{url_params:function(){return this.$store.getters.url_route.params},item_type:function(){return this.$store.getters.url_route.params.type},user_can_create:function(){return this.user_can("create:"+this.item_type)},schema_type_multilingual_disabled:function(){return this.item_schema&&isFalse(this.item_schema.multilingual)},schema_type_multilingual_enabled:function(){return!this.schema_type_multilingual_disabled},item_schema:function(){return this.$store.getters.get_item_schema(this.item_type)},is_singular:function(){return this.item_schema&&this.schema_is_singular(this.item_schema)},item_type_has_url_slug:function(){return this.item_schema&&void 0!==this.item_schema.url_slug},itemtype_icon:function(){return this.item_schema&&this.item_schema.icon?this.item_schema.icon:"topic"},title:function(){var e=this.item_type_title(this.item_schema,"plural,single");e=ucfirst(e);var t=this.str("found").toLowerCase();return this.items_filtered&&this.items_filtered.length!==this.items.length?e+": "+this.items_filtered.length+"/"+this.items.length+" "+t:this.items?e+": "+this.items.length+" "+t:e},create_new_item_title:function(){return this.str("create_new")+" "+this.item_type_title(this.item_schema,"single,plural")},items_filtered:function(){var e=this.items;if(e){var t=!!(this.filter_str&&this.filter_str.length&&1<this.filter_str.length)&&this.filter_str,i=!!(this.filter_lang&&this.filter_lang.length&&1<this.filter_lang.length)&&this.filter_lang,n=!!(this.filter_tag&&this.filter_tag.length&&1<this.filter_tag.length)&&this.filter_tag;return t&&(e=this.filter_items_by_str(e,t)),i&&(e=this.filter_items_by_lang(e,i)),n&&(e=this.filter_items_by_tag(e,n)),e=this.sort_items_by_date(e)}},pagination_pages:function(){if(!this.items)return 0;if(this.items_filtered<=this.pagination.items_max)return 1;for(var e=this.items_filtered.length,t=0;0<e;)0<e&&(t+=1),e-=this.pagination.items_max;return t},items_visible:function(){var e=this.items_filtered;if(!e)return e;var t=this.pagination.page_index*this.pagination.items_max,i=t+this.pagination.items_max;return e.slice(t,i)},lang_filter_options:function(){var e=[],t=[];e.push({value:void 0,label:this.str("show_all_languages")});var i,n=_createForOfIteratorHelper(this.languages);try{for(n.s();!(i=n.n()).done;){var s=i.value;e.push({value:s.code,label:this.get_language_name(s.code)}),t.push(s.code)}}catch(e){n.e(e)}finally{n.f()}var a,o=_createForOfIteratorHelper(this.$store.getters.get_item_languages(this.items||[]));try{for(o.s();!(a=o.n()).done;){var l=a.value;t.includes(l)||e.push({value:l,label:this.$store.getters.get_language(l).name})}}catch(e){o.e(e)}finally{o.f()}return e}},watch:{url_params:function(){this.filter_str=void 0}},methods:{is_published:function(e){return e&&isTrue(e.published)},filter_items_by_str:function(e,t){if(!e||!t)return e;t=t.toLowerCase();var i,n=[],s=_createForOfIteratorHelper(e);try{for(s.s();!(i=s.n()).done;){var a=i.value,o=a.title&&-1!==a.title.toLowerCase().indexOf(t),l=a.tags&&-1!==a.tags.toLowerCase().indexOf(t);(o||l)&&n.push(a)}}catch(e){s.e(e)}finally{s.f()}return n},filter_items_by_tag:function(e,t){if(!e||!t)return e;t=t.toLowerCase();var i,n=[],s=_createForOfIteratorHelper(e);try{for(s.s();!(i=s.n()).done;){var a=i.value;a.tags&&-1!==a.tags.toLowerCase().indexOf(t)&&n.push(a)}}catch(e){s.e(e)}finally{s.f()}return n},filter_items_by_lang:function(e,t){if(!e||!t)return e;t=t.toLowerCase();var i,n=[],s=_createForOfIteratorHelper(e);try{for(s.s();!(i=s.n()).done;){var a=i.value;a.language&&a.language===this.filter_lang&&n.push(a)}}catch(e){s.e(e)}finally{s.f()}return n},filter_lang_onchange:function(){var e=this.filter_lang;e&&this.$store.commit("set_ui_active_lang",e),this.paginate_to(0)},filter_tags_onchange:function(e){var t=e.target.value;this.filter_tag=t,this.paginate_to(0)},sort_items_by_date:function(e){return e.sort(function(e,t){var i=Date.parse(e.created_at),n=Date.parse(t.created_at);return i<n?-1:n<i?1:0}),e},item_css:function(e,t){var i={};return i.animationDelay=20*t+"ms",i},paginate_to:function(e){this.pagination.page_index=clamp(e,0,this.pagination_pages)},paginate_next:function(){this.paginate_to(this.pagination.page_index+1)},paginate_prev:function(){this.paginate_to(this.pagination.page_index-1)},create_item:function(){var t=this,e={};isTrue(this.item_schema.singular)||(e.title=this.str("New")+" "+this.item_schema.title_single),e.language=this.primary_language&&this.primary_language.code?this.primary_language.code:"en",this.ui_active_lang&&(e.language=this.ui_active_lang),isFalse(this.item_schema.multilingual)&&(e.language=this.primary_language.code),this.spinner({active:!0,blocking:!0}),this.api_post("save_item",{type:this.item_type,item:e}).done(function(e){t.spinner({active:!1,blocking:!1}),t.toast({text:t.str("item_created"),icon:"check_circle"}),t.fetch()}).fail(function(e){t.spinner({active:!1,blocking:!1}),t.toast({text:t.str("could_not_create_item"),icon:"warning",type:"error"})})},fetch_all_item_tags:function(){var t=this;return this.api_get("fetch_content_tags",{type:this.item_type}).done(function(e){t.all_item_tags=e.tags}).fail(function(e){})},fetch:function(){var t=this;this.clear_fetched_content(this.item_type),this.loading_content=!0;var e="uid,slug,title,tags,published,updated_at,created_at";this.is_multilingual&&(e+=",language_grouping,language"),this.fetch_content({type:this.item_type,columns:e}).then(function(e){t.items=e.data,t.is_singular&&t.items[0]&&t.items[0].uid&&t.gotoView("item-"+t.item_type+"-uid-"+t.items[0].uid),t.cache_keyman_listItems(t.items)}).catch(function(){}).always(function(){t.loading_content=!1})},cache_keyman_listItems:function(e){var t,i=_createForOfIteratorHelper(e);try{for(i.s();!(t=i.n()).done;){t.value.type=this.item_type}}catch(e){i.e(e)}finally{i.f()}this.$store.commit("set_keyman_cached_listItems",e)}},mounted:function(){this.fetch(),this.fetch_all_item_tags()},created:function(){this.filter_lang=this.ui_active_lang,this.schema_type_multilingual_disabled&&(this.filter_lang=this.primary_language.code)}}),Vue.component("item-single",{template:'<div class="items-single-view">\n    \n    <loading type="spinner" v-if="!item && loading_content" />\n\n    <card v-if="item">\n        <div class="item-header">\n\n            <div class="cols">\n               <div>\n\n                  <div v-if="!is_singular">\n                     <a class="type" :href="\'#items-\'+item_type">{{type_title}}</a>\n                  </div>\n\n                  <div class="title" v-if="is_singular">{{type_title}}</div>\n                  \n                  <div class="title" v-if="!editing_title && !is_singular">\n                     {{item.title || item.title || \'Unnamed\'}}\n                     <span class="editbtn" v-tooltip="str(\'edit\')" @click="edit_title()"><ic>edit</ic></span>\n                  </div>                  \n                  <div class="title-edit" v-if="editing_title && !is_singular">\n                     <input type="text" ref="title_edit" v-model="item.title" placeholder="Unnamed" @change="title_edit_changed()" @blur="editing_title = false" autofocus>\n                  </div>\n\n                  <div class="urledit" @click="showSlugUi" v-if="!is_singular">\n                    <ic>link</ic> <span class="x">{{ item_url || item.slug }}</span> <ic>edit</ic>\n                  </div>\n\n                  <div class="langlinks" v-if="is_multilingual && languages && schema_type_multilingual_enabled">\n                    <template v-for="(ll) in langlinks">\n                        <span v-if="ll.current" class="current">{{ll.code}}</span>\n                        <a :class="{primary:ll.primary, grouped:ll.grouped, current:ll.current, surplus:ll.surplus}" v-if="!ll.current && ll.uid" :href="\'#item-\'+item_type+\'-uid-\'+ll.uid">{{ll.code}}</a>\n                        <span v-if="!ll.grouped && ll.code!==item.language" class="missing" @click="addLangClone(ll.code)" v-tooltip="str(\'create_langlink\')">+{{ll.code}}</span>\n                    </template>\n                  </div>\n\n                  <pre v-if="0">langlinks: {{langlinks}}</pre>\n                  <pre v-if="0">languages: {{languages}}</pre>\n                  <pre v-if="0">languagescodes: {{languagescodes}}</pre>\n                  <pre v-if="0">langitems: {{langitems}}</pre>\n\n               </div>\n               <div>\n               \n                  <div class="actionbtns">\n                  \n                     <div class="btn --s revisions-btn" v-if="0" @click="versions_view_active = !versions_view_active" :class="{depressed:versions_view_active}">\n                        <ic>settings_backup_restore</ic> Versions\n                     </div>\n\n                     <div class="btn --s" v-tooltip="str(\'clone_this_item\')" v-if="user_can_publish && !is_singular" @click="showCloneUi(item_type,item)">\n                        <ic>difference</ic>\n                     </div>\n\n                     <div class="btn --s" v-if="user_can_publish" @click="showItemSettings()" :class="{depressed:settings_panel_visible}" v-tooltip="str(\'settings\')">\n                        <ic>settings</ic>\n                     </div>\n                     \n                     <div class="btn --s" v-tooltip="str(\'toggle_draft_or_published\')" v-if="user_can_publish" :class="{active:is_published}" @click="togglePublished()">\n                        <ic>{{is_published ? \'visibility\' : \'drive_file_rename_outline\'}}</ic> {{is_published ? str(\'public\') : str(\'draft\')}}\n                     </div>\n                     \n                     <a class="btn --s" v-tooltip="str(\'preview\')" @click="togglePreviewFrame()" :class="{depressed:previewFrame.active}" v-if="item_url && preview_enabled && previewFrame_url">\n                        <ic>visibility</ic>\n                     </a>\n                     \n                     <a class="btn --s" v-if="item_url" :href="item_url" v-tooltip="str(\'link\')">\n                        <ic>arrow_outward</ic>\n                     </a>\n                     \n                     <div class="save-btn" @click="update_item()" :class="{ __inactive:!hasUnsavedChanges }">\n                        <ic>save</ic> {{str(\'save\')}}\n                     </div>\n\n                  </div>\n\n               </div>\n            </div>\n            \n        </div>\n    </card>\n\n    <p v-if="0 && schema_type_multilingual_disabled">\n        schema_type_multilingual_disabled\n    </p>\n\n    <div class="spacer" v-if="settings_panel_visible && item"></div>\n\n    <card v-if="settings_panel_visible && item" :title="str(\'settings\')" icon="settings">\n    \n        <div class="grid-1111">\n        \n            <div class="field" v-if="0">\n                <div class="label">URL slug</div>\n                <input type="text" v-model="item.slug" @change="onchange_slug()" />\n            </div>\n            \n            <template v-if="is_multilingual || item.language !== primary_language.code">\n\n                <div class="field type-checkbox" v-if="1 || is_multilingual">\n                    <div class="label">{{str(\'language\')}}</div>\n                    <select ref="langselect" v-model="item.language" @change="hasUnsavedChanges=true">\n                        <option v-for="(lang, lang_i) in languages" :value="lang.code">{{get_language_name(lang.code)}}</option>\n                        <option v-if="!$store.getters.has_active_language(item.language)" :value="item.language">{{get_language_name(item.language)}}</option>\n                    </select>\n                </div>\n\n                <div class="field">\n                    <div class="label">Translation grouping ID</div>\n                    <input type="text" v-model="item.language_grouping" @change="hasUnsavedChanges=true" />\n                </div>\n                \n            </template>\n\n\n            <div class="field">\n                <div class="label has-helper">{{str(\'tags\')}}<span class="helpicon" @click="tags_helper_click()">?</span></div>\n                <input type="text" v-if="0" v-model="item.tags" @change="hasUnsavedChanges=true" />\n                <tagfield :tags="item.tags" @updated="onTagsUpdated($event)">\n            </div>\n            \n            <div class="field">\n                <div class="label">{{str(\'created_at\')}}</div>\n                <input type="text" v-model="item.created_at" @change="onchange_created_at" />\n            </div>\n\n        </div>\n\n    </card>\n\n      <template v-if="item && versions_view_active">\n\n         <div class="spacer"></div>\n\n         <table class="single-item-versions-table">\n            <tr class="current">\n               <td><ic>{{1 ? \'visibility\' : \'visibility\'}}</ic></td>\n               <td>Current version</td>\n               <td><span class="create-version-btn">Create backup</span></td>               \n               <td></td>\n            </tr>\n            <tr class="previewing">\n               <td><ic>{{0 ? \'visibility\' : \'\'}}</ic></td>\n               <td>2022-02-02 - 11:32</td>\n               <td></td>\n               <td><span class="version-delete-btn">str(\'delete\')</span></td>               \n            </tr>\n            <tr v-for="(x) in 4">\n               <td><ic>{{0 ? \'visibility\' : \'\'}}</ic></td>\n               <td>2022-02-02 - 11:32</td>\n               <td><span class="version-preview-btn">Preview</span></td>               \n               <td><span class="version-delete-btn">str(\'delete\')</span></td>               \n            </tr>\n         </table>      \n\n         <div class="spacer"></div>\n\n      </template>\n\n      <div class="spacer"></div>\n\n      <card v-if="item" :key="\'23jn\'+item.uid">\n\n        <item-fields \n            :fields="item_schema.fields"\n            :data="item.fields"\n            @updated="setUnsavedChangesKeyValueFromFieldComponentEvent"\n        ></item-fields>\n\n      </card>\n\n      <div class="spacer"></div>\n\n      <span class="btn look1" @click="deleteItem()" v-if="item && user_can_delete && !is_singular" @mouseout="sure=false">\n         <ic>delete</ic> {{sure ? str(\'sure\') : str(\'delete\')}}\n      </span>\n\n      <card v-if="0" cls="color2" title="Dev: item"><pre>{{item}}</pre></card>\n      <card v-if="0" cls="color2" title="Dev: item"><pre>{{item}}</pre></card>\n      <card v-if="0" cls="color2" title="Dev: url_params"><pre>{{url_params}}</pre></card>\n      <card v-if="0" cls="color2" title="Dev: item_type"><pre>{{item_type}}</pre></card>\n      <card v-if="0" cls="color2" title="Dev: item_schema"><pre>{{item_schema}}</pre></card>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{loading_content:!1,item:void 0,hasUnsavedChanges:!1,sure:!1,editing_title:!1,versions_view_active:!1,settings_panel_visible:!1,fetched_langlinks:!1}},computed:{url_params:function(){return this.$store.getters.url_route.params},item_type:function(){return this.$store.getters.url_route.params.type},uid:function(){return this.url_params.uid},item_schema:function(){return this.$store.getters.get_item_schema(this.item_type)},languagescodes:function(){return this.$store.getters.languagecodes},is_singular:function(){return this.item_schema&&this.schema_is_singular(this.item_schema)},user_can_delete:function(){return this.user_can("delete:"+this.item_type)},user_can_publish:function(){return!0},schema_type_multilingual_disabled:function(){return this.item_schema&&isFalse(this.item_schema.multilingual)},schema_type_multilingual_enabled:function(){return!this.schema_type_multilingual_disabled},is_published:function(){return this.item&&isTrue(this.item.published)},type_title:function(){return ucfirst(this.item_type_title(this.item_schema,"single"))},item_url:function(){if(!this.item_schema||!this.item)return!1;var e=this.get_item_url(this.item_schema,this.item);return e||!1},item_url_minus_slug:function(){return this.item_url&&this.item?this.item.slug?this.item_url.replace(this.item.slug,""):this.item_url:""},langitems:function(){if(this.item&&this.is_multilingual&&this.item.language_grouping){var e=this.fetched_langlinks;return e&&e.length&&e.sort(),e}},langlinks:function(){var e,t=[],i=_createForOfIteratorHelper(this.languages);try{for(i.s();!(e=i.n()).done;){var n=e.value,s=n.code===this.item.language,a=this.lang_in_langitems(n.code),o=a?this.langitems_get_uid(n.code):void 0;t.push({code:n.code,primary:isTrue(n.primary),current:s,grouped:a,surplus:!1,uid:o})}}catch(e){i.e(e)}finally{i.f()}if(this.langitems){var l,r=_createForOfIteratorHelper(this.langitems);try{for(r.s();!(l=r.n()).done;){var c,d=l.value;d.language&&!this.languagescodes.includes(d.language)&&(c=d.language===this.item.language,t.push({code:d.language,primary:!1,current:c,grouped:!0,surplus:!0,uid:d.uid}))}}catch(e){r.e(e)}finally{r.f()}}return t}},watch:{item:function(){window.x87237672=this.item.fields}},methods:{get_items_where:function(e,t){return this.$store.getters.get_items_where(e,t)},toggleSettings_panel_visible:function(){this.settings_panel_visible=!this.settings_panel_visible},item_in_langitems:function(e){var t,i=_createForOfIteratorHelper(this.langitems);try{for(i.s();!(t=i.n()).done;){if(t.value.uid===e)return!0}}catch(e){i.e(e)}finally{i.f()}return!1},lang_in_langitems:function(e){if(!this.langitems)return!1;var t,i=_createForOfIteratorHelper(this.langitems);try{for(i.s();!(t=i.n()).done;){if(t.value.language===e)return!0}}catch(e){i.e(e)}finally{i.f()}return!1},langitems_get_uid:function(e){if(!this.langitems)return!1;var t,i=_createForOfIteratorHelper(this.langitems);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.language===e)return n.uid}}catch(e){i.e(e)}finally{i.f()}return!1},edit_title:function(){var e=this;this.editing_title=!0,setTimeout(function(){e.$refs.title_edit.focus()},0)},title_edit_changed:function(){this.editing_title=!1,this.hasUnsavedChanges=!0},togglePublished:function(){var e=isTrue(this.item.published);this.$set(this.item,"published",!e),this.hasUnsavedChanges=!0},onTagsUpdated:function(e){this.setUpdated("tags",e.value)},setUpdated:function(e,t){this.$set(this.item,e,t),this.hasUnsavedChanges=!0},setUpdatedValue:function(e,t){var i=e.target,n=i.value;this.el_is_checkbox(i)&&(n=i.checked),this.setUpdated(t,n)},setUnsavedChangesKeyValueFromFieldComponentEvent:function(e){this.$set(this.item,"fields",e.localdata),this.hasUnsavedChanges=!0},onchange_slug:function(){var e=this.item.slug;e&&e.length&&(e=(e=slugify(e=e.split("/").join("-allowed-slash-"))).split("-allowed-slash-").join("/"),this.$set(this.item,"slug",e)),this.hasUnsavedChanges=!0},showSlugUi:function(){var e=this.str("New URL slug?"),t=prompt(e,this.item.slug);t&&(this.item.slug=t,this.hasUnsavedChanges=!0,this.onchange_slug())},onchange_created_at:function(){var e=this.item.created_at;this.$set(this.item,"created_at",e),this.hasUnsavedChanges=!0},update_item:function(){var n=this;this.item.slug||this.$set(this.item,"slug",slugify(this.item.title?this.item.title:this.type_title+"-"+rand(111,999)));var e=deepClone(this.item);return!e.language&&this.primary_language&&(e.language=this.primary_language.code),this.spinner({active:!0,blocking:!0}),this.api_post("save_item",{type:this.item_type,item:e}).done(function(e){var t=n.str("item_updated"),i="check_circle";n.user_can_publish&&!n.item.published&&(t=n.str("item_updated_but_not_published"),i="warning"),n.toast({text:t,icon:i,position:"bottom-right"}),n.refreshPreviewFrame(),n.fetch().always(function(){n.spinner({active:!1,blocking:!1})})}).fail(function(e){n.toast({text:n.str("could_not_update_item"),icon:"warning",type:"error"}),n.spinner({active:!1,blocking:!1})})},deleteItem:function(){var t=this;if(confirm(this.str("sure")))return this.api_post("delete_item",{type:this.item_type,uid:this.item.uid}).done(function(e){t.toast({text:t.str("item_deleted"),icon:"check_circle"}),t.gotoView("items-"+t.item_type),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("could_not_delete_item"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})},showItemSettings:function(){this.toggleSettings_panel_visible()},addLangClone:function(e){var t,i,n=this;this.hasUnsavedChanges?this.toast({text:"You have unsaved changes, please save them first or refresh your browser.",icon:"check_circle"}):((t=deepClone(this.item)).language_grouping||(t.language_grouping="g"+generate_uid()),(i=deepClone(this.item)).uid=void 0,i.language=e,i.language_grouping=t.language_grouping,this.spinner({active:!0,blocking:!0}),this.api_post("save_item",{type:this.item_type,item:t}).done(function(e){n.api_post("save_item",{type:n.item_type,item:i}).done(function(e){n.toast({text:"Language version created",icon:"check_circle"}),n.fetch(),n.spinner({active:!1,blocking:!1})}).fail(function(e){n.toast({text:"Could not create language version",icon:"warning",type:"error"}),n.spinner({active:!1,blocking:!1})})}).fail(function(e){n.toast({text:n.str("could_not_update_item"),icon:"warning",type:"error"}),n.spinner({active:!1,blocking:!1})}))},fetch_langlinks:function(){var t=this;this.api_get("fetch_langlinks",{type:this.item_type,not_uid:this.uid,language_grouping:this.item.language_grouping}).done(function(e){t.fetched_langlinks=e.data}).fail(function(e){})},fetch:function(){var t=this;return this.loading_content=!0,this.fetch_content({type:this.item_type,uid:this.uid}).then(function(e){t.item=e.data,t.$store.commit("set_PreviewFrame_item",t.item),t.$store.commit("set_PreviewFrame_url",t.item_url),t.item&&t.item.fields&&(window.x87237672=JSON.parse(JSON.stringify(t.item.fields))),t.is_multilingual&&t.languages&&t.languages.length&&t.schema_type_multilingual_enabled&&t.fetch_langlinks()}).catch(function(){alert("LOAD ERROR")}).always(function(){t.loading_content=!1})},tags_helper_click:function(){var e=this.str("item_tags");this.item_schema.tags_tooltip&&(e=this.item_schema.tags_tooltip),this.toast({icon:"info",text:e,position:"bottom-center"})}},created:function(){var t=this;this.fetch();var i=this;$(document).bind("keydown.x875676",function(e){if(!i.$store.state.modal_fields.active&&!i.$store.state.modal_richtext.active)return(e.ctrlKey||e.metaKey)&&83==e.which?(e.preventDefault(),t.update_item(),!1):void 0})},mounted:function(){},destroyed:function(){this.setPreviewFrame(!1),$(document).unbind("keydown.x875676"),window.x87237672=void 0}}),Vue.component("view-home",{template:'<div class="view-home">\n\n        <card :title="str(\'home\')" icon="home">\n            <p>{{home_welcome_text}}</p>            \n        </card>\n\n        <card title="Status" icon="checklist" v-if="fixable_any">\n            <table class="table1">\n                <tr v-if="fixable_languages">\n                    <td><ic>translate</ic> &nbsp; No language(s) defined. Defaulting to english.</td>\n                    <td><span class="txtlink" @click="gotoView(\'language\')">Define language(s)...</span></td>\n                </tr>\n                <tr v-if="fixable_schemas">\n                    <td><ic>topic</ic> &nbsp; No item type(s) defined.</td>\n                    <td><span class="txtlink" @click="toast({text:\'Item types can be defined in PHP. If you are in doubt as to how to do this consult with your tech support. You can create anything you want.\'})">Get started...</span></td>\n                </tr>\n                <tr v-if="fixable_items" v-for="(t,i) in item_schemas" v-if="!item_type_has_items(t)">\n                    <td><ic>{{ (t.icon) ? t.icon : \'topic\' }}</ic> No {{ucfirst(item_type_title(t,\'plural,single\'))}} found.</td>\n                    <td><span class="txtlink" @click="fix_no_items()">Create {{item_type_title(t,\'plural,single\')}}...</span></td>\n                </tr>\n                <tr v-if="0 && fixable_no_assets">\n                    <td><ic>perm_media</ic> No assets found.</td>\n                    <td><span class="txtlink" @click="fix_no_assets()">Upload assets...</span></td>\n                </tr>\n            </table>\n      </card>\n\n      <div class="spacer"></div>\n      <card title="Content" icon="topic">\n        <div class="btns">\n            <span class="btn" v-if="item_schemas" v-for="(t,i) in active_item_schemas" @click="gotoItemType(t)">\n                <ic>{{ (t.icon) ? t.icon : \'topic\' }}</ic>\n                {{ ucfirst(item_type_title(t,\'plural,single\')) }}\n            </span>\n        </div>\n      </card>\n\n      <div class="spacer" v-if="homescreen_links"></div>\n      <card title="Links" icon="link" v-if="homescreen_links">\n        <div class="btns">\n            <a class="btn" v-for="(x) in homescreen_links" :href="x.url" :target="x.target||\'self\'"><ic v-if="x.icon">{{x.icon}}</ic><template v-if="x.icon">&nbsp;</template>{{x.label}}</a>\n        </div>\n      </card>\n\n      <div class="spacer"></div>\n      <div class="btns">\n        <span class="btn" @click="msg_bkups()"><ic>restore_page</ic> {{str(\'create_backup\')}}...</span>\n        <span class="btn" @click="logout()"><ic>logout</ic> {{str(\'log_out\')}}</span>\n      </div>\n        \n    </div>',mixins:[mixins.basic],props:{},computed:{assets:function(){return this.$store.getters.assets},fixable_languages:function(){return!this.languages||!this.languages.length},fixable_schemas:function(){return!this.item_schemas||!this.item_schemas.length},fixable_items:function(){var e=!1;if(this.item_schemas){var t,i=_createForOfIteratorHelper(this.item_schemas);try{for(i.s();!(t=i.n()).done;){var n=t.value;this.item_type_has_items(n.name)||(e=!0)}}catch(e){i.e(e)}finally{i.f()}}return e},fixable_any:function(){return this.fixable_languages||this.fixable_schemas||this.fixable_items},homescreen_links:function(){return!(!this.$store.state.phpdata||!this.$store.state.phpdata.homescreen_links)&&this.$store.state.phpdata.homescreen_links},assets_untrashed:function(){var e=this.$store.getters.assets;this.items_filter_untrashed(e);return e},home_welcome_text:function(){var e=this.str("home_welcome_text"),t="",i=this.logged_in_user;return i&&i.username&&(t=i.username),i&&i.name&&(t=i.name),e=e.replace("{username}",t)}},methods:{item_type_has_items:function(){return!0},fix_no_items:function(){this.toast({text:"You can start creating items by clicking the item type in the left menu. You can also create dummy items if you just want to test things out. This can be done under Settings > Dummy content."})},fix_no_assets:function(){this.toast({text:"You can upload assets by drag-dropping them into the screen, or by clicking the upload button in the Assets screen, accessible from the left hand menu."})},msg_bkups:function(){this.toast({text:"It's always a good idea to save backups once in a while. You might download them as well, if you want to be extra safe. Backups can be created from the Settings screen."})}},created:function(){}}),Vue.component("view-settings",{template:'<div>\n\n\n    <div class="tabs" v-if="1">\n        <div class="tab" :class="{active:tab===\'configuration\'}" @click="tab=\'configuration\'"><ic>settings</ic> {{str(\'settings\')}}</div>\n        <div class="tab" :class="{active:tab===\'backup\'}" @click="tab=\'backup\'"><ic>restore_page</ic> Backups</div>\n        <div class="tab" v-if="0" :class="{active:tab===\'schemas\'}" @click="tab=\'schemas\'">Schema editor</div>\n        <div class="tab" :class="{active:tab===\'seeding\'}" @click="tab=\'seeding\'"><ic>bubble_chart</ic> Dummy content</div>\n        <div class="tab" :class="{active:tab===\'about\'}" @click="tab=\'about\'"><ic>info</ic> {{str(\'about\')}}</div>\n        <div class="tab" v-if="0" :class="{active:tab===\'trash\'}" @click="tab=\'trash\'"><ic>delete</ic> {{str(\'trash\')}}</div>\n        <div class="tab" :class="{active:tab===\'logout\'}" v-if="!login_disabled" @click="tab=\'logout\'"><ic>logout</ic> {{str(\'log_out\')}}</div>\n    </div>\n\n    <div class="btns" v-if="0">\n        <div class="btn" :class="{v2:tab===\'configuration\'}" @click="tab=\'configuration\'">{{str(\'settings\')}}</div>\n        <div class="btn" :class="{v2:tab===\'backup\'}" @click="tab=\'backup\'">Backups</div>\n        <div class="btn" :class="{v2:tab===\'seeding\'}" @click="tab=\'seeding\'">Dummy content</div>\n        <div class="btn" :class="{v2:tab===\'about\'}" @click="tab=\'about\'"><ic>info</ic>{{str(\'about\')}}</div>\n        <div class="btn" :class="{v2:tab===\'logout\'}" @click="tab=\'logout\'">{{str(\'log_out\')}}</div>\n    </div>\n    \n    <div class="tabs" v-if="0 && tab===\'configuration\'">\n        <div class="tab" :class="{active:tab82==1}" @click="tab82=1">Languages</div>\n        <div class="tab" :class="{active:tab82==2}" @click="tab82=2">Language strings</div>        \n    </div>\n\n      <template v-if="tab==\'configuration\'">\n\n        <div class="spacer"></div>\n\n        <div class="btns">\n        \n            <span class="btn" @click="gotoView(\'language\')"><ic>language</ic> {{str(\'languages\')}}</span>\n            <span class="btn" @click="gotoView(\'settings-assets\')"><ic>perm_media</ic> {{str(\'assets\')}}</span>\n            <span class="btn" v-if="0" @click="gotoView(\'code-editor\')"><ic>pie_chart_outline</ic> {{str(\'schemas\')}}</span>\n            <span class="btn" v-if="0" @click="gotoView(\'strings\')"><ic>edit_note</ic> Strings</span>\n            <span class="btn" @click="toggleDarkMode()">\n                <ic>{{darkMode ? \'light_mode\' : \'mode_night\'}}</ic>\n                {{darkMode ? str(\'light_mode\') : str(\'dark_mode\') }}\n            </span>\n\n        </div>\n\n        <div class="spacer" v-if="show_admin_language"></div>\n        <card v-if="show_admin_language">\n            <div class="spaced">\n\n                <div class="field" v-if="show_admin_language">\n                    <div class="label has-helper">Admin language<span class="helpicon" @click="msg(\'In which language would you like the CMS to appear? This does not affect the language your content is written in.\')">?</span></div>    \n                    <select :value="$store.state.admin_language" @change="saveAdminLanguage()" ref="admin_language_select">\n                        <option v-for="(code,ci) in langstringcodes" :value="code" :key="\'k2bj2\'+ci">{{code.toUpperCase()}}</option>\n                    </select>\n                </div>\n                \n                <div class="field" v-if="0">\n                    <div class="label">{{str(\'admin_look\')}}</div>\n                    <select>\n                        <option>{{str(\'light_mode\')}}</option>\n                        <option>{{str(\'dark_mode\')}}</option>\n                    </select>\n                </div>                   \n            \n            </div>\n        </card>\n\n        <div class="spacer"></div>\n        \n        <card title="Map elements" icon="settings">\n            <div class="spaced">\n                \n                <div class="field" v-if="cms_config">\n                    <div class="label has-helper">Mapbox API token<span class="helpicon" @click="msg(\'If you are using map fields in your CMS, please register a free Mapbox API token and type it in here.\')">?</span></div>\n                    <input type="text" :value="cms_config.mapbox_api_token" @change="saveMapboxApiToken($event)">\n                </div>\n\n            </div>\n        </card>\n\n        <div class="spacer"></div>\n        \n        <card title="Webhooks" icon="settings">\n            <div class="spaced">\n\n                <div class="field" v-if="cms_config">\n                    <div class="label has-helper">Manual publish<span class="helpicon" @click="msg(\'If this webhook URL is defined, a publish button will appear in the menu. When clicked, the URL will be called.\')">?</span></div>\n                    <input type="text" :value="cms_config.webhook_url_manual_publish" @change="save_webhook_url(\'manual_publish\', $event)" placeholder="https://">\n                </div>\n                \n                <div class="field" v-if="cms_config">\n                    <div class="label has-helper">Item saved<span class="helpicon" @click="msg(\'If this webhook URL is defined, it will be called automatically whenever an item is saved, along with the item data.\')">?</span></div>    \n                    <input type="text" :value="cms_config.webhook_url_auto_on_item_saved" @change="save_webhook_url(\'auto_on_item_saved\', $event)" placeholder="https://">\n                </div>\n\n                <div class="field" v-if="cms_config">\n                <div class="label has-helper">Item deleted<span class="helpicon" @click="msg(\'If this webhook URL is defined, it will be called automatically whenever an item is deleted, along with the item data.\')">?</span></div>    \n                    <input type="text" :value="cms_config.webhook_url_auto_on_item_deleted" @change="save_webhook_url(\'auto_on_item_deleted\', $event)" placeholder="https://">\n                </div>\n\n            </div>\n        </card>           \n\n        <div class="spacer"></div>\n        \n        \n        <card title="HTML Cache" icon="settings">\n\n            <div class="field" v-if="cms_config">\n                <div class="label">HTML Cache</div>\n                <select :value="cms_config.html_cache_enabled" @change="saveHTMLCacheEnabled($event)">\n                    <option value="" disabled>{{str(\'select\')}}</option>\n                    <option value="off">{{str(\'inactive\')}}</option>\n                    <option value="on">{{str(\'active\')}}</option>\n                </select>\n            </div>\n\n            <div class="spacer"></div>\n\n            <span class="btn v2" @click="htmlCacheWipeAll()">\n                <ic>cleaning_services</ic>\n                {{str(\'clear\')}}\n            </span>\n                \n        </card>\n\n        <template v-if="0">\n            <div class="spacer"></div>\n            <card title="Commercial license" icon="settings">\n                <div class="spaced">\n                    \n                    <div class="field" v-if="cms_config">\n                        <div class="label has-helper">Commercial license key<span class="helpicon" @click="msg(\'If you have a license key please add it here. If you think you might require a license please visit https://klay.dev\')">?</span></div>\n                        <input type="password" :value="cms_config.commercial_license_key" @change="saveCommercialLicenseKey($event)">\n                    </div>\n\n                </div>\n            </card>\n        </template>\n      \n      </template>\n      \n      \n      \n      <view-backups v-if="tab==\'backup\'" />\n\n      <card v-if="tab==\'about\'" title="Klay CMS" icon="info">\n         <table class="table1">\n            <tr>\n               <td>Version</td>\n               <td>{{$store.state.version}}\n            </tr>\n            <tr>\n               <td>Build</td>\n               <td>{{$store.state.buildno}}</td>\n            </tr>\n            <tr>\n               <td>Build date</td>\n               <td>2024-10-30</td>\n            </tr>\n            <tr>\n               <td>PHP Version</td>\n               <td>{{$store.state.php_version}}</td>\n            </tr>\n            <tr v-if="$store.state.php_extensions">\n               <td>PHP Extensions</td>\n               <td>{{$store.state.php_extensions.join(\', \')}}</td>\n            </tr>\n            <tr>\n               <td>{{str(\'license\')}}</td>\n               <td>Proprietary software protected under copyright (Request license fee using below contact info.)</td>\n            </tr>\n            <tr>\n               <td>Author</td>\n               <td>Read more at <a href="https://klay.dev">klay.dev</a></td>\n            </tr>            \n            <tr>\n               <td>Logged in user</td>\n               <td>{{($store.state.logged_in_user && $store.state.logged_in_user.username) ? $store.state.logged_in_user.username : \'Unknown\' }}</td>\n            </tr>            \n            <tr>\n               <td>Permissions</td>\n               <td v-if="!permissions">None defined</td>\n               <td v-if="permissions">\n                  <div v-for="(p,pi) in permissions" :key="\'1e2e2f\'+pi"><ic>{{p.includes(\'!\') ? \'check_box_outline_blank\' : \'check_box\'}}</ic> {{p.replace(\'!\',\'\')}}</div>\n               </td>\n            </tr>            \n         </table>\n      </card>\n\n\n   \n      <seeder v-if="tab==\'seeding\'" />\n     \n      <trash v-if="tab==\'trash\'" />\n\n\n      <template v-if="tab==\'logout\'">\n         <div class="spacer"></div>\n         <span class="btn" @click="logout()">\n            <ic>logout</ic>\n            Log out\n         </span>\n         <div class="spacer"></div>\n      </template>\n\n   </div>',mixins:[mixins.basic],data:function(){return{tab:"configuration",tab82:1}},computed:{langstringcodes:function(){var e=this.$store.state.langstrings;return _toConsumableArray(new Set(Object.values(e).flatMap(Object.keys)))},show_admin_language:function(){return"en"!==this.admin_language||1<this.langstringcodes.length}},methods:{saveMapboxApiToken:function(e){var t=e.target.value;this.saveConfigItem("mapbox_api_token",t)},saveCommercialLicenseKey:function(e){var t=e.target.value;this.saveConfigItem("commercial_license_key",t)},saveHTMLCacheEnabled:function(e){var t=e.target.value;"on"!==t&&(t="off"),this.saveConfigItem("html_cache_enabled",t)},saveConfigItem:function(e,t){var i=this,n=deepClone(this.cms_config);return(n=n||{})[e]=t,this.spinner({active:!0,blocking:!0}),this.api_post("save_cms_config",{cms_config:n}).done(function(e){i.toast({text:i.str("saved"),icon:"check_circle"}),i.fetch_cms_config(),i.spinner({active:!1,blocking:!1})}).fail(function(e){i.toast({text:i.str("could_not_save"),icon:"warning",type:"error"}),i.spinner({active:!1,blocking:!1})})},saveAdminLanguage:function(){var e=this.$refs.admin_language_select.value;this.$store.commit("set_admin_language",e),localStorage.setItem("admin_language",e),this.toast({text:this.str("admin_language_changed")})},htmlCacheWipeAll:function(){var t=this;if(confirm(this.str("sure")))return this.spinner({active:!0,blocking:!0}),this.api_post("html_cache_wipe_all",{}).done(function(e){t.toast({text:t.str("done"),icon:"check_circle"}),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("error"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})},save_webhook_url:function(e,t){var i=this,n="webhook_url_"+e,s=t.target.value,a=deepClone(this.cms_config);return(a=a||{})[n]=s,this.spinner({active:!0,blocking:!0}),this.api_post("save_cms_config",{cms_config:a}).done(function(e){i.toast({text:i.str("saved"),icon:"check_circle"}),i.fetch_cms_config(),i.spinner({active:!1,blocking:!1})}).fail(function(e){i.toast({text:i.str("could_not_save"),icon:"warning",type:"error"}),i.spinner({active:!1,blocking:!1})})}},created:function(){}}),Vue.component("view-dev",{template:'<div class="view view-dev">\n      \n      <card v-if="0" title="Dev: user"><pre>{{user}}</pre></card>\n      <card v-if="1" cls="color2" title="Dev: fetched_content"><pre>{{fetched_content}}</pre></card>\n      <card v-if="1" cls="color2" title="Dev: cms_config"><pre>{{cms_config}}</pre></card>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{}},computed:{},watch:{},methods:{strip:function(e){return deepClone(e)}},mounted:function(){console.log({state:this.strip(this.$store.state),getters:this.strip(this.$store.getters)})}}),Vue.component("view-login",{template:'<div class="view-login">\n      \n      <div class="loginbox" v-if="logged_in">\n        <p class="align-c">You are already logged in.</p>\n        <div class="spaced">\n            <div class="btn" @click="gotoView(\'home\')">Home</div>\n            <div class="btn" @click="logout()">Log out</div>\n        </div>\n      </div>\n\n      <div class="loginbox" v-if="!logged_in">\n         <div class="spaced">\n         \n            <logo v-if="!show_forgot_msg"></logo>\n\n            <template v-if="!show_forgot_msg">\n\n               <div class="field">\n                  <div class="label" for="id922">Username</div>\n                  <input class="styled" type="text" id="id922" name="u92728" ref="login_u" value="" placeholder="Username" autofocus />\n               </div>\n               <div class="field">\n                  <div class="label" for="id823">Password</div>\n                  <input class="styled" type="password" id="id823" name="p92729" ref="login_p" value="" placeholder="Password" />\n               </div>\n               \n               <div class="loginbtns">\n                <div class="btn" @click="show_forgot_msg=true">Forgot?</div>\n                <input type="submit" class="btn v2" value="Log in" @click="login()" />\n               </div>\n\n               <div class="hint" v-if="login_hint && login_attempts_count > 0">Hint: {{login_hint}}</div>\n\n            </template>\n            \n            <div class="forgot-msg" v-if="show_forgot_msg">\n               <div class="spaced">\n                  <div>Login can be discovered or reset only by logging onto the server and seeing its definition there. If you are unsure how to do this, please contact your tech support.</div>\n                  <div class="btn --s" @click="show_forgot_msg=false">Back</div>\n               </div>\n            </div>\n\n         </div>\n      </div>\n     \n\n   </div>',mixins:[mixins.basic],data:function(){return{show_forgot_msg:!1,login_attempts_count:0,login_hint:void 0}},computed:{},methods:{buzz:function(){$(".loginbox").addClass("error"),setTimeout(function(){$(".loginbox").removeClass("error")},500)},login:function(){var t=this;if(!this.$refs.login_u.value||!this.$refs.login_p.value)return this.buzz(),!1;this.spinner({active:!0,blocking:!0}),this.api_post("login",{u:this.$refs.login_u.value,p:this.$refs.login_p.value}).done(function(e){t.user={token:e.token},t.$store.commit("set_user_token",e.token),t.toast({text:"Welcome back",icon:"check_circle"}),t.on_logged_in(),t.gotoView("home")}).fail(function(e){t.login_hint=null,e.responseJSON.hint&&(t.login_hint=e.responseJSON.hint),t.toast({text:"Login failed",icon:"warning",type:"error"}),t.buzz(),t.login_attempts_count++}).always(function(){t.spinner({active:!1,blocking:!1})})},forgot:function(){this.show_forgot_msg=!0},onKeyDown:function(e){if("Enter"===e.key)return e.preventDefault(),this.login(),!1}},created:function(){window.addEventListener("keydown",this.onKeyDown)},destroyed:function(){window.removeEventListener("keydown",this.onKeyDown)}}),Vue.component("view-settings-assets",{template:'<div v-if="cms_config">\n\n        <div class="btns">\n            <span class="btn" @click="gotoView(\'settings\')"><ic>arrow_back</ic> {{str(\'back_to_settings\')}}</span>\n        </div>\n        <br>\n\n\n        <div class="grid-11">\n\n            <card title="Resized image versions" icon="perm_media">\n                Uploaded images are auto-resized to the following max-width versions:<br><br>\n                {{asset_img_sizes.join(\', \')}}px\n            </card>\n            \n            <card title="Missing image versions" icon="perm_media">\n\n                <table class="table1" v-if="stats">\n                    <tr>\n                        <td>Missing image versions</td>\n                        <td>{{stats.asset_resizables_missing.length}} found</td>\n                    </tr>\n                    <tr>\n                        <td>Surplus image versions</td>\n                        <td>{{stats.asset_resizables_surplus.length}} found</td>\n                    </tr>                \n                </table>\n\n                <br>\n\n                <div class="spaced">\n                    <div class="btn" @click="create_missing">Generate missing images versions (1 run)...</div>\n                    <div class="btn" @click="start_create_missing_continually()">Generate missing images versions (continually until done)...</div>\n                    <div class="btn" @click="delete_surplus">Delete surplus image versions...</div>\n                </div>\n            </card>\n\n        </div>\n\n   </div>',mixins:[mixins.basic],data:function(){return{stats:void 0,create_missing_continually:!1}},computed:{phpdata:function(){return this.$store.state.phpdata},asset_img_sizes:function(){if(this.phpdata)return this.phpdata.asset_img_sizes}},methods:{fetch_stats:function(){var t=this;return $.get(this.base_url,{api_endpoint:"fetch_stats"}).done(function(e){t.stats=e.stats}).fail(function(){})},delete_surplus:function(){var i=this;if(confirm(this.str("sure")))return this.spinner({active:!0,blocking:!0}),$.post(this.base_url,{api_endpoint:"delete_asset_resizables_surplus"}).done(function(e){var t=e.deleted+" files deleted";i.toast({text:t,icon:"check_circle",position:"bottom-right"}),i.fetch_stats()}).fail(function(){i.toast({text:i.str("error_try_again"),icon:"warning",type:"error"})}).always(function(){i.spinner({active:!1})})},create_missing:function(){var n=this;return this.spinner({active:!0,blocking:!0}),$.post(this.base_url,{api_endpoint:"create_missing_asset_resizables"}).done(function(e){var t=e.all_uids.length-e.run_uids.length;t<0&&(t=0);var i=e.run_uids.length+" handled, "+t+" remaining";n.toast({text:i,icon:"check_circle",position:"bottom-right"}),n.fetch_stats(),n.create_missing_continually&&!t&&n.toast({text:"All done",icon:"check_circle",position:"bottom-right"}),n.create_missing_continually&&t&&setTimeout(function(){n.create_missing()},2e3)}).fail(function(){n.toast({text:n.str("error_try_again"),icon:"warning",type:"error"})}).always(function(){n.spinner({active:!1})})},start_create_missing_continually:function(){this.create_missing_continually=!0,this.create_missing()}},created:function(){this.fetch_stats()}}),Vue.component("view-code-editor",{template:'<div class="view view-code-editor">\n\n        <loading type="spinner" v-if="!cms_config" />\n\n        <template v-if="cms_config">\n            \n            <div class="btns">\n                <span class="btn" @click="gotoView(\'settings\')"><ic>arrow_back</ic> {{str(\'back_to_settings\')}}</span>\n            </div>\n            <br>\n\n            <div class="tabs" v-if="1">\n                <div class="tab" :class="{active:tab===\'item_schemas\'}" @click="tab=\'item_schemas\'"><ic>description</ic> {{str(\'item_schemas\')}}</div>\n                <div class="tab" :class="{active:tab===\'block_schemas\'}" @click="tab=\'block_schemas\'"><ic>description</ic> {{str(\'block_schemas\')}}</div>\n                <div class="tab" :class="{active:tab===\'block_preview_css\'}" @click="tab=\'block_preview_css\'"><ic>description</ic> {{str(\'block_preview_css\')}}</div>\n                <div class="tab" :class="{active:tab===\'block_preview_js\'}" @click="tab=\'block_preview_js\'"><ic>description</ic> {{str(\'block_preview_js\')}}</div>\n            </div>\n\n            <code-editor v-if="tab==\'item_schemas\'" :code="files.item_schemas.code" :format="files.item_schemas.format" key="1" @updated="on_updated(\'item_schemas\',$event)"></code-editor>\n            <code-editor v-if="tab==\'block_schemas\'" :code="files.block_schemas.code" :format="files.block_schemas.format" key="2" @updated="on_updated(\'block_schemas\',$event)"></code-editor>\n            <code-editor v-if="tab==\'block_preview_css\'" :code="files.block_preview_css.code" :format="files.block_preview_css.format" key="3" @updated="on_updated(\'block_preview_css\',$event)"></code-editor>\n            <code-editor v-if="tab==\'block_preview_js\'" :code="files.block_preview_js.code" :format="files.block_preview_js.format" key="4" @updated="on_updated(\'block_preview_js\',$event)"></code-editor>\n\n            <br>\n\n            <div v-if="tab==\'item_schemas\' && $store.getters.item_schemas_only_from_php">\n                <em>Notice:</em> {{$store.getters.item_schemas_only_from_php.length}} item schemas were defined in PHP. If you want to edit or remove these, remove them from the PHP file in which they are defined. This cannot be done from the admin panel.\n            </div>\n            \n            <div v-if="tab==\'block_schemas\' && $store.getters.block_schemas_only_from_php">\n                <em>Notice:</em> {{$store.getters.block_schemas_only_from_php.length}} block schemas were defined in PHP. If you want to edit or remove these, remove them from the PHP file in which they are defined. This cannot be done from the admin panel.\n            </div>\n\n            <br>\n        \n            <div class="btn" @click="save()"><ic>save</ic> {{str(\'save\')}}</div>\n\n        </template>\n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{tab:"item_schemas",files:{item_schemas:{code:void 0,format:"json",valid:void 0,updated:!1},block_schemas:{code:void 0,format:"json",valid:void 0,updated:!1},block_preview_css:{code:void 0,format:"css",valid:void 0,updated:!1},block_preview_js:{code:void 0,format:"js",valid:void 0,updated:!1}}}},computed:{},methods:{on_updated:function(e,t){this.files[e].code=t.value,this.files[e].valid=t.valid,this.files[e].updated=!0},cleanse_newlines_and_tags:function(e){return e&&e.replace?e.replace(/\n|\t|\r|\\/gm,"").replace(/\\/g,"/"):e},save:function(){var t=this;if(!1===this.files.item_schemas.valid)return alert("invalid item schemas, fix that");if(!1===this.files.block_schemas.valid)return alert("invalid block schemas, fix that");var e=(e=deepClone(this.cms_config))||{};return this.files.item_schemas.updated&&(e.item_schemas=JSON.parse(this.cleanse_newlines_and_tags(this.files.item_schemas.code))),this.files.block_schemas.updated&&(e.block_schemas=JSON.parse(this.cleanse_newlines_and_tags(this.files.block_schemas.code))),this.files.block_preview_css.updated&&(e.block_preview_css=this.files.block_preview_css.code),this.files.block_preview_js.updated&&(e.block_preview_js=this.files.block_preview_js.code),this.spinner({active:!0,blocking:!0}),this.api_post("save_cms_config",{cms_config:e}).done(function(e){t.toast({text:t.str("saved"),icon:"check_circle"}),t.fetch_cms_config(),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("could_not_save"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})}},created:function(){this.files.item_schemas.code=JSON.stringify(this.$store.getters.item_schemas_only_from_db,null,2),this.files.block_schemas.code=JSON.stringify(this.$store.getters.block_schemas_only_from_db,null,2)},mounted:function(){}}),Vue.component("view-backups",{template:'<div class="view view-backups">\n      \n      <div class="grid-11">\n\n         <card title="Data usage" icon="pie_chart_outline">\n            <loading type="spinner" v-if="!stats" />\n            <table class="stats-table" v-if="stats">\n               <tr>\n                  <td><ic>description</ic> &nbsp; Content data</td>\n                  <td class="align-r">{{formatBytes(stats.db_bytes)}}</td>\n               </tr>\n               <tr>\n                  <td><ic>inventory_2</ic> &nbsp; Asset files</td>\n                  <td class="align-r">{{formatBytes(stats.asset_files_bytes)}}</td>\n               </tr>\n               <tr>\n                  <td><ic>cloud_done</ic> &nbsp; Backup files</td>\n                  <td class="align-r">{{formatBytes(stats.backup_files_bytes)}}</td>\n               </tr>\n               <tr>\n                  <td><ic>cached</ic> &nbsp; Cache files</td>\n                  <td class="align-r">{{formatBytes(stats.cache_files_bytes)}}</td>\n               </tr>\n            </table>\n         </card>\n\n         <card title="Backup files on server" icon="folder_zip">\n            <loading type="spinner" v-if="!backup_files" />\n            <table class="table1" v-if="backup_files">\n               <tr v-for="(x) in backup_files">\n                  <td>\n                     <a :href="x.url">{{x.filename}}</a>\n                  </td>\n                  <td class="align-r">\n                    {{formatBytes(x.bytes)}}\n                  </td>\n                  <td class="align-r">\n                    <span class="txtlink backup-delete-btn" @click="deleteBackup(x.filename)"><ic>delete</ic></span>\n                  </td>\n               </tr>\n               <tr v-if="!backup_files.length">\n                  <td colspan="3">No backups found.</td>\n               </tr>               \n            </table>\n         </card>\n         \n      </div>\n\n      <div class="spacer"></div>\n\n      <card title="New backup" icon="folder_zip" v-if="stats">\n\n         <div class="spaced">\n\n            <div class="field">\n               <div class="label">Backup scope</div>\n               <select v-model="create_backup_scope">\n                  <option value="no_asset_files">Content without asset files</option>\n                  <option value="with_asset_files">Content and asset files</option>\n               </select>\n            </div>\n\n            <div v-if="estimated_backup_size">Estimated size: <b>{{formatBytes(estimated_backup_size)}}</b></div>\n\n         </div>\n\n         <div class="spacer"></div>\n\n         <div class="btn v2" @click="createNewBackup()">{{str(\'create_backup\')}}</div>\n\n      </card>      \n\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{stats:void 0,backup_files:void 0,create_backup_scope:"no_asset_files"}},computed:{estimated_backup_size:function(){if(this.stats){var e=0;return e+=+this.stats.json_files_bytes,"with_asset_files"==this.create_backup_scope&&(e+=+this.stats.asset_files_bytes),e}}},watch:{},methods:{fetch_stats:function(){var t=this;return $.get(this.base_url,{api_endpoint:"fetch_stats"}).done(function(e){t.stats=e.stats}).fail(function(){})},fetch_backup_files:function(){var t=this;return $.get(this.base_url,{api_endpoint:"fetch_backup_files"}).done(function(e){t.backup_files=e.files}).fail(function(){})},createNewBackup:function(){var t=this;return this.spinner({active:!0,blocking:!0}),$.get(this.base_url,{api_endpoint:"create_backup",scope:this.create_backup_scope}).done(function(e){t.toast({text:"Backup created",icon:"check_circle"}),t.backup_files=void 0,t.stats=void 0,t.fetch_backup_files(),t.fetch_stats()}).fail(function(){}).always(function(){t.spinner({active:!1,blocking:!1})})},deleteBackup:function(e){var t=this;return this.spinner({active:!0,blocking:!0}),$.get(this.base_url,{api_endpoint:"delete_backup",filename:e}).done(function(e){t.toast({text:"Backup deleted",icon:"check_circle"}),t.backup_files=void 0,t.stats=void 0,t.fetch_backup_files(),t.fetch_stats()}).fail(function(){}).always(function(){t.spinner({active:!1,blocking:!1})})}},mounted:function(){this.fetch_stats(),this.fetch_backup_files()}}),Vue.component("view-language",{template:'<div class="view-language">\n\n        <div class="btns">\n            <span class="btn" @click="gotoView(\'settings\')"><ic>arrow_back</ic> {{str(\'back_to_settings\')}}</span>\n        </div>\n        <br>\n            \n        <card :title="str(\'language_settings\')" icon="language">\n            <languages></languages>\n         </card>\n\n    </div>',mixins:[mixins.basic],props:{},methods:{},created:function(){}}),Vue.component("view-strings",{template:'<div class="view-strings">\n        \n        <div class="btns">\n            <span class="btn" @click="gotoView(\'settings\')"><ic>arrow_back</ic> {{str(\'back_to_settings\')}}</span>\n        </div>\n        <br>\n        \n        <table class="table1">\n            <thead>\n                <tr>\n                    <th>String</th>\n                    <th v-for="(lang) in languages">{{lang.name}}</th>\n                </tr>\n            </thead>\n            <tr v-for="(string,string_key) in strings_local">\n                <td>{{string_key}}</td>\n                <td v-for="(lang) in languages">\n                    <input type="text" v-model="string[lang.code]" placeholder="Primary lang string here?" />\n                </td>\n            </tr>\n        </table>\n\n        <div class="spacer"></div>\n\n        <span class="btn" @click="save()"><ic>save</ic> {{str(\'save\')}}</span>           \n\n    </div>',mixins:[mixins.basic],props:{},data:function(){return{strings_local:void 0}},methods:{save:function(){var t=this,e=deepMerge(deepClone(this.cms_config),deepClone({strings:this.strings_local}));return this.spinner({active:!0,blocking:!0}),this.api_post("save_cms_config",{cms_config:e}).done(function(e){t.toast({text:t.str("saved"),icon:"check_circle"}),t.fetch_cms_config(),t.spinner({active:!1,blocking:!1})}).fail(function(e){t.toast({text:t.str("could_not_save"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})},set_local_strings:function(){var e=(e=deepClone(this.strings))||{};for(var t in e){var i,n=_createForOfIteratorHelper(this.languages);try{for(n.s();!(i=n.n()).done;){var s=i.value;e[t]||(e[t]={}),e[t][s.code]||(e[t][s.code]="")}}catch(e){n.e(e)}finally{n.f()}}this.$set(this,"strings_local",e)}},watch:{strings:function(){this.set_local_strings()}},created:function(){this.set_local_strings()}}),Vue.component("view-custom",{template:'<div class="view-custom" v-html="html"></div>',data:function(){return{onExit:!1}},computed:{html:function(){var e,t=null===(e=this.$store.getters.url_params)||void 0===e?void 0:e.html;if(t)return"string"==typeof t?t:t()}},methods:{},watch:{},mounted:function(){var e,i=this;this.$nextTick(function(){var e,t=null===(e=i.$store.getters.url_params)||void 0===e?void 0:e.enter;t&&t()}),this.onExit=null===(e=this.$store.getters.url_params)||void 0===e?void 0:e.exit},beforeDestroy:function(){this.onExit&&this.onExit()}}),Vue.component("modal-cloner",{template:'<div class="modal modal-cloner">    \n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup">\n        <div class="inner">\n\n            <div class="spaced">\n                <div class="field">\n                    <div class="label">Ny titel</div>\n                    <input type="text" v-model="new_title" />\n                </div>\n            </div>\n\n            <span class="btn look1" @click="submitClone()">\n                {{str(\'save\')}}\n            </span>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{new_title:void 0}},computed:{modal:function(){return this.$store.state.modal_cloner},original_item:function(){return this.modal.original_item}},methods:{close:function(){this.$store.commit("set_modal_cloner",{active:!1})},submitClone:function(){var e={original_item_uid:this.original_item.uid,new_title:this.new_title};console.log(e),alert("toto")}},mounted:function(){this.original_item&&this.original_item.title&&(this.new_title=this.original_item.title+("da"==this.admin_language?" (Kopi)":" (Copy)"))}}),Vue.component("modal-asset",{template:'<div class="modal modal-asset">\n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup">\n        <div class="inner" v-if="!asset">\n            ...\n        </div>\n        <div class="inner" v-if="asset">\n\n            <div class="grid-11">\n                \n                <asset-preview v-if="is_img||is_video" :asset="asset" :key="asset.updated_at"></asset-preview>\n                <asset-preview v-if="!is_img&&!is_video" :asset="asset" :key="asset.updated_at"></asset-preview>\n\n                <div>\n\n                    <div class="tabs">\n                        <div class="tab" :class="{active:tab===1}" @click="tab=1">Info</div>\n                        <div class="tab" :class="{active:tab===3}" @click="tab=3">{{str(\'more\')}}</div>\n                        <div class="tab" :class="{active:tab===5}" @click="tab=5">{{str(\'replace\')}}</div>\n                        <div class="tab" :class="{active:tab===4}" v-if="has_custom_fields_schema" @click="tab=4">{{str(\'fields\')}}</div>\n                        <div class="tab" v-if="0" :class="{active:tab===6}" @click="tab=6">Modify</div>\n                    </div>\n\n                    <template v-if="tab===1">\n                        <div class="spaced">\n                            <div class="field" v-if="1">\n                                <div class="label">{{str(\'filename\')}} (.{{asset.format}})</div>\n                                <input type="text" :value="(asset.title)" v-once @change="onTitleUpdated($event)" :key="\'title\'+asset.uid">                                \n                            </div>\n                            <div class="field">\n                                <div class="label has-helper">{{str(\'tags\')}}<span class="helpicon" @click="tags_helper_click()">?</span></div>\n                                <input type="text" v-if="0" :value="(asset.tags)" v-once @change="setUpdatedValue($event,\'tags\')" :key="\'tags\'+asset.uid">\n                                <tagfield :tags="asset.tags" @updated="onTagsFieldUpdated($event)">\n                            </div>\n                        </div>                        \n                        <div class="spacer"></div>\n                        <div class="btns">\n                            <a class="btn --s" v-for="(file) in asset.files" :href="file" target="_blank">{{show_file_url(file,asset)}}</a>\n                        </div>\n                    </template>\n                \n                    <template v-if="tab===3">\n                        <div class="field" v-if="0 && !is_multilingual">\n                            <div class="label">{{str(\'description\')}}</div>\n                            <input type="text" :value="(asset.img_alt)" v-once @change="setUpdatedValue($event,\'img_alt\')" :key="\'img_alt\'+asset.uid">\n                        </div>\n                        <div v-if="is_multilingual" class="spaced">\n                            <div class="field" v-for="(lang, lang_i) in this.$store.getters.languages">\n                                <div class="label">{{str(\'description\')}} ({{get_language_name(lang.code)}})</div>\n                                <input type="text" :value="(asset[\'img_alt_\'+lang.code])" @change="setUpdatedValue($event,\'img_alt_\'+lang.code)" :key="\'img_alt\'+lang.code+\'_\'+asset.uid">\n                            </div>\n                        </div>\n                        <div class="spacer"></div>\n                        <div v-if="asset.dominant_color">{{str(\'dominant_color\')}}: <span :style="dominant_preview_css"></span> {{asset.dominant_color}}</div>\n                        <div class="spacer"></div>\n                        <div v-if="asset.filesize">\n                            {{str(\'file_size\')}}: {{formatBytes(asset.filesize)}} <span v-if="asset.size && asset.size.w">({{asset.size.w}}x{{asset.size.h}}px)</span>\n                        </div>                        \n                    </template>\n\n                    \n                    \n                    <template v-if="has_custom_fields_schema && tab===4">\n                        <item-fields \n                            :fields="cms_config.asset_custom_fields_schema"\n                            :data="asset.fields"\n                            @updated="setUnsavedChangesKeyValueFromFieldComponentEvent"\n                        ></item-fields>                    \n                    </template>\n\n                    <div v-if="tab===5">\n                        <div class="spacer"></div>\n                        <input type="file" v-if="!replace_with_file" ref="replaceFileInput" @change="onReplaceFileInputChanged()">\n                        <template v-if="replace_with_file">\n                            <div>\n                                {{str(\'press_save_to_replace_with\')}}: {{replace_with_file.name}}\n                            </div>\n                            <div v-if="0" class="btn" @click="replaceFile()">{{str(\'replace\')}}</div>\n                        </template>\n                        <div class="spacer"></div>\n                    </div>\n\n\n                    <template v-if="tab===6">\n                        <img-editor :asset="asset" />\n                    </template>\n\n                    <pre v-if="0">{{asset}}</pre>\n\n                    <div class="spacer"></div>\n                    <div class="align-l">\n                        <div class="btns">\n                            <div class="btn v2" :class="{disabled:!saveReady}" @click="updateItem()">{{str(\'save\')}}</div>                \n                            <div class="btn" @click="deleteItem()">{{sure ? str(\'sure\') : str(\'delete\')}}</div>\n                        </div>\n                    </div>\n\n                </div>\n            </div>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{asset:void 0,updatedItem:void 0,sure:!1,replace_with_file:!1,tab:1}},computed:{uid:function(){return this.$store.state.modal_asset.asset.uid},dominant_preview_css:function(){if(this.asset&&this.asset.dominant_color)return{display:"inline-block",height:"1em",width:"1em",backgroundColor:this.asset.dominant_color}},is_img:function(){return this.asset&&this.asset_is_img(this.asset)},is_video:function(){return this.asset&&this.asset_is_video(this.asset)},is_other_format:function(){return this.asset&&!this.is_img&&!this.is_video},custom_fields:function(){return this.cms_config.asset_custom_fields_schema},has_custom_fields_schema:function(){return this.custom_fields&&this.custom_fields.length},saveReady:function(){return this.updatedItem&&this.updatedItem.uid||this.replace_with_file},tags_tooltip:function(){var e=this.str("item_tags");for(var t in this.item_schemas){var i=this.item_schemas[t];"asset"===i.name&&i.tags_tooltip&&(e+="\r\n"+i.tags_tooltip)}return e}},methods:{close:function(){if(this.updatedItem&&!confirm("Cancel unsaved changes?"))return!1;this.$store.commit("set_modal_asset_active",!1),this.$store.commit("set_modal_asset",void 0)},show_file_url:function(e,t){return e.replace(this.base_url+"/","").replace("content/asset/","").replace(t.uid+"/","")},onTitleUpdated:function(e){var t=e.target;t.value=slugify(t.value);t.value;this.setUpdatedValue(e,"title")},setUpdatedValue:function(e,t){var i=e.target,n=i.value;this.el_is_checkbox(i)&&(n=i.checked),this.updatedItem||this.$set(this,"updatedItem",deepClone(this.asset)),this.$set(this.updatedItem,t,n)},setUnsavedChangesKeyValueFromFieldComponentEvent:function(e){this.updatedItem||this.$set(this,"updatedItem",deepClone(this.asset)),this.$set(this.updatedItem,"fields",e.localdata)},onTagsFieldUpdated:function(e){this.updatedItem||this.$set(this,"updatedItem",deepClone(this.asset)),this.$set(this.updatedItem,"tags",e.value)},onReplaceFileInputChanged:function(){this.replace_with_file=this.$refs.replaceFileInput.files[0]},clearUpdatedItem:function(){this.$set(this,"updatedItem",void 0)},updateReplacedItem:function(){var e=this;this.uploadFile({file:this.replace_with_file,asset:deepClone(this.updatedItem),onSuccess:function(){e.replace_with_file=void 0,e.updateItem()}})},updateItem:function(){var t=this;if(this.saveReady){var e=deepClone(this.updatedItem);this.replace_with_file&&!e&&(e=deepClone(this.asset));var i={type:"asset",item:e},n={};return this.replace_with_file&&(n.uploaded_file=this.replace_with_file),this.spinner({active:!0,blocking:!0}),console.log({save_item_data:i}),this.api_post_multipart("save_item",i,n).done(function(e){t.toast({text:t.str("item_updated"),icon:"check_circle"}),t.clearUpdatedItem(),t.spinner({active:!1,blocking:!1}),mitter.emit("assets-list-refresh"),mitter.emit("assets-tags-refresh"),t.close()}).fail(function(e){t.toast({text:t.str("could_not_update_item"),icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})})}},deleteItem:function(){var t=this;return!!confirm(this.str("sure"))&&(this.spinner({active:!0,blocking:!0}),this.api_post("delete_item",{type:"asset",uid:this.asset.uid}).done(function(e){t.close(),t.toast({text:"Item deleted",icon:"check_circle"}),t.fetch_content({type:"asset"}),t.spinner({active:!1,blocking:!1}),mitter.emit("assets-list-refresh"),mitter.emit("assets-tags-refresh")}).fail(function(e){t.toast({text:"Could not delete item",icon:"warning",type:"error"}),t.spinner({active:!1,blocking:!1})}))},replaceFile:function(){this.uploadFile({file:this.replace_with_file,asset:deepClone(this.asset)})},fetch:function(){var t=this;this.uid&&this.fetch_content({type:"asset",uid:this.uid}).then(function(e){t.asset=e.data}).catch(function(){alert("LOAD ERROR")}).always(function(){})},tags_helper_click:function(){var e=this.str("item_tags");for(var t in this.item_schemas){var i=this.item_schemas[t];"asset"===i.name&&i.tags_tooltip&&(e=i.tags_tooltip)}this.toast({icon:"info",text:e,position:"bottom-center"})}},mounted:function(){this.fetch()},created:function(){var t=this;$(document).bind("keydown.x8768",function(e){if((e.ctrlKey||e.metaKey)&&83==e.which)return e.preventDefault(),t.updateItem()(),!1}),this.setFiledropzoneEnabled(!1)},destroyed:function(){$(document).unbind("keydown.x8768"),this.setFiledropzoneEnabled(!0)}}),Vue.component("modal-assets",{template:'<div class="modal modal-assets">\n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup">\n        <div class="inner">\n          <assets></assets>\n        </div>\n      </div>\n    </div>',props:{asset:{type:Object,default:void 0}},mixins:[mixins.basic],data:function(){return{}},computed:{},methods:{close:function(){this.$store.commit("set_modal_assets_active",!1)}}}),Vue.component("modal-richtext",{template:'<div class="modal modal-richtext">\n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup">\n        <div class="inner">\n\n            <div class="richtext-container" :class="container_cls">\n                <div id="editor" v-html.once="value"></div>\n            </div>\n\n            <loading type="spinner" v-if="!editor" />\n        \n            <div class="btn v2" v-if="editor" @click="update()">Update</div>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{uid:void 0,editor:void 0,orig_value:void 0,last_clicked_el:void 0,focused:!0,modifiers:void 0}},computed:{value:function(){return this.$store.state.modal_richtext.value},container_cls:function(){if(!this.editor)return{hide:!0}}},methods:{hasUnsavedChanges:function(){return this.get_html()!==this.orig_value},close:function(){this.hasUnsavedChanges()&&!confirm(this.str("unsaved_changes"))||this.$store.commit("set_modal_richtext_active",!1)},modifiers_get_tinymce_style_formats:function(){for(var e=this.modifiers,t=[],i=0;i<e.length;i++){var n=e[i],s={title:n.label,classes:n.class,selector:n.tags};t.push(s)}return t},modifiers_get_combined_css:function(e){for(var t="",i=0;i<e.length;i++){var n=e[i];t+=" .".concat(n.class," { ").concat(n.preview_css," } ")}return t},modifier_is_visible:function(e){var t=this.editor.selection.getNode();if(t){var i=t.tagName.toLowerCase();return e.tags.includes(i)}},modifier_is_active:function(e){var t=this.editor.selection.getNode();if(t)return $(t).hasClass(e.class)},modifier_toggle:function(e){for(var t=this.modifiers,i=void 0,n=0;n<t.length;n++)t[n].uid===e&&(i=t[n]);if(i){var s=this.editor.selection.getNode();if(s){if(i.tags)if(!i.tags.split(",").includes(s.tagName.toLowerCase()))return console.log("tag not supported: "+s.tagName.toLowerCase()+" not in "+i.tags);if(i.group)for(var a=0;a<t.length;a++)t[a].group===i.group&&t[a].uid!==i.uid&&this.editor.dom.removeClass(s,t[a].class);s.classList.toggle(i.class),s.classList.length||s.removeAttribute("class"),this.editor.execCommand("InsertText",!1,"")}}},get_content_style:function(){var e=" .align-l { text-align:left; } .align-c { text-align:center; } .align-r { text-align:right; }.align-f { text-align:justify; } ";return e+=this.modifiers_get_combined_css(this.modifiers)},modifiers_setup_menubtn:function(e){var s=this,a=this.modifiers;a&&a.length&&e.ui.registry.addMenuButton("modifiersbtn",{icon:"sharpen",fetch:function(e){for(var n=[],t=0;t<a.length;t++)(function(e){var t=a[e];if(!s.modifier_is_visible(t))return;var i=s.modifier_is_active(t);n.push({type:"menuitem",icon:i?"selected":"unselected",text:t.label,onAction:function(){return s.modifier_toggle(t.uid)}})})(t);n.length||n.push({type:"menuitem",text:"No options for this element."}),e(n)}})},str_contains_html:function(e){var t=document.createElement("div");t.innerHTML=e;for(var i=t.childNodes,n=i.length;n--;)if(1==i[n].nodeType)return!0;return!1},strip_html:function(e){var t=document.createElement("DIV");return t.innerHTML=e,t.textContent||t.innerText||""},cleanup_html:function(e){return e=e.split(' class=""').join("")},cmd:function(e){this.editor.execCommand(e)},get_html:function(){return this.editor.getContent()},update:function(){var e=this.get_html();this.$store.commit("set_modal_richtext_active",!1),this.$store.state.modal_richtext.update_callback(e),this.$store.commit("set_modal_richtext_update_callback",void 0)},load_assets:function(){var e=this;if(window["editor_assets_loaded_"+this.uid])return this.init_editor();load_file(["https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/tinymce.min.js"]).then(function(){load_file(["https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/plugins/code/plugin.min.js","https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/plugins/link/plugin.min.js","https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/plugins/autolink/plugin.min.js","https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/plugins/lists/plugin.min.js","https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.1.2/plugins/quickbars/plugin.min.js"]).then(function(){window["editor_assets_loaded_"+e.uid]=!0,e.init_editor()})})},init_editor:function(){var t,s=this;window["editor_assets_loaded_"+this.uid]&&(t=this,tinymce.init({entity_encoding:"raw",plugins:["code","link","autolink","lists","quickbars"],selector:"#editor",convert_urls:!1,menubar:!1,menu:{edit:{title:"Edit",items:"undo redo | cut copy paste pastetext | selectall | searchreplace"},insert:{title:"Insert",items:"link unlink | hr"},format:{title:"Format",items:"styles | underline strikethrough superscript subscript | removeformat"}},toolbar:"blocks | _styles undo redo _h1 _h2 _h3 _custom1 bold italic link align custom3 modifiersbtn custom2",toolbar_mode:"floating",toolbar_groups:{custom1:{text:"H",_icon:"line",tooltip:"Formatting",items:"h4 h5 h6"},custom3:{icon:"unordered-list",tooltip:"Lists",items:"bullist numlist outdent indent"},custom2:{icon:"more-drawer",tooltip:"Formatting",items:"blockquote hr underline | strikethrough superscript subscript | unlink removeformat code"}},quickbars_selection_toolbar:"h1 h2 h3 bold italic link align",quickbars_insert_toolbar:!1,formats:{alignleft:{selector:"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li",classes:"align-l"},aligncenter:{selector:"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li",classes:"align-c"},alignright:{selector:"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li",classes:"align-r"},alignfull:{selector:"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li",classes:"align-f"}},style_formats:this.modifiers_get_tinymce_style_formats(),style_formats_old:[{title:"Bold text",inline:"b"},{title:"Red text",inline:"span",styles:{color:"#ff0000"}},{name:"my-inline",title:"My inline",inline:"span",classes:["my-inline"]},{name:"my1",title:"My_ 1",inline:"span",classes:["my1"]},{name:"my2",title:"My_ 2",classes:["my2"]},{name:"btn1",title:"Button 1",selector:"a",classes:"btn1"},{name:"btn2",title:"Button 2",selector:"a",classes:"btn2"},{name:"btn#",title:"Button 3",selector:"a",classes:"btn3"}],style_formats_autohide:!0,contextmenu:"link lists",content_style:this.get_content_style(),setup:function(e){t.editor=e,window.richtext=t.editor,window.comp=t,s.modifiers_setup_menubtn(e)},init_instance_callback:function(n){var t=s;$(".htmler").text(s.get_html()),n.on("ExecCommand",function(e){$(".htmler").text(s.get_html())}),n.on("keydown",function(e){return $(".htmler").text(s.get_html()),27==e.which?(e.preventDefault(),t.close(),!1):(e.ctrlKey||e.metaKey)&&83==e.which?(e.preventDefault(),t.update(),!1):void 0}),n.on("click",function(e){}),n.on("__paste",function(e){e.preventDefault();var t=((e.originalEvent||e).clipboardData||window.clipboardData).getData("Text"),i=s.str_contains_html(t);console.log({m:"USER PASTED CONTENT",content:t,contains_html:s.str_contains_html(t),stripped_html:s.strip_html(t)}),i||n.execCommand("mceInsertContent",!1,t),i&&klay.confirm({text:"HTML content detected. If the HTML is from an outside source, HTML may cause problems. Would you like to insert as safely as cleansed raw text or with the HTML as-is?",okText:"Raw text",onOkay:function(){n.execCommand("mceInsertContent",!1,s.strip_html(t))},cancelText:"HTML",onCancel:function(){n.execCommand("mceInsertContent",!1,t)}})})}}))},load_modifiers:function(){this.modifiers=[],klay.richtext_modifiers&&(this.modifiers=klay.richtext_modifiers);for(var e=0;e<this.modifiers.length;e++){this.modifiers[e].uid="uid"+parseInt(999999*Math.random())}}},created:function(){this.uid="uid"+rand(1111,9999),this.orig_value=this.value,this.load_modifiers(),this.load_assets()},mounted:function(){this.init_editor()},destroyed:function(){}}),Vue.component("modal-fields",{template:'<div class="modal modal-fields">\n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup" @click="popup_click()">\n        <div class="inner">\n        \n            <item-fields \n                v-if="fields"\n                :data="data" \n                :fields="fields"\n                @updated="on_field_updated($event)"\n            ></item-fields>\n\n            <pre v-if="0">fields:{{fields}}</pre>\n            <pre v-if="0">data:{{data}}</pre>\n\n            <div class="spacer"></div>\n\n            <div class="align-r">\n               <span class="btn v2" @click="update()">Update</span>\n            </div>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{data:void 0,fields:void 0,hasUnsavedChanges:!1}},computed:{value:function(){return this.$store.state.modal_fields.value}},methods:{close:function(){this.hasUnsavedChanges&&!confirm(this.str("unsaved_changes"))||this.$store.commit("set_modal_fields_active",!1)},on_field_updated:function(e){var t=deepClone(this.data);objectPath.set(t,e.path,e.value),this.$set(this,"data",t),this.hasUnsavedChanges=!0},update:function(){this.$store.commit("set_modal_fields_active",!1),this.$store.state.modal_fields.update_callback(deepClone(this.data)),this.$store.commit("set_modal_fields_update_callback",void 0),mitter.emit("repeater-row-slidables-refresh")},ondragstart:function(){alert("TODO: disable the file upload thing")},popup_click:function(){klay.set_any_open_modal_inside_viewport()}},created:function(){var t=this,i=this;$(document).bind("keydown.x882772",function(e){if(!i.$store.state.modal_richtext.active)return 27==e.which?(e.preventDefault(),t.close(),!1):void 0}),$(document).bind("keydown.x929287",function(e){if(!i.$store.state.modal_richtext.active)return(e.ctrlKey||e.metaKey)&&83==e.which?(e.preventDefault(),t.update(),!1):void 0})},mounted:function(){this.data=deepClone(this.$store.state.modal_fields.data),this.fields=deepClone(this.$store.state.modal_fields.fields),klay.set_any_open_modal_to_mouse_position_inside_viewport()},destroyed:function(){$(document).unbind("keydown.x882772"),$(document).unbind("keydown.x929287")}}),Vue.component("modal-addblock",{template:'<div class="modal modal-addblock">    \n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup" @click="popup_click()">\n        <div class="inner">\n\n            <input type="text" class="filterinput" ref="filterinput" placeholder="Search" v-model="filter_str" @keydown="filter_str_onchange" autofocus />\n            <div class="add-block-btns">\n                <div class="inner">\n                    <div class="add-block-btn" :class="cls_btn(blocktype,blocktype_i)" v-for="(blocktype,blocktype_i) in blocktypes_filtered" @click="select(blocktype)">\n                        {{block_title(blocktype.name)}}\n                    </div>\n                    <div v-if="!blocktypes_filtered">No blocks defined...</div>\n                </div>\n            </div>\n\n            <pre v-if="0">{{blocktypes}}</pre>\n            <pre v-if="0">{{field}}</pre>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{filter_str:"",active_btn_i:0}},computed:{field:function(){return this.$store.state.modal_addblock.field},blocktypes:function(){return this.$store.state.modal_addblock.blocktypes},blocktypes_active:function(){return this.blocktypes.filter(function(e){return!isFalse(e.active)})},blocktypes_filtered:function(){var s=this;if(this.blocktypes_active){if(!this.filter_str||!this.filter_str.length)return this.blocktypes_active;var a=this.filter_str.toLowerCase(),e=this.blocktypes_active.filter(function(e){var t=s.block_title(e.name),i=t&&t.includes(a),n=e.name.includes(a);return i||n});if(e&&e.length)return e}}},methods:{filter_str_onchange:function(){this.active_btn_i=0},select:function(e){this.$store.state.modal_addblock.onselected&&(this.$store.state.modal_addblock.onselected(e),this.close())},cls_btn:function(e,t){var i={};return t==this.active_btn_i&&(i.selected=!0),i},close:function(){this.$store.commit("set_modal_addblock_active",!1),this.$store.commit("set_modal_addblock_onselected",void 0),this.$store.commit("set_modal_addblock_blocktypes",void 0),this.$store.commit("set_modal_addblock_field",void 0)},popup_click:function(){klay.set_any_open_modal_inside_viewport()}},mounted:function(){var t=this;this.$refs.filterinput.focus(),klay.set_any_open_modal_to_mouse_position_inside_viewport(),$(document).bind("keydown.x92923",function(e){return 13!=e.which?38==e.which||40==e.which?(e.preventDefault(),!0):void 0:(e.preventDefault(),t.blocktypes_filtered?(t.select(t.blocktypes_filtered[t.active_btn_i]),!1):void 0)})},destroyed:function(){$(document).unbind("keydown.x92923")}}),Vue.component("modal-addtag",{template:'<div class="modal modal-addtag">    \n      <div class="dim" @click="close"></div>\n      <div class="popup" ref="popup">\n        <div class="inner">\n\n            <div class="field" v-if="existing_tags&&existing_tags.length">\n                <div class="label">{{str(\'select\')}}..</div>\n                <select ref="existing_tag" v-model="existing_tag" @change="existing_tag_updated()">\n                    <option :value="undefined">{{str(\'select\')}}..</option>\n                    <option v-for="(tag,tag_i) in existing_tags" :value="tag">{{tag}}</option>\n                </select>\n            </div>\n            \n            <div class="spacer" v-if="existing_tags&&existing_tags.length"></div>\n            \n            <div class="field">    \n                <div class="label">{{str(\'add\')}}..</div>\n                <input type="text" ref="new_tag" :placeholder="str(\'add\')+\'..\'" v-model="new_tag" autofocus @change="new_tag_updated()" @keydown="new_tag_updated()" />\n            </div>\n\n            <div class="spacer"></div>\n\n            <div class="btn v2" @click="select">{{str(\'select\')}}</div>\n\n        </div>\n      </div>\n    </div>',props:{},mixins:[mixins.basic],data:function(){return{new_tag:"",existing_tag:void 0,existing_tags:void 0}},computed:{tag:function(){var e=this.new_tag;return e=e||this.existing_tag,e},type:function(){return this.$store.state.modal_addtag.type}},methods:{close:function(){this.$store.commit("set_modal_addtag_active",!1),this.$store.commit("set_modal_addtag_onselected",void 0),this.$store.commit("set_modal_addtag_type",void 0)},new_tag_updated:function(){this.existing_tag&&(this.existing_tag="")},existing_tag_updated:function(){this.new_tag&&(this.new_tag=void 0)},fetch_existing_tags:function(){var t=this;return this.api_get("fetch_content_tags",{type:this.type}).done(function(e){t.existing_tags=e.tags}).fail(function(e){})},select:function(){var e;!this.tag||(e=this.$store.state.modal_addtag.onselected)&&(e(this.tag),this.$store.state.modal_addtag.onselected(this.tag),this.close())}},created:function(){},mounted:function(){var t=this;this.$refs.new_tag&&this.$refs.new_tag.focus(),this.fetch_existing_tags(),$(document).bind("keydown.x9782",function(e){if(13==e.which)return e.preventDefault(),t.select(),!1})},destroyed:function(){$(document).unbind("keydown.x9782")}}),Vue.component("keyman",{template:'<div class="keyman" :class="cls">\n      \n        <div class="dim" @click="close()"></div>\n\n        <div class="modal">\n            \n            <input type="text" v-if="visible" class="input" ref="input" v-model="input" autofocus @keypress="inputOnKeyPress($event)">\n\n            <div class="nomatches" v-if="input && input.length && !matches.length">Ingen resultater</div>\n            \n            <div class="matches" v-if="matches && matches.length">\n                <div class="match" v-for="(match,match_i) in matches" :key="\'k12f3f\'+match_i" :class="{focused:(matchIndex==match_i)}">\n                    <div class="match -link" v-if="match.type==\'link\'">\n                        <router-link :to="match.link" @click.native="close()">{{match.label}}</router-link>\n                    </div>\n                    <div class="match -action" v-if="match.type==\'action\'">\n                        <div class="" @click="match.action" @click.native="close()">{{match.label}}</div>\n                    </div>\n                </div>\n            </div>\n\n        </div>\n\n    </div>',props:{type:{type:String,default:"spinner"}},mixins:[mixins.basic],data:function(){return{visible:!1,input:"",result:void 0,documentInputsFocused:!1,matchIndex:0}},computed:{cls:function(){var e={visible:this.visible};return e},has_input:function(){return this.input&&this.input.length&&0<this.input.length},matches:function(){var i=this,n=[];if(!this.has_input)return n;var s=""+this.input.toLowerCase();-1!==this.str("home").toLowerCase().indexOf(s)&&n.push({type:"link",label:this.str("home"),link:"home"}),-1!==this.str("files").toLowerCase().indexOf(s)&&n.push({type:"link",label:this.str("files"),link:"assets"}),-1!==this.str("assets").toLowerCase().indexOf(s)&&n.push({type:"link",label:this.str("assets"),link:"assets"}),-1!==this.str("settings").toLowerCase().indexOf(s)&&n.push({type:"link",label:this.str("settings"),link:"settings"}),-1!==this.str("dark_mode").toLowerCase().indexOf(s)&&n.push({type:"action",label:this.str("dark_mode"),action:function(){i.setDarkMode(!0)}}),-1!==this.str("light_mode").toLowerCase().indexOf(s)&&n.push({type:"action",label:this.str("light_mode"),action:function(){i.setDarkMode(!1)}});var a,t=_createForOfIteratorHelper(this.active_item_schemas);try{for(t.s();!(a=t.n()).done;)!function(){var e=a.value,t=ucfirst(i.item_type_title(e,"plural,single"));-1!==t.toLowerCase().indexOf(s)&&n.push({type:"action",label:t,action:function(){i.gotoItemType(e)}})}()}catch(e){t.e(e)}finally{t.f()}for(var e in this.$store.state.keyman.cached_listItems){var o,l=this.$store.state.keyman.cached_listItems[e];l.title&&l.title.toLowerCase&&-1!==l.title.toLowerCase().indexOf(s)&&(o="item-"+l.type+"-uid-"+l.uid,n.push({type:"link",label:l.title,link:o}))}return 5<n.length&&(n=n.slice(0,5)),n.sort(function(e,t){return i.strings_overlap_charcount(s,e.label.toLowerCase())-i.strings_overlap_charcount(s,t.label.toLowerCase())}),window.x87237672&&n.push({type:"action",label:"Copy item fields",action:function(){window.x88827263=window.x87237672,i.toast({text:"Item fields copied",position:"bottom-right"})}}),window.x87237672&&window.x87237672.blocks&&n.push({type:"action",label:"Copy blocks",action:function(){window.x88827264=window.x87237672.blocks,i.toast({text:"Blocks copied",position:"bottom-right"})}}),window.x88827263&&n.push({type:"action",label:"Paste item fields",action:function(){mitter.emit("single-item-set-fields",window.x88827263),i.toast({text:"Item fields pasted",position:"bottom-right"})}}),window.x88827264&&n.push({type:"action",label:"Paste blocks",action:function(){mitter.emit("single-item-set-blocks",window.x88827264),i.toast({text:"Blocks pasted",position:"bottom-right"})}}),n}},methods:{close:function(){this.visible=!1,this.input="",this.matchIndex=0},selectMatch:function(){var e;!this.matches||(e=this.matches[this.matchIndex])&&("link"==e.type&&this.gotoView(e.link),"action"==e.type&&e.action())},inputOnKeyPress:function(){var e=event.key;event.code;"Enter"==e&&(this.selectMatch(),this.close())},offsetMatchIndex:function(e){var t=this.matchIndex+e;t<0&&(t=0),t>this.matches.length-1&&(t=this.matches.length-1),this.matchIndex=t},els_focused:function(){var e=document.querySelectorAll("input, textarea, select"),i=[];return Array.prototype.forEach.call(e,function(e,t){e===document.activeElement&&i.push(e)}),i},triggerFocus:function(e){var t,i="onfocusin"in e?"focusin":"focus",n="onfocusin"in e;"createEvent"in document?(t=document.createEvent("Event")).initEvent(i,n,!0):"Event"in window&&(t=new Event(i,{bubbles:n,cancelable:!0})),e.focus(),e.dispatchEvent(t)}},created:function(){var a=this;this.clients||this.$store.dispatch("load_clients"),this.jobs||this.$store.dispatch("load_jobs"),document.body.addEventListener("keydown",function(e){if(a.visible||!a.els_focused().length){var t=e.key,i=(e.code,"ArrowDown"==t),n="Backspace"==t,s="Escape"==t;if("ArrowUp"==t)return a.offsetMatchIndex(-1),e.preventDefault(),!1;if(i)return a.offsetMatchIndex(1),e.preventDefault(),!1;n&&(a.input&&a.input.length||a.close()),s&&a.close()}}),document.body.addEventListener("keypress",function(e){if(!a.els_focused().length){var t=e.key,i="Enter"==t;if(27==e.code)return a.input="";"Backspace"==t||(i?a.input="":(a.input.length||(a.input=t),a.visible||(a.visible=!0),setTimeout(function(){a.$refs.input.focus({focusVisible:!0})},0),setTimeout(function(){a.$refs.input.focus({focusVisible:!0})},100)))}},!1)}}),Vue.component("tagfield",{template:'<div class="tagfield" :key="key">\n        <div v-if="0">tags: {{tags}}</div>\n        <div v-if="0">tags_str: {{tags_str}}</div>\n        <div v-if="0">tags_arr: {{tags_arr}}</div>\n        <div class="tagbtns">\n            <div class="tagbtn" v-for="(tag) in tags_arr">\n                <span class="label">{{tag}}</span>\n                <span class="remove" @click="remove(tag)">X</span>\n            </div>\n            <div class="tagbtn --add" @click="add()">+</div>\n        </div>\n    </div>',data:function(){return{tags_str:void 0,all_tags_in_use:void 0,addMode:!1}},mixins:[mixins.basic],props:{tags:{type:String,default:void 0}},computed:{tags_arr:function(){var e=this.tags_str;if(!e||!e.length||" "==e)return[];var t=this.tags_str.split(",");return t=array_strip_duplicates(t=t.filter(function(e){return null!=e&&null!=e&&" "!=e&&""!=e}))},key:function(){return parseInt(9999*Math.random())}},methods:{fetch_all_tags_in_use:function(){var t=this;return this.api_get("fetch_content_tags",{type:"asset"}).done(function(e){t.all_tags_in_use=e.tags}).fail(function(e){})},addByModal:function(){var t=this;this.$store.commit("set_modal_addtag_onselected",function(e){e&&(t.tags_str||(t.tags_str=""),t.tags_str.length&&(t.tags_str+=","),t.tags_str+=e,t.emitUpdated(),t.addMode=!1)}),this.$store.state.modal_asset.active&&this.$store.commit("set_modal_addtag_type","asset"),this.$store.state.modal_asset.active||this.$store.commit("set_modal_addtag_type",this.$store.getters.url_route.params.type),this.$store.commit("set_modal_addtag_active",!0)},add:function(){return this.addByModal()},remove:function(e){this.tags_str=this.tags_str.split(e).join("").split(",,").join(","),this.emitUpdated()},emitUpdated:function(){this.$emit("updated",{value:this.tags_arr.join(",")})}},mounted:function(){this.tags_str=this.tags},created:function(){}});var $doc=$(document),$body=$("body"),$win=$(window),klay={vue:void 0,field_previews:{},block_previews:{},block_custom_btns:{}};window.klay=klay,Vue.use(Vuex);var store=new Vuex.Store({state:{version:void 0,buildno:void 0,php_version:void 0,php_extensions:void 0,block_autopreviews:void 0,base_url:void 0,url_hash:void 0,user:{token:void 0},logged_in_user:void 0,permissions:[],permissions_change_count:0,langstrings:void 0,fetched_content:{cms_config:void 0,asset:void 0},compactSidebar:!1,darkMode:!1,previewFrame:{active:!1,item:void 0,url:void 0,override_url:void 0,mobile_mode:!1},assets_lib:{search_str:void 0,search_tag:void 0,loaded_assets:[],loaded_asset_tags:[],pagination_limit:16,pagination_offset:0},filter_asset_tag:void 0,filter_asset_search:void 0,assets:{pagination:{page_index:0,items_max:80}},modal_assets:{active:!1},modal_asset:{active:!1,asset:void 0},asset_selection_callback:void 0,modal_richtext:{active:!1,value:void 0,update_callback:void 0},modal_cloner:{active:!1,original_item:void 0},modal_fields:{active:!1,data:void 0,fields:void 0,update_callback:void 0},modal_backup:{active:!1},modal_addblock:{active:!1,blocktypes:void 0,field:void 0,onselected:void 0},modal_addtag:{active:!1,onselected:void 0,type:void 0},admin_logo:void 0,admin_language:void 0,ui_active_lang:void 0,login_disabled:!1,preview_enabled:!0,keyman:{cached_listItems:{}},phpdata:void 0,customLinks:[],customViews:[],filedropzoneEnabled:!0,uploadingFileActive:!1,uploadingFileList:[]},getters:{url_route:function(e){var t,i=e.url_hash,n="e404",s={};i&&""!==i||(n="home"),["login","home","settings","assets","settings-assets","language","strings","code-editor"].includes(i)&&(n=i),(t=i.match(/items-(.+)/))&&(n="items-list",s={type:t[1]}),(t=i.match(/item-(.+)-uid-(.+)/))&&(n="item-single",s={type:t[1],uid:t[2]});var a,o=_createForOfIteratorHelper(e.customViews);try{for(o.s();!(a=o.n()).done;){var l=a.value;l.slug===i&&(n="custom",s=l)}}catch(e){o.e(e)}finally{o.f()}return{view:n,params:s}},cms_config:function(e){return e.fetched_content.cms_config},user_can:function(t){return function(e){return!(!t.permissions||!t.permissions.length)&&(!(!t.permissions.includes("anything")||t.permissions.includes("!"+e))||t.permissions.includes(e))}},item_schemas:function(e){if(e.fetched_content.cms_config&&e.fetched_content.cms_config.item_schemas)return e.fetched_content.cms_config.item_schemas},item_schemas_only_singular:function(e,t){var i=t.item_schemas;if(i)return i.filter(function(e){return t.schema_is_singular(e)})},item_schemas_only_non_singular:function(e,t){var i=t.item_schemas;if(i)return i.filter(function(e){return!t.schema_is_singular(e)})},item_schemas_only_from_php:function(e,t){var i=t.item_schemas;if(i)return i.filter(function(e){return e.from_php})},item_schemas_only_from_db:function(e,t){var i=t.item_schemas;if(i)return i.filter(function(e){return!e.from_php})},block_schemas:function(e){if(e.fetched_content.cms_config&&e.fetched_content.cms_config.blocks)return e.fetched_content.cms_config.blocks},block_schemas_only_from_php:function(e,t){var i=t.block_schemas;if(i)return i.filter(function(e){return e.from_php})},block_schemas_only_from_db:function(e,t){var i=t.block_schemas;if(i)return i.filter(function(e){return!e.from_php})},get_item_schema:function(e,s){return function(e){if(s.item_schemas){var t,i=_createForOfIteratorHelper(s.item_schemas);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.name===e)return n}}catch(e){i.e(e)}finally{i.f()}}}},get_block_schema:function(e,s){return function(e){if(s.block_schemas){var t,i=_createForOfIteratorHelper(s.block_schemas);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.name===e)return n}}catch(e){i.e(e)}finally{i.f()}}}},schema_is_singular:function(){return function(e){return isTrue(e.singular)}},get_items:function(t,i){return function(e){i.get_item_schema(e);if(t.fetched_content[e])return t.fetched_content[e]}},items_filter_trashed:function(){return function(e){return e.filter(function(e){return isTrue(e.trashed)})}},items_filter_untrashed:function(){return function(e){return e.filter(function(e){return!isTrue(e.trashed)})}},get_items_where:function(e,i){return function(e,n){var s=i.get_items(e);if(!s)return s;for(var t in n)!function(t){var i=n[t];s=s.filter(function(e){return e[t]&&e[t]===i})}(t);return s}},get_item:function(o,l){return function(e,t){if("any"!==e||(e=l.item_get_type(t))){var i=l.get_item_schema(e);if("asset"==e&&(i={}),i&&o.fetched_content[e]){var n,s=_createForOfIteratorHelper(o.fetched_content[e]);try{for(s.s();!(n=s.n()).done;){var a=n.value;if(a.uid===t)return a}}catch(e){s.e(e)}finally{s.f()}}}}},item_get_type:function(o){return function(e){var t=o.fetched_content;for(var i in t){var n=t[i];for(var s in n){var a=n[s];if(a&&a.uid&&a.uid===e)return i}}}},item_type_has_items:function(e,i){return function(e){var t=i.get_items(e);return i.items_filter_untrashed(t)}},languages:function(e){if(e.fetched_content.cms_config&&e.fetched_content.cms_config.languages)return e.fetched_content.cms_config.languages},languagecodes:function(e,t){if(!t.languages)return[];var i,n=[],s=_createForOfIteratorHelper(t.languages);try{for(s.s();!(i=s.n()).done;){var a=i.value;n.push(a.code)}}catch(e){s.e(e)}finally{s.f()}return n},primary_language:function(e,t){if(t.languages){var i=t.languages.filter(function(e){return isTrue(e.primary)});if(1==t.languages.length)return t.languages[0];if(i&&i.length)return i[0]}},has_active_language:function(e,t){return function(e){return t.languagecodes&&t.languagecodes.includes(e)}},strings:function(e){if(e.fetched_content.cms_config&&e.fetched_content.cms_config.strings)return e.fetched_content.cms_config.strings},is_multilingual:function(e,t){return t.languages&&t.languages.length&&1<t.languages.length},get_language:function(){return function(e){var t,i=_createForOfIteratorHelper(language_options);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.code===e)return n}}catch(e){i.e(e)}finally{i.f()}}},get_langstring:function(i){return function(e,t){return i.langstrings&&i.langstrings[e]?i.langstrings[e][t]?i.langstrings[e][t]:i.langstrings[e].en?i.langstrings[e].en:e:e}},get_string:function(e,a){return function(e,t,i){i=i||1;var n=a.strings;if(n&&n[e]&&n[e][t])return n[e][t];if(1===i){var s=a.primary_language.code;if(n&&n[e]&&n[e][s])return n[e][s]}return e}},all_items:function(e,t){var i,n=[],s=_createForOfIteratorHelper(t.item_schemas);try{for(s.s();!(i=s.n()).done;)var a=i.value,n=n.concat(t.get_items(a.name))}catch(e){s.e(e)}finally{s.f()}return n},get_language_items:function(e,n){return function(t,e){var i=[];return e&&(i=i.concat(n.get_items(e))),e||i.concat(n.all_items),i=i.filter(function(e){return e.language&&e.language==t})}},get_item_languages:function(){return function(e){var t,i=[],n=_createForOfIteratorHelper(e);try{for(n.s();!(t=n.n()).done;){var s=t.value;s.language&&!i.includes(s.language)&&i.push(s.language)}}catch(e){n.e(e)}finally{n.f()}return i}},all_item_languages:function(e,t){return t.get_item_languages(t.all_items)},all_item_unassigned_language:function(e,t){return t.all_items.filter(function(e){return!e.language})},get_asset:function(s){return function(e){if(s.fetched_content.asset){var t,i=_createForOfIteratorHelper(s.fetched_content.asset);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.uid===e)return n}}catch(e){i.e(e)}finally{i.f()}}}},view:function(e,t){return t.url_route.view},url_params:function(e,t){return t.url_route.params},assets:function(e){return e.fetched_content.asset},get_item_url:function(n){return function(e,t){if(!e||!t||!t.slug)return!1;if(void 0===e.url_slug)return!1;var i=e.url_slug;return i=(i=i.replace("(:base)",removeTrailingSlash(n.base_url))).replace("(:slug)",t.slug)}},old_previewFrame_url:function(e,t){if(e.previewFrame.override_url)return e.previewFrame.override_url;var i=t.url_params;if(i&&i.type&&i.uid){var n=t.get_item_schema(i.type);if(!n)return console.log({m:1});var s=window.klay_previewframe_item;if(!s)return console.log({m:2});var a=t.get_item_url(n,s);return a||console.log({m:3})}}},mutations:{set_x:function(e,t){e[t.x]=t.y},set_base_url:function(e,t){e.base_url=t},set_user_token:function(e,t){e.user.token=t},set_url_hash:function(e,t){e.url_hash=t},set_login_disabled:function(e,t){e.login_disabled=t},set_fetched_content:function(e,t){Vue.set(e.fetched_content,t.type,t.data)},clear_fetched_content:function(e,t){Vue.set(e.fetched_content,t,void 0)},set_cms_config:function(e,t){Vue.set(e.fetched_content,"cms_config",t)},set_assets_lib_search_str:function(e,t){e.assets_lib.search_str=t},set_assets_lib_search_tag:function(e,t){e.assets_lib.search_tag=t},set_assets_lib_loaded_assets:function(e,t){e.assets_lib.loaded_assets=t},set_assets_lib_loaded_asset_tags:function(e,t){e.assets_lib.loaded_asset_tags=t},set_assets_lib_pagination_limit:function(e,t){e.assets_lib.pagination_limit=t},set_assets_lib_pagination_offset:function(e,t){e.assets_lib.pagination_offset=t},set_uploadingFileActive:function(e,t){e.uploadingFileActive=t},set_uploadingFileList:function(e,t){e.uploadingFileList=t},set_filter_asset_search:function(e,t){e.filter_asset_search=t},set_assets_pagination_page_index:function(e,t){e.assets.pagination.page_index=t},set_ui_active_lang:function(e,t){e.ui_active_lang=t},set_admin_language:function(e,t){e.admin_language=t},set_modal_asset:function(e,t){e.modal_asset.asset=t},set_modal_asset_active:function(e,t){e.modal_asset.active=t},set_modal_assets_active:function(e,t){e.modal_assets.active=t},set_modal_richtext_value:function(e,t){e.modal_richtext.value=t},set_modal_richtext_active:function(e,t){e.modal_richtext.active=t},set_modal_richtext_update_callback:function(e,t){e.modal_richtext.update_callback=t},set_modal_cloner:function(e,t){null!==t.active&&(e.modal_cloner.active=t.active),null!==t.original_item&&(e.modal_cloner.original_item=t.original_item)},set_modal_fields_active:function(e,t){e.modal_fields.active=t},set_modal_fields_data:function(e,t){e.modal_fields.data=t},set_modal_fields_fields:function(e,t){e.modal_fields.fields=t},set_modal_fields_update_callback:function(e,t){e.modal_fields.update_callback=t},set_modal_backup_active:function(e,t){e.modal_backup.active=t},set_modal_addblock_active:function(e,t){e.modal_addblock.active=t},set_modal_addblock_blocktypes:function(e,t){e.modal_addblock.blocktypes=t},set_modal_addblock_field:function(e,t){e.modal_addblock.field=t},set_modal_addblock_onselected:function(e,t){e.modal_addblock.onselected=t},set_modal_addtag_active:function(e,t){e.modal_addtag.active=t},set_modal_addtag_onselected:function(e,t){e.modal_addtag.onselected=t},set_modal_addtag_type:function(e,t){e.modal_addtag.type=t},setDarkMode:function(e,t){e.darkMode=t},toggleDarkMode:function(e){e.darkMode=!e.darkMode},setCompactSidebar:function(e,t){e.compactSidebar=t},toggleCompactSidebar:function(e){e.compactSidebar=!e.compactSidebar},setPreviewFrame:function(e,t){e.previewFrame.active=t},togglePreviewFrame:function(e){e.previewFrame.active=!e.previewFrame.active},togglePreviewFrameMobileMode:function(e){e.previewFrame.mobile_mode=!e.previewFrame.mobile_mode},set_PreviewFrame_item:function(e,t){e.previewFrame.item=t},set_PreviewFrame_url:function(e,t){e.previewFrame.url=t},set_PreviewFrame_override_url:function(e,t){e.previewFrame.override_url=t},set_asset_selection_callback:function(e,t){e.asset_selection_callback=t},set_admin_logo:function(e,t){e.admin_logo=t},set_langstrings:function(e,t){e.langstrings=t},set_logged_in_user:function(e,t){e.logged_in_user=t},set_permissions:function(e,t){0<e.permissions_change_count||(e.permissions=t,e.permissions_change_count=e.permissions_change_count+1)},set_version:function(e,t){e.version=t},set_buildno:function(e,t){e.buildno=t},set_php_version:function(e,t){e.php_version=t},set_php_extensions:function(e,t){e.php_extensions=t},set_preview_enabled:function(e,t){e.preview_enabled=t},set_block_autopreviews:function(e,t){e.block_autopreviews=t},set_keyman_cached_listItems:function(t,e){e.forEach(function(e){t.keyman.cached_listItems[e.uid]=e})},set_phpdata:function(e,t){e.phpdata=t},setCustomLinks:function(e,t){e.customLinks=t},setCustomViews:function(e,t){e.customViews=t},set_filedropzoneEnabled:function(e,t){e.filedropzoneEnabled=t}},actions:{check_user_logged_in_token:function(e){var t=getCookie("t836724");void 0!==t&&e.commit("set_user_token",t)}}});window.mitter=new EventEmitter,Vue.directive("tooltip",{bind:function(e,t){var i;window.tippy&&(window.tippy_instances||(window.tippy_instances=[]),i=tippy(e,{content:t.value,delay:[200,0],theme:klay.vue.darkMode?"light":"dark",animation:"scale-subtle"}),window.tippy_instances.push(i),$(e).addClass("tippied"))},inserted:function(){},update:function(t,e){t._tippy&&(window.tippy_instances=window.tippy_instances.filter(function(e){return e.id!==t._tippy.id}),t._tippy.destroy());var i=tippy(t,{content:e.value,delay:[200,0],theme:klay.vue.darkMode?"light":"dark",animation:"scale-subtle"});window.tippy_instances.push(i)},componentUpdated:function(){},unbind:function(t){t._tippy&&(window.tippy_instances=window.tippy_instances.filter(function(e){return e.id!==t._tippy.id}),t._tippy.destroy())}}),klay.vue=new Vue({el:"#app",store:store,mixins:[mixins.basic],data:{show_apploader:!0,url_hash:void 0,view:"loading",fetched_content:{cms_config:void 0,asset:void 0},updatedItem:void 0,unsavedChanges:void 0,view_active_subitems_filter_str:void 0,fileDraggedOver:!1},computed:{app_cls:function(){var e={};return e["view-"+this.$store.getters.url_route.view]=!0,e["lbar-s"]=this.compactSidebar||this.preview_enabled&&this.previewFrame.active&&this.previewFrame_url,e["preview-frame"]=this.preview_enabled&&this.previewFrame.active&&this.previewFrame_url,e["preview-frame-mobile-mode"]=this.preview_enabled&&this.previewFrame.active&&this.previewFrame_url&&this.$store.state.previewFrame.mobile_mode,e.darkmode=this.darkMode,e["file-dropping"]=this.fileDraggedOver,e.uploading=this.uploadingFileActive,e},show_lbar:function(){return!!this.logged_in&&("loading"!=this.view&&("login"!=this.view&&"e404"!=this.view))},show_main:function(){return!!this.logged_in&&("loading"!=this.view&&"login"!=this.view)},item_schemas:function(){if(this.cms_config)return this.cms_config.item_schemas},item_subitems_list_title:function(){var e="";return e+=this.item_type_title(this.view_active_item_type,"plural,single"),ucfirst(e+=" ("+(this.view_active_item_type_subitems_filtered||[]).length+" found)")},create_new_item_title:function(){var e="Create new ";return e+=this.item_type_title(this.view_active_item_type,"single")},update_item_title:function(){var e="Update ";return e+=this.item_type_title(this.view_active_item_type,"single")},single_item_view_title:function(){var e=this.item_type_title(this.view_active_item_type,"single,plural"),t=this.view_active_subitem.title||this.view_active_subitem.title||"Untitled";return ucfirst(e)+": "+ucfirst(t)},hasUnsavedChanges:function(){return void 0!==this.unsavedChanges}},methods:{get_item_type:function(e){if(this.item_schemas){var t,i=_createForOfIteratorHelper(this.item_schemas);try{for(i.s();!(t=i.n()).done;){var n=t.value;if(n.uid==e)return n;if(n.name==e)return n}}catch(e){i.e(e)}finally{i.f()}}},get_php_passed_data:function(){var e;window.klayphp2js&&(e=window.klayphp2js,this.$store.commit("set_phpdata",e),e.version&&this.$store.commit("set_version",e.version),e.buildno&&this.$store.commit("set_buildno",e.buildno),e.cms_config&&this.$store.commit("set_cms_config",e.cms_config),e.php_version&&this.$store.commit("set_php_version",e.php_version),e.php_extensions&&this.$store.commit("set_php_extensions",e.php_extensions),e.block_autopreviews&&this.$store.commit("set_block_autopreviews",e.block_autopreviews),e.langstrings&&this.$store.commit("set_langstrings",e.langstrings),e.base_url&&this.$store.commit("set_base_url",e.base_url),e.langstrings&&this.$store.commit("set_langstrings",e.langstrings),e.logged_in_user&&this.$store.commit("set_logged_in_user",JSON.parse(JSON.stringify(e.logged_in_user))),e.permissions&&this.$store.commit("set_permissions",JSON.parse(JSON.stringify(e.permissions))),e.admin_logo&&this.$store.commit("set_admin_logo",e.admin_logo),e.login_disabled&&this.$store.commit("set_login_disabled",e.login_disabled),e.brand_color&&this.$store.commit("set_brand_color",e.brand_color),e.brand_color&&document.documentElement.style.setProperty("--brand-color",e.brand_color),e.csrf_token&&$.ajaxSetup({headers:{"X-CSRF-Token":e.csrf_token}}),void 0!==e.preview_enabled&&this.$store.commit("set_preview_enabled",!0===e.preview_enabled||1===e.preview_enabled||"true"===e.preview_enabled||"1"===e.preview_enabled))},onhashchange:function(){var e=window.location.hash.replace("#","");this.url_hash=e,this.view=e,this.$store.commit("set_url_hash",e)},open_modal_single_asset:function(e){this.modal_single_asset=JSON.parse(JSON.stringify(e))},close_modal_single_asset:function(){this.$store.commit("set_modal_asset",void 0)},onfileDropped:function(e){var t=this;if(!this.filedropzoneEnabled)return!1;if(this.uploadingFile)return!1;e.preventDefault();var i=[];if(e.dataTransfer.items){for(var n=0;n<e.dataTransfer.items.length;n++){var s=e.dataTransfer.items[n];"file"===s.kind&&i.push(s.getAsFile())}window.uploadingFiles=!0,1<i.length&&(window.filesUploadedDone=0,window.filesUploadedError=0,window.onFilesUploaded=function(){window.filesUploadedError||t.toast({text:t.str("x_files_uploaded").replace("{x}",window.filesUploadedDone),icon:"check_circle"}),window.filesUploadedError&&t.toast({text:t.str("x_files_uploaded_y_failed").replace("{x}",window.filesUploadedDone).replace("{y}",window.filesUploadedError),icon:"warning",type:"error"}),t.fetch_content({type:"asset"}),window.filesUploadedDone=0,window.filesUploadedError=0});for(var a=0;a<i.length;a++){var o=this.$store.state.assets_lib.search_tag&&this.$store.state.assets_lib.search_tag.length&&"only-empty"!==this.$store.state.assets_lib.search_tag?this.$store.state.assets_lib.search_tag:void 0;this.uploadFile({file:i[a],asset:{tags:o}})}this.fileDraggedOver=!1}},onFileDragOver:function(e){if(!this.filedropzoneEnabled)return!1;e.preventDefault()},onFileDragEnter:function(e){var t=this;if(!this.filedropzoneEnabled)return!1;e.preventDefault(),this.fileDraggedOver=!0,$(document).one("mousemove",function(){t.fileDraggedOver=!1}),$(document).one("mouseleave",function(){t.fileDraggedOver=!1}),$(document).one("mouseenter",function(){t.fileDraggedOver=!1})},onFileDragLeave:function(e){e.preventDefault()},trk:function(){$.post("https://api.klay.dev/trk",{url:window.location+""}).done(function(e){e.msg&&"license-needed"==e.msg&&$("body").append('<a href="https://klay.dev" target="_blank" class="license-needed">It looks like you might need a license. Please visit: https://klay.dev</a>')}).fail(function(){}).always(function(){})}},created:function(){var n=this;window.save_item_rendered_html=function(e,t){var i="Klay CMS: The website in the preview panel just asked me to save the rendered html you can see in the console.";n.toast({text:i,icon:"check_circle"}),console.log({msg:i,slug:e,html:t})},$.ajaxSetup({xhrFields:{withCredentials:!0},statusCode:{401:function(){console.log("AJAX-401-NO-AUTH-ERROR-LOGIN-REFRESH"),setCookie("t836724",void 0,9999),n.$store.commit("set_user_token",void 0),n.gotoView("login")}}}),document.body.classList.add("v-ready"),$(document).click(function(e){window.lastClickedEvent=e}),$(document).mousemove(throttle(function(e){window.lastMoveMoveEvent=e},100)),"enabled"===localStorage.getItem("darkmode")&&this.$store.commit("setDarkMode",!0),"enabled"===localStorage.getItem("compactsidebar")&&this.$store.commit("setCompactSidebar",!0),this.$store.commit("set_admin_language",localStorage.getItem("admin_language")?localStorage.getItem("admin_language"):"en"),this.get_php_passed_data(),window.onhashchange=this.onhashchange,this.onhashchange(),$win.resize(throttle(function(){!n.compactSidebar&&$win.width()<800&&(n.compactSidebar=!0)},300)),$win.trigger("resize"),this.$store.dispatch("check_user_logged_in_token"),this.logged_in&&this.on_logged_in(),this.logged_in||this.gotoView("login"),setTimeout(function(){n.show_apploader=!1},300),setTimeout(function(){n.trk()},300)}}),window.asset_previews_queue=[],window.asset_previews_fetched={},window.fetch_asset_previews_queue=function(){var e=structuredClone(_toConsumableArray(new Set(window.asset_previews_queue)));window.asset_previews_queue=[],e.length&&$.ajax({type:"POST",url:klay.vue.$store.state.base_url,data:JSON.stringify({api_endpoint:"fetch_preview_assets",uids:e}),dataType:"json",contentType:"application/json; charset=utf-8"}).done(function(e){var t,i=_createForOfIteratorHelper(e.assets);try{for(i.s();!(t=i.n()).done;){var n=t.value;window.asset_previews_fetched["uid:"+n.uid]=n,window["asset_preview_onfetched_"+n.uid]&&window["asset_preview_onfetched_"+n.uid](n)}}catch(e){i.e(e)}finally{i.f()}})},klay.spinner=function(e){$(".spinner").length||$body.append('<div class="spinner"><div class="circle"><div></div></div><div class="msg"></div></div>'),"boolean"==typeof e&&(e={active:e}),"number"==typeof e&&(e={active:Boolean(e)}),$(".spinner").toggleClass("active",e.active).toggleClass("blocking",!0===e.blocking).find(".msg").toggleClass("hide",!e.msg).html(e.msg||"")},klay.toast=function(e){var t=e.type||"success",i=e.text,n=e.title;if(!window.toastr)return klay.msg(" "+(i||"")+" "+(n||"")+" ");toastr.options.closeButton=void 0!==e.closeButton&&e.closeButton,toastr.options.closeDuration=void 0!==e.closeDuration?e.closeDuration:100,toastr.options.showEasing="swing",toastr.options.positionClass=void 0===e.position?"toast-top-right":"toast-"+e.position,toastr.options.showMethod="slideDown",toastr.options.hideMethod="slideUp",toastr.options.closeMethod="slideUp",toastr.options.preventDuplicates=void 0!==e.preventDuplicates&&e.preventDuplicates,e.icon||(e.icon="info"),e.icon&&(i='<span class="material-symbols-outlined icon">'+e.icon+"</span>"+i),e.text=void 0,e.title=void 0,e.type=void 0;var s=e;e.position&&(toastr.options.position=e.position),toastr[t](i,n,s)},klay.modalBuild=function(e){if((e=e||{}).id&&$('.modal[data-id="'+e.id+'"]').length)return $('.modal[data-id="'+e.id+'"]').addClass("active");var t=[];e.type&&t.push("type-"+e.type),e.look&&t.push("look-"+e.look),!1!==e.active&&t.push("active"),!1!==e.dimClose&&t.push("dim-closable"),!1!==e.selfDestructing&&t.push("self-destructing");var i='<div class="closer">X</div>';0==e.closeBtn&&(i="");var n='<div class="modal '+t.join(" ")+'" data-id="'+e.id+'"><div class="dim"></div><div class="popup" ref="popup">';e.title&&(n+='<div class="title">'+e.title+i+"</div>"),e.title||(n+=i),e.html=e.html||e.text||e.content,n+='<div class="inner">'+e.html+"</div></div></div>",$("body").append(n),$(".modal").not("c982").find(".prompt-input input").change(function(){window.modalPromptValue=$(this).val()}),$(".modal").not("c982").find(".prompt-input input").length&&$(".modal").not("c982").find(".prompt-input input").trigger("focus"),$(".modal").not("c982").addClass("c982")},klay.msg=function(e){"object"!==_typeof(e)&&(e={html:e}),e.type="msg",e.html=e.html||e.text||e.content,null==e.dimClose&&(e.dimClose=!1),null==e.closeBtn&&(e.closeBtn=!1),null==e.selfDestructing&&(e.selfDestructing=!0),e.okText||(e.okText='<span class="material-symbols-outlined icon">done</span>'),e.html+='<div class="msg-ok-btn">'+e.okText+"</div>",klay.modalBuild(e)},klay.confirm=function(e){e.type="confirm",e.html=e.html||e.text||e.content,null==e.dimClose&&(e.dimClose=!1),null==e.closeBtn&&(e.closeBtn=!0),null==e.selfDestructing&&(e.selfDestructing=!0),e.okText||(e.okText='<span class="material-symbols-outlined icon">done</span>'),e.cancelText||(e.cancelText='<span class="material-symbols-outlined icon">close</span>'),e.html+='<div class="confirm-btns"><div class="confirm-cancel-btn">'+e.cancelText+'</div><div class="confirm-ok-btn">'+e.okText+"</div></div>",window.onConfirmOkayCallback=e.onOkay,window.onConfirmCancelCallback=e.onCancel,klay.modalBuild(e)},klay.prompt=function(e){e.type="prompt",e.html=e.html||e.text||e.content,null==e.dimClose&&(e.dimClose=!1),null==e.closeBtn&&(e.closeBtn=!0),null==e.selfDestructing&&(e.selfDestructing=!0),e.okText||(e.okText='<span class="material-symbols-outlined icon">done</span>'),e.cancelText||(e.cancelText='<span class="material-symbols-outlined icon">close</span>'),e.html+='<div class="prompt-input"><input type="'+(e.inputType||"text")+'" placeholder="'+(e.placeholder||"")+'" /></div>',e.html+='<div class="confirm-btns"><div class="confirm-cancel-btn">'+e.cancelText+'</div><div class="confirm-ok-btn">'+e.okText+"</div></div>",window.onConfirmOkayCallback=e.onOkay,window.onConfirmCancelCallback=e.onCancel,klay.modalBuild(e)},$doc.on("click",".modal .closer, .modal.dim-closable .dim, .msg-ok-btn, .confirm-ok-btn, .confirm-cancel-btn",function(){var e=$(this).closest(".modal");e.hasClass("self-destructing")&&e.remove(),e.hasClass("self-destructing")||e.removeClass("active"),$(this).hasClass("confirm-ok-btn")&&window.onConfirmOkayCallback&&window.onConfirmOkayCallback(),$(this).hasClass("confirm-cancel-btn")&&window.onConfirmCancelCallback&&window.onConfirmCancelCallback()}),klay.elementInViewport=function(e){for(var t=e.offsetTop,i=e.offsetLeft,n=e.offsetWidth,s=e.offsetHeight;e.offsetParent;)t+=(e=e.offsetParent).offsetTop,i+=e.offsetLeft;return t>=window.pageYOffset&&i>=window.pageXOffset&&t+s<=window.pageYOffset+window.innerHeight&&i+n<=window.pageXOffset+window.innerWidth},klay.set_any_open_modal_to_mouse_position_inside_viewport=function(e){$(".modal-fields, .modal-addblock").each(function(){var e=$(this).find(".popup").get(0);klay.set_popup_to_mouse_position(e),klay.set_popup_inside_viewport(e)})},klay.set_any_open_modal_to_mouse_position=function(e){$(".modal-fields, .modal-addblock").each(function(){var e=$(this).find(".popup").get(0);klay.set_popup_to_mouse_position(e)})},klay.set_any_open_modal_inside_viewport=function(e){$(".modal-fields, .modal-addblock").each(function(){var e=$(this).find(".popup").get(0);klay.set_popup_inside_viewport(e)})},klay.set_popup_to_mouse_position=function(e){},klay.set_popup_inside_viewport=function(e){},klay.scroll_previewframe_to=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:700,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"easeInOutCubic";$(".previewframe iframe").length&&$(".previewframe iframe").contents()&&$(".previewframe iframe").contents().find("html,body").length&&($.easing&&$.easing[i]||(i="swing"),$(".previewframe iframe").contents().find("html,body").stop().animate({scrollTop:e},t,i))},klay.get_previewframe_blocks_container=function(){if($(".previewframe iframe").length&&$(".previewframe iframe").contents()&&$(".previewframe iframe").contents().find("html,body").length){var e=$(".previewframe iframe").contents().find("body"),t=e.find(".blocks");return t.length||(t=e.find(".contentblocks")),t.length?t:void 0}},klay.get_previewframe_blocks=function(){var e=klay.get_previewframe_blocks_container();if(e.length){var t=e.find("> *");if(t.length)return t}},klay.get_previewframe_block=function(e){var t=klay.get_previewframe_blocks();if(t&&t.eq(e))return t.eq(e)},klay.addCustomLink=function(e){klay.vue.$store.commit("setCustomLinks",klay.vue.$store.state.customLinks.concat([e]))},klay.addCustomView=function(e){klay.vue.$store.commit("setCustomViews",klay.vue.$store.state.customViews.concat([e]))},klay.addRichTextModifier=function(e){Array.isArray(e)||(e=[e]),klay.richtext_modifiers||(klay.richtext_modifiers=[]),e.forEach(function(e){klay.richtext_modifiers.push(e)})};</script><!--ADMIN-INJECTABLE-JS--></body></html><?php $admin_html=ob_get_clean();$admin_html=str_replace("{{DOC-TITLE}}", ( isset($c->page_title) ? $c->page_title : 'Klay CMS - Content made easy' ), $admin_html);$admin_html=str_replace("'php-injected-data-here'", "JSON.parse('".addslashes(json_encode($x))."')", $admin_html);if(!empty($this->admin_css)) $admin_html=str_replace("<!--ADMIN-INJECTABLE-CSS-->", "<style>$this->admin_css</style>", $admin_html);if(!empty($this->admin_js)) $admin_html=str_replace("<!--ADMIN-INJECTABLE-JS-->", "<script>$this->admin_js</script>", $admin_html);echo $admin_html;die();}public function get_asset_src( $uid_or_asset, $max_w=NULL, $desired_format=NULL ){if(empty($uid_or_asset)) return '';if(is_object($uid_or_asset)) $asset=$uid_or_asset;if(is_string($uid_or_asset)) $uid=$uid_or_asset;if(empty($asset)&&isset($uid)) $asset=$this->get('asset', $uid);if(empty($asset)) return '';$content_path=$this->content_path;$content_url=$this->content_url;$is_resizable_img=in_array($asset->format, ['jpg','png','webp']);if(!$is_resizable_img ) {$fn="/asset/$asset->uid/$asset->title.$asset->format";if(!is_file($content_path.$fn)) return '';$mtime=filemtime($content_path.$fn);$url=$content_url.$fn.'?v='.$mtime;}if($is_resizable_img ) {$fn_orig="/asset/$asset->uid/$asset->title.$asset->format";$format=empty($desired_format) ? $asset->format : $desired_format;$size=empty($max_w) ? '/' : '/w'.$max_w.'/';$fn="/asset/$asset->uid".$size."$asset->title.$format";$resizable_dir=$this->path_minus_filename($content_path.$fn);if(!is_file($content_path.$fn)) {if(!is_dir($resizable_dir)) mkdir($resizable_dir, $this->mkdir_chmod, true);$quality=7;$img=$this->image_create_from($asset->format, $content_path.$fn_orig);$do_resize=$max_w < imagesx($img);if(!$do_resize) {return $content_url.$fn_orig;$done=copy( $content_path.$fn_orig, $content_path.$fn );}if($do_resize) {$img=$this->image_resize($img, $max_w);$img=$this->image_sharpen($img, 1);$done=$this->image_output($img, $format, $content_path.$fn, $quality);}}if(!is_file($content_path.$fn)) return 'file-not-found: '.$content_path.$fn;$mtime=filemtime($content_path.$fn);$url=$content_url.$fn.'?v='.$mtime;}return $url;}public function webp_or($alt_format){if(strpos( $_SERVER['HTTP_ACCEPT'], 'image/webp' ) !== false ) return 'webp';return $alt_format;}public function generate_dummy_item($schema){if(is_string($schema)) $schema=$this->get_item_type($schema);$item=(object) ['uid' => $this->makeUid(),'title' => $this->loremify(rand(2,3)),'created_at' => date('Y-m-d H:i:s'),'fields' => (object) [],'tags' => 'Dummy generated','published' => true,];$item->slug=$this->slugify($item->title);$lang=$this->get_primary_language();if(!empty($lang->code)) $item->language=$lang->code;if(!empty($schema->fields)) {foreach( $schema->fields as $field ) {$item->fields->{$field->name}=$this->generate_dummy_field_value($field);if($field->type=='block' ) {$item->fields->{$field->name}=array_fill(0, rand(0,3), (object)[]);foreach( $item->fields->{$field->name} as $row ){$random_blocktype=$this->cms_config->blocks[ rand(0, count($this->cms_config->blocks)-1) ];$row->_type='_'.$random_blocktype->name;foreach( $random_blocktype->fields as $field2 ) {$row->{$field2->name}=$this->generate_dummy_field_value($field2);}}}if($field->type=='repeater'&&!empty($field->fields)) {$item->fields->{$field->name}=array_fill(0, rand(0,3), (object)[]);foreach( $item->fields->{$field->name} as $row ){foreach( $field->fields as $field2 ) {$row->{$field2->name}=$this->generate_dummy_field_value($field2);}}}}}$item=$this->apply_filter('item:generated', $item, (object)['itemtype'=>$schema->name]);if($schema->name=='asset'){ $img=imagecreatetruecolor(1000, 1000);$color=imagecolorallocate($img, rand(1,255), rand(1,255), rand(1,255));$filename='temp-image-'.rand(1111,9990).'.jpg';imagefill($img, 0, 0, $color);imagejpeg($img, $filename);imagedestroy($img);$file=(object)[ 'name'=>$filename, 'tmp_name'=>$filename, 'type'=>'jpg', 'size'=>filesize($filename) ];$file_saved=$this->save_asset_file($file, $item);if($file_saved->status=='success') $item=$file_saved->item;}return $item;}public function generate_dummy_field_value($field){if($field->type=='text' ) return $this->loremify(rand(3,7),1);if($field->type=='textarea' ) return $this->loremify(rand(3,9),rand(3,12));if($field->type=='richtext' ) return $this->loremify(rand(3,9),rand(4,30));if($field->type=='number' ) return rand( isset($min) ? $min : 0, isset($max) ? $max : 999999 );if($field->type=='range' ) return rand( isset($min) ? $min : 0, isset($max) ? $max : 999999 );if($field->type=='checkbox' ) return [TRUE, FALSE][rand(0,1)];if($field->type=='asset' ) return (object)[ 'type'=>'asset', 'uid' => $this->get_random_asset_uid() ];if($field->type=='color' ) return sprintf('#%06X', mt_rand(0, 0xFFFFFF));if($field->type=='date' ) return date("Y-m-d H:i:s", mt_rand( time() - 10000000, time() + 10000000 ));if($field->type=='geolocation' ) return (object) [ 'lat'=>floatval(mt_rand( -90000, 90000 ) / 1000), 'lng'=>floatval(mt_rand( -180000, 180000 ) / 1000), 'zoom'=>floatval(mt_rand(0, 18000) / 1000) ];if($field->type=='select'&&!empty($field->options)) {$value=$this->randFromArray(array_values((array)$field->options));if(!empty($field->multiple)) {$value=[$value];if(rand(1,2)==2 ) $value[]=$this->randFromArray(array_values((array)$field->options));}return $value;}if($field->type=='relation' ) {$type=$this->randFromArray((isset($field->types) ? $field->types : $this->get_item_types()));if(empty($type))return;$item=$this->db_get_random_item($type);if(empty($item))return;return (object)[ 'type'=>$type, 'uid' => $item->uid ];}}public function get_random_asset(){$asset=$this->db_get_random_item('asset');if(empty($asset))return;return $asset;}public function get_random_asset_uid(){$asset=$this->get_random_asset();if(empty($asset))return;return $asset->uid;}public function get_langstrings(){return (object) ['add' => [ 'en'=>'Add' ],'select' => [ 'en'=>'Select' ],'change' => [ 'en'=>'Change...' ],'back' => [ 'en'=>'Back' ],'active' => [ 'en'=>'Active' ],'inactive' => [ 'en'=>'Inactive' ],'back_to_settings' => [ 'en'=>'Back to settings' ],'about' => [ 'en'=>'About' ],'preview' => [ 'en'=>'Preview' ],'admin_language_changed' => [ 'en'=>'Admin language changed' ],'admin_look' => [ 'en'=>'Admin look' ],'assets' => [ 'en'=>'Assets' ],'compress' => [ 'en'=>'Compress' ],'code' => [ 'en'=>'Code' ],'could_not_save' => [ 'en'=>'Could not save' ],'create_backup' => [ 'en'=>'Create backup' ],'create_new' => [ 'en'=>'Create new' ],'dark_mode' => [ 'en'=>'Dark' ],'delete' => [ 'en'=>'Delete' ],'clear' => [ 'en'=>'Clear' ],'recover' => [ 'en'=>'Recover' ],'description' => [ 'en'=>'Description' ],'dominant_color' => [ 'en'=>'Dominant color' ],'draft' => [ 'en'=>'Draft' ],'dummy_content' => [ 'en'=>'Dummy content' ],'filetype' => [ 'en'=>'Filetype' ],'files' => [ 'en'=>'Files' ],'found' => [ 'en'=>'Found' ],'create_langlink' => [ 'en'=>'Create language version' ],'hide_from_search_engines' => [ 'en'=>'Hide from search engines' ],'home_welcome_text' => [ 'en'=>'Hi, {username}. Use the left hand menu to navigate around.' ],'home' => [ 'en'=>'Home' ],'publish' => [ 'en'=>'Publish' ],'webhook_publish_triggered' => [ 'en'=>'Publish triggered - might take a minute as it is handled by external system.' ],'file_too_large' => [ 'en'=>'Your file is $A mb big. $B mb is the maximum allowed size for web usage. Please try to make your file smaller.' ],'uncheck_all' => [ 'en'=>'Clear selection' ],'check_all' => [ 'en'=>'Select all' ],'delete_selected' => [ 'en'=>'Delete selected' ],'add_tag' => [ 'en'=>'Add tag' ],'remove_tag' => [ 'en'=>'Remove tag' ],'schemas' => [ 'en'=>'Schemas' ],'e404_pretitle' => [ 'en'=>'Error 404' ],'e404_title' => [ 'en'=>'Not found' ],'e404_text' => [ 'en'=>'The content could not be found.' ],'item_updated' => [ 'en'=>'Item updated' ],'item_updated_but_not_published' => [ 'en'=>'Item updated, but still not published' ],'could_not_update_item' => [ 'en'=>'Could not update item' ],'item_deleted' => [ 'en'=>'Item deleted' ],'could_not_delete_item' => [ 'en'=>'Could not delete item' ],'file_uploaded' => [ 'en'=>'File uploaded' ],'could_not_upload_file' => [ 'en'=>'Could not upload file' ],'x_files_uploaded' => [ 'en'=>'{x} files uploaded' ],'x_files_uploaded_y_failed' => [ 'en'=>'{x} files uploaded, {y} failed' ],'copy_[item]' => [ 'en'=>'Copy [item]' ],'item_created' => [ 'en'=>'item created' ],'copied' => [ 'en'=>'Copied' ],'could_not_create_item' => [ 'en'=>'Could not create item' ],'duplicate' => [ 'en'=>'Duplicate' ],'edit' => [ 'en'=>'Edit' ],'move' => [ 'en'=>'move' ],'remove' => [ 'en'=>'Remove' ],'file_size' => [ 'en'=>'File size' ],'more' => [ 'en'=>'More' ],'clone_contentblock' => [ 'en'=>'Duplicate this block' ],'scroll_to_contentblock' => [ 'en'=>'Preview this block' ],'error' => [ 'en'=>'Error' ],'error_try_again' => [ 'en'=>'Error, please try again.' ],'unknown_error_try_again' => [ 'en'=>'Unknown error, please try again.' ],'primary' => [ 'en'=>'Primary' ],'language' => [ 'en'=>'Language' ],'languages' => [ 'en'=>'Language(s)' ],'language_settings' => [ 'en'=>'Language settings' ],'license' => [ 'en'=>'License' ],'link' => [ 'en'=>'Link' ],'light_mode' => [ 'en'=>'Light' ],'log_out' => [ 'en'=>'Log out' ],'no_items_found' => [ 'en'=>'No items found...' ],'password_protected' => [ 'en'=>'Password protected' ],'public' => [ 'en'=>'Public' ],'replace' => [ 'en'=>'Replace' ],'save' => [ 'en'=>'Save' ],'saved' => [ 'en'=>'Saved' ],'done' => [ 'en'=>'Done' ],'search' => [ 'en'=>'Search' ],'settings' => [ 'en'=>'Settings' ],'show_all_languages' => [ 'en'=>'Show all languages' ],'show_all_tags' => [ 'en'=>'Show all tags' ],'show_all' => [ 'en'=>'Show all' ],'sure' => [ 'en'=>'Sure?' ],'tags' => [ 'en'=>'Tags' ],'item_tags' => [ 'en'=>'Use tags to categorize items' ],'trash' => [ 'en'=>'Trash' ],'untagged' => [ 'en'=>'Untagged' ],'updated' => [ 'en'=>'Updated' ],'created' => [ 'en'=>'Created' ],'created_at' => [ 'en'=>'Created' ],'upload_file' => [ 'en'=>'Upload file' ],'upload' => [ 'en'=>'Upload' ],'new' => [ 'en'=>'New' ],'filename' => [ 'en'=>'Filename' ],'image' => [ 'en'=>'Image' ],'fields' => [ 'en'=>'Fields' ],'load_more' => [ 'en'=>'Load more...' ],'unsaved_changes' => [ 'en'=>'Close and lose your changes?' ],'clone_this_item' => [ 'en'=>'Clone this item' ],'toggle_draft_or_published' => [ 'en'=>'Toggle draft or published' ],'how_many_items_to_create' => [ 'en'=>'How many items would you like to create?' ],'press_save_to_replace_with' => [ 'en'=>'Press save to replace with' ],];}public function add_langstrings($langcode,$file){if(!is_file($file))return;$lines=json_decode(file_get_contents($file), true);foreach( $lines as $key => $str ) {if(empty($this->langstrings->{$key})) continue;$this->langstrings->{$key}[$langcode]=$str;}}public function output( $code, $data=NULL ){http_response_code($code);header('Content-type: application/json; charset=utf-8');header('Access-Control-Allow-Origin: '.$this->base_url);header('Access-Control-Allow-Methods: GET, POST');header('Access-Control-Allow-Headers: X-Requested-With');if(isset($data)) die(json_encode($data));die();}public function output_missing_param($p){ $this->output(400, [ 'status'=>'error', 'error'=>'missing-param', 'missing-param'=>$p ]); }public function loremify($words=5, $sentences=1){$x=[];while( $sentences > 0 ) {$a=['lorem', 'ipsum', 'dolor', 'sit', 'amet', 'consectetur', 'adipiscing', 'elit', 'praesent', 'interdum', 'dictum', 'mi', 'non', 'egestas', 'nulla', 'in', 'lacus', 'sed', ];shuffle($a);$b=array_slice($a, 0, $words);$c=ucfirst(join(' ', $b)).'.';$x[]=$c;$sentences--;}return join(' ', $x);}public function save_asset_file($file_or_url, $asset){if(empty($file_or_url))return (object)[ 'status'=>'error', 'error'=>'missing param file/url' ];$mode=is_string($file_or_url) ? 'url_download' : 'file_upload';if($mode=='file_upload')$file=$file_or_url;if($mode=='url_download') $url=$file_or_url;if($mode=='file_upload') {$size=$file->size;$tmp_name=$file->tmp_name;$type=$file->type;$name=$file->name;$tmp=explode('.', $name);$ext=end($tmp);$ext=strtolower($ext);}if($mode=='url_download') {$ch=curl_init($file_or_url);$tmp_name='tmp_asset_download_file_'.rand(1111,9999).'.jpg';$fp=fopen($tmp_name, 'wb');curl_setopt($ch, CURLOPT_FILE, $fp);curl_setopt($ch, CURLOPT_HEADER, 0);curl_exec($ch);curl_close($ch);fclose($fp);$size=filesize($tmp_name);$name=basename($url);$tmp=explode('.', $name);$ext=end($tmp);$ext=strtolower($ext);if(empty($ext)) $ext='jpg';}$name=str_ireplace( '.'.$ext, '', $name );$name=$this->slugify($name);if(!empty($asset->title)&&$name !== $asset->title) $name=$asset->title;if($ext=='jpeg') $ext='jpg';$is_img=in_array($ext, ['jpg','jpeg','png','webp' ]);$is_video=in_array($ext, ['mp4' ]);$is_resizable_img=in_array($ext, ['jpg','jpeg','png','webp' ]);$size_mb=$size/1048576;if(!empty($this->config->max_upload_mb)&&!$is_img&&!$is_video&&$size_mb > $this->config->max_upload_mb) return (object)[ 'status'=>'error', 'error'=>'file too large', 'max'=>$this->config->max_upload_mb ];if(!empty($this->config->max_upload_mb_img)&&$is_img&&$size_mb > $this->config->max_upload_mb_img) return (object)[ 'status'=>'error', 'error'=>'file too large', 'max'=>$this->config->max_upload_mb_img ];if(!empty($this->config->max_upload_mb_video)&&$is_video&&$size_mb > $this->config->max_upload_mb_video) return (object)[ 'status'=>'error', 'error'=>'file too large', 'max'=>$this->config->max_upload_mb_video ];if(empty($asset->uid)) $asset->uid=$this->makeUid();if(empty($asset->title)) $asset->title=$name;$asset->format=$ext;$asset->filesize=$size;$asset->updated_at=date('Y-m-d H:i:s');if(empty($asset->created_at)) $asset->created_at=date('Y-m-d H:i:s');$target_folder=$this->content_path."/asset/$asset->uid";$target_filepath=$this->content_path."/asset/$asset->uid/$name.$ext";if (!file_exists($target_folder)) mkdir($target_folder, $this->mkdir_chmod, true);$this->deleteFiles(glob($target_folder.'/*'));$moved=rename($tmp_name, $target_filepath);chmod($target_filepath, $this->mkdir_chmod);if(!$moved) return (object)[ 'status'=>'error', 'error'=>'could not move file' ];/*$resizables=$this->get_asset_img_sizes();if($is_resizable_img&&$resizables ) {foreach( $resizables as $w ) {$quality=7;$img=$this->image_create_from($ext, $target_filepath);$img=$this->image_resize($img, $w);$img=$this->image_sharpen($img, 1);if(!is_dir($this->content_path."/asset/$asset->uid/w$w")) mkdir($this->content_path."/asset/$asset->uid/w$w");$fn=str_replace( "$asset->uid/", "$asset->uid/w$w/", $target_filepath);$done=$this->image_output($img, $ext, $fn, $quality);}}*/if($is_img) {$f=$target_filepath;if(!empty($resizables)) {$f=str_replace("$asset->uid/", "$asset->uid/w$w/", $f);}$asset->dominant_color=$this->image_get_dominant_color($this->image_create_from($ext, $f));}return (object)[ 'status'=>'success', 'item'=>$asset ];}public function asset_create_resizables($uid){$asset=$this->get('asset', $uid);if(empty($asset)) return false;$ext=$asset->format;$is_resizable=in_array($ext, ['jpg','jpeg','png','webp' ]);$resizables=$this->get_asset_img_sizes();$src_file=$this->content_path."/asset/$asset->uid/$asset->title.$ext";if($is_resizable&&$resizables ) {foreach( $resizables as $w ) {$fn=str_replace( "$asset->uid/", "$asset->uid/w$w/", $src_file);$dn=$this->content_path."/asset/$asset->uid/w$w";if(is_file("$dn/$fn")) continue;$quality=7;$img=$this->image_create_from($ext, $src_file);$img=$this->image_resize($img, $w);$img=$this->image_sharpen($img, 1);if(!is_dir($dn)) mkdir($dn);$done=$this->image_output($img, $ext, $fn, $quality);}}}public function get_asset_img_sizes(){$r=[400];if(isset($this->config->asset_img_sizes)) $r=array_merge($r, $this->config->asset_img_sizes);if(isset($this->cms_config->asset_img_sizes)) $r=array_merge($r, $this->cms_config->asset_img_sizes);return array_values(array_unique($r));}public function get_input(){$method=$_SERVER['REQUEST_METHOD'];$input=(object) [];if($method=='GET') {$get=filter_input_array( INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS | FILTER_SANITIZE_ENCODED, FILTER_REQUIRE_ARRAY ) ?? [];if(!empty($get)) $input=(object) array_merge( (array) $input, (array) $get );}if($method=='POST') {$post_raw=file_get_contents('php://input');if(!empty($post_raw)) $post=json_decode($post_raw);if(!empty($post)) $input=(object) array_merge( (array) $input, (array) $post );$post=filter_input_array( INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS | FILTER_SANITIZE_ENCODED, FILTER_REQUIRE_ARRAY ) ?? [];if(!empty($post)) $input=(object) array_merge( (array) $input, (array) $post );}if(isset($input->multipart_data)) {$multipart_data=$input->multipart_data;$multipart_data=str_replace( '&quot;', '"', $multipart_data );$input=(object) array_merge( (array) $input, (array) json_decode($multipart_data));unset($input->multipart_data);}if(!empty($_FILES)) foreach($_FILES as $key => $val) $input->{$key}=(object) $val;return $input;}public function merge_obj($a, $b){$c=(object) array_merge_recursive((array)$a, (array)$b);return $c;}public function merge_obj_shallow($objA, $objB){foreach($objB as $k => $v) $objA->{$k}=$v;return $objA;}public function recursiveMerge($obj1, $obj2) {$merged=clone $obj1;foreach ($obj2 as $key => $value) {if (is_object($value)&&isset($merged->$key)&&is_object($merged->$key)) { $merged->$key=recursiveMerge($merged->$key, $value); } elseif (is_array($value)&&isset($merged->$key)&&is_array($merged->$key)) { $merged->$key=array_merge($merged->$key, $value); } else { $merged->$key=$value; }}return $merged;}public function glob_multiple($paths) {$files=[];foreach( $paths as $p ) $files=array_merge($files, glob($p));return $files;}public function glob_exclude($paths, $excludepaths) {if(is_string($paths)) $paths=glob($paths);return array_values(array_diff($paths, glob($excludepaths)));}public function path_minus_filename($path){ return pathinfo($path, PATHINFO_DIRNAME); }public function image_create_from( $format, $filepath ) {if($format=='jpg' ) $img=imagecreatefromjpeg($filepath);if($format=='png' ) $img=imagecreatefrompng($filepath);if($format=='webp' ) $img=imagecreatefromwebp($filepath);if($format=='png' || $format=='webp' ) {$w=imagesx($img); $h=imagesy($img);$img2=imagecreatetruecolor($w, $h);imagealphablending( $img2, false );imagesavealpha( $img2, true );imagecopyresampled($img2, $img, 0, 0, 0, 0, $w, $h, $w, $h);$background=imagecolorallocate($img2 , 0, 0, 0);imagecolortransparent($img2, $background);return $img2;}return $img;}public function image_output( $img, $format, $filepath=NULL, $quality=10 ){if($format=='png' ) { $quality=$this->clamp(($quality - 1), 0, 9); }if($format != 'png' ) { $quality=$this->clamp($quality, 1, 10) * 10; }if($format=='jpg' ) return imagejpeg($img, $filepath, $quality);if($format=='png' ) return imagepng($img, $filepath, $quality);if($format=='webp' ) return imagewebp($img, $filepath, $quality);}public function image_resize( $image, $new_width ) {$img_width 		= imagesx($image);$img_height 	= imagesy($image);$img_ratio 		= $img_width / $img_height;if($new_width >= $img_width ) return $image;$new_height=$new_width / $img_ratio;$new_image=imagecreatetruecolor($new_width, $new_height);imagealphablending( $new_image, false );imagesavealpha( $new_image, true );imagecopyresampled($new_image, $image, 0, 0, 0, 0, $new_width, $new_height, $img_width, $img_height);return $new_image;}public function image_sharpen( $image, $amount=1 ) {$sharpenMatrix=[ [-1.2, -1, -1.2], [-1, 20, -1], [-1.2, -1, -1.2] ];$divisor=array_sum(array_map('array_sum', $sharpenMatrix));$offset=0;while( $amount > 0 ) {imageconvolution($image, $sharpenMatrix, $divisor, $offset);$amount--;}return $image;}public function image_get_dominant_color($img){for( $x=0; $x < imagesx($img); $x++ ) {for( $y=0; $y < imagesy($img); $y++ ) {$r_total=0; $g_total=0; $b_total=0; $total=0;$rgb=imagecolorat($img,$x,$y);$r=($rgb >> 16) & 0xFF; $g=($rgb >> 8) & 0xFF; $b=$rgb & 0xFF;$r_total += $r; $g_total += $g; $b_total += $b; $total++;}}$r=round($r_total / $total); $g=round($g_total / $total); $b=round($b_total / $total);$hex=sprintf("#%02x%02x%02x", $r, $g, $b);return $hex;}public function str_before($str, $x, $or=NULL){$a=explode($x,$str);if(empty($a[0])&&isset($or)) return $or;return $a[0];}public function str_after($str, $x, $or=NULL){$a=explode($x,$str);if(empty($a[1])&&isset($or)) return $or;return $a[1];}public function multiple_files_combined_size($files){$total=0;foreach( $files as $f ) $total += filesize($f);return $total;}public function clamp($current, $min, $max) { return max($min, min($max, $current)); }public function isTrue($val) { return ( $val==='true' || $val==='TRUE' || $val===true || $val===1 || $val==='1' ); }public function randFromArray($arr){ if(empty($arr)) {return; } return $arr[ rand(0, count($arr)-1) ]; }public function strContains(string $haystack, string $needle) { return empty($needle) || strpos($haystack, $needle) !== false; }public function slugify( $str ) {$str=str_replace('-',' ',$str);$str=str_replace(array('æ','ø','å'), array('ae','oe','aa'),$str);$str=preg_replace("/[^ \w]+/", "", $str);$str=strtolower($str);$str=str_replace(' ','-',$str);return $str;}public function deleteFiles($files) {$deleted=0;foreach($files as $file) { if(is_file($file)) { $done=unlink($file); if($done) $deleted++; } }return $deleted;}public function cache_put($key, $data){if($this->json_pretty) $json=json_encode($data, JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT );if(!$this->json_pretty) $json=json_encode($data);$filepath=$this->content_path."/cache/$key.json";$folder=dirname($filepath);if (!file_exists($folder)) mkdir($folder, $this->mkdir_chmod, true);$done=file_put_contents($filepath, $json);return $done;}public function cache_get($key){$filepath=$this->content_path."/cache/$key.json";$data=$this->load_json($filepath);if(!isset($data)) return false;return $data;}public function cache_wipe($key){$file=$this->content_path."/cache/$key.json";return (file_exists($file)&&unlink($file));}public function html_cache_put($url, $html){$filepath=$this->content_path."/cache/html/$url.html";$folder=dirname($filepath);if (!file_exists($folder)) mkdir($folder, $this->mkdir_chmod, true);$html=str_replace('</head>','<meta name="htmlcached" value="yes"></head>',$html);$done=file_put_contents($filepath, $html);return $done;}public function html_cache_get($url){$filepath=$this->content_path."/cache/html/$url.html";if(!is_file($filepath)) return false;$html=file_get_contents($filepath);if(!isset($html)) return false;return $html;}public function html_cache_wipe($url){$filepath=$this->content_path."/cache/html/$url.html";return (file_exists($filepath)&&unlink($filepath));}public function html_cache_wipe_from_slug($slug){$files=glob($this->content_path."/cache/html/**/$slug.html");if(empty($files)) return false;foreach($files as $f) unlink($f);return true;}public function html_cache_wipe_all(){$filepath=$this->content_path."/cache/html";return $this->rrmdir($filepath);}public function get_base_url_sub_path(){$parsed=parse_url($this->base_url);if(empty($parsed['path'])) return '';$path=$parsed['path'];$path=ltrim($path,'/');$path=rtrim($path,'/');return $path;}public function get_route_path(){$p=trim( $_SERVER['REQUEST_URI'], '/' );$p=str_replace( $this->get_base_url_sub_path(), '', $p );$p=explode('?',$p)[0];$p=ltrim($p,'/');$p=rtrim($p,'/');return $p;}public function get_route_params(){ return explode('/',$this->get_route_path()); }public function get_route_param( $slot=1 ){$p=$this->get_route_params();if(isset($p[$slot-1])) return $p[$slot-1]; }public function is_route_path($path){ return $path==$this->get_route_path(); }public function is_route_param($slot,$param){ return $param==$this->get_route_param($slot); }public function get_active_route(){ if(empty($this->active_route)) return NULL;$r=$this->active_route;if($r=='/') return 'home';$r=str_replace( '(:any)', 'x', $r );$r=str_replace( '(:str)', 'x', $r );$r=str_replace( '(:num)', 'x', $r );$r=str_replace( '/', '-', $r );return $r;}public function get_active_route_or($str){ $r=$this->get_active_route(); return !empty($r) ? $r : $str; }public function get_active_controller(){ if(!empty($this->is_404)) return '404';if(empty($this->active_controller)) return NULL;$c=$this->active_controller;return $c;}public function get_active_controller_or($str){ $c=$this->get_active_controller(); return !empty($c) ? $c : $str; }public function is_active_route($x){ $r=$this->get_active_route(); return ( isset($r)&&$r===$x ); }public function is_active_controller($x){ $c=$this->get_active_controller(); return ( isset($c)&&$c===$x ); }public function is_route_match($r){ $request_method=strtolower($_SERVER['REQUEST_METHOD']);if(!$this->strContains($r,'::')) $r=$request_method.'::'.$r;$route_methods=explode('/', strtolower($this->str_before($r,'::','')));$r=$this->str_after($r,'::', '');if($r=='/' ) $r='';$r=ltrim($r,'/');if(!in_array($request_method, $route_methods)) return false;		$r=str_replace( ['(:num)','(:str)','(:any)','*'], ['[0-9]+','[a-z-_]+','[0-9a-z-_]+','.+'], $r );		$match=preg_match( '~^'.$r.'$~', $this->get_route_path());		return $match;}public function route( $pattern, $handler ){$match=$this->is_route_match($pattern);if(!$match)return;if(empty($this->routes)) $this->routes=[];if(empty($this->routes[$pattern])) $this->routes[$pattern]=$handler;$this->handle_route($pattern);}public function handle_route($pattern){$handler=$this->routes[$pattern];if(empty($handler))return;$this->active_route=$pattern;$this->route_params=$this->get_route_params();if(is_string($handler)&&isset($this->controllers)) { $handler2=str_replace('controller_','',$handler);if(isset($this->controllers[$handler])){ $this->active_controller=$handler;$this->controllers[$handler]($this); die();}if(isset($this->controllers[$handler2])) { $this->active_controller=$handler2;$this->controllers[$handler2]($this); die();}}if(is_array($handler)&&isset($this->controllers)) { if(isset($handler['controller'])) $cName=$handler['controller'];if(isset($handler[0])) $cName=$handler[0];if(isset($handler['params'])) $cParams=$handler['params'];if(isset($handler[1])) $cParams=$handler[1];if(empty($cParams)) $cParams=NULL;$cName=str_replace('controller::','',$cName);if(isset($this->controllers[$cName])){ $this->active_controller=$cName;$this->controllers[$cName]($this, $cParams); die();}}if(is_callable($handler)) { $handler($this); die(); }}public function handle_routes(){foreach( $this->routes as $k => $v ) {$this->route($k, $v);}$this->is_404=TRUE;if(isset($this->routes['404'])) $this->handle_route('404');}public function show_404_page(){$this->is_404=TRUE;if(empty($this->routes['404'])) die('Error: No 404 route defined.');if(isset($this->routes['404'])) $this->handle_route('404');}public function render_view($viewsubpath, $data=NULL){$filepath=$this->view_path . $viewsubpath . '.php';$filepath=str_replace( '.php.php', '.php', $filepath );if(!is_file($filepath)) $this->show_404_page();ob_start();$klay=$this;if(!empty($data)) extract($data);include $filepath;$html=ob_get_clean();$url=$_SERVER['REQUEST_URI'];if(empty($url)) $url='index';if($this->html_cache_enabled) $this->html_cache_put($url, $html);die($html);}public function render_cached_view($viewsubpath, $data=NULL){if(!$this->html_cache_enabled) return $this->render_view($viewsubpath, $data);$url=$_SERVER['REQUEST_URI'];if(empty($url)) $url='index';$cached_html=$this->html_cache_get($url);if(!empty($cached_html)) die($cached_html);$this->render_view($viewsubpath, $data);}public function aa2ao(&$aa){ foreach( $aa as &$x ) { if(!is_object($x)) $x=(object) $x; }	}public function admin_base_url(){ $base=$this->base_url;$base=rtrim($base, '/');if(empty($this->config->admin_url)) return $base;$url=$base.'/'.$this->config->admin_url;$url=rtrim($url, '/');return $url;}public function itemtype_admin_url( $typename ){return $this->admin_base_url().'#items-'.$typename;}public function item_admin_url( $typename, $uid ){if(empty($typename)) return false;if(empty($uid)) return $this->itemtype_admin_url($typename);return $this->admin_base_url().'#item-'.$typename.'-uid-'.$uid;}public function item_url( $typename, $item ){$base=$this->base_url;$base=rtrim($base, '/');$schema=$this->get_item_type($typename);if(empty($schema) || empty($schema->url_slug)) return false;$url=$schema->url_slug;$url=str_replace( '(:base)', $base, $url );$url=str_replace( '(:slug)', $item->slug, $url );return $url;}public function pdo_where_in_process_arr($key,$arr) {$arr2=[];$i=1;foreach ($arr as $x) {$arr2[]=[":$key"."ina$i", $x];$i++;}return $arr2;}public function pdo_where_in_process_arr_a($key,$arr) {$arr2=[];$i=1;foreach ($arr as $x) {$arr2[]=":$key"."ina$i";$i++;}return $arr2;}public function rrmdir($dir) { $ds=DIRECTORY_SEPARATOR;if (is_dir($dir)) { $objects=scandir($dir);foreach ($objects as $object) { if ($object != "."&&$object != "..") { if (is_dir($dir.$ds.$object)&&!is_link($dir.$ds.$object)) {$this->rrmdir($dir.$ds.$object);} else {unlink($dir.$ds.$object); }} }rmdir($dir);} }public function error_handler( $errno, $errstr, $errfile, $errline ){$m='';$errstr=htmlspecialchars($errstr);$m .= "<br />\nError $errno: $errstr in $errfile on line $errline<br />\n";$ignorable=($errno==E_WARNING||$errno==E_USER_WARNING||$errno==E_NOTICE||$errno==E_USER_NOTICE);switch ($errno) {case E_ERROR:case E_USER_ERROR:$m .="ERROR [$errno] $errstr<br />\nFatal error on line $errline in file $errfile, PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\nAborting...<br />\n";break;case E_WARNING:case E_USER_WARNING:$m .= "WARNING [$errno] $errstr<br />\n";return false;break;case E_NOTICE:case E_USER_NOTICE:$m .= "NOTICE [$errno] $errstr<br />\n";break;default:$m .= "Unknown error type: [$errno] $errstr<br />\n";break;}if($this->log_errors) error_log($m);if($ignorable&&!$this->display_errors) return true;if(!$this->display_errors) {$this->outputSystemError();}if(!(($errno&error_reporting())!==0)) return true;$this->dd($m);return true;}public function exception_handler($e) {$n="\n";$m= "⚠️ UNCAUGHT EXCEPTION$n";$m .= "------------------$n";$m .= 'File > '.$e->getFile().' (line '.$e->getLine().')'.$n;$m .= "------------------$n $n";$m .= $e->getMessage().$n.$n;$m .= "------------------$n";$m .= "Stack trace: ".$e->getTraceAsString().$n.$n.$n;if($this->log_errors) error_log($m);if(!$this->display_errors) $this->outputSystemError();$this->dd($m);}public function outputSystemError(){http_response_code(500);if(isset($this->config->error_display_html)) die($this->config->error_display_html);die('<!DOCTYPE html><html><head><title>Error</title><style>*{font-family:helvetica,sans-serif;margin:0;padding:0;box-sizing:border-box;}html{height:100%;}body{height:100%;text-align:center;padding:3em;background:#EEF;color:#99A;display:grid;place-items:center;}h1{margin-bottom:.5em;font-size:20px;font-weight:500;letter-spacing: .05em;}</style></head><body><h1>System error</h1></body></html>');}public function load_env_file( $filepath='.env' ){if(!is_file($filepath)) die('Error - cannot load env file');$lines=file($filepath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);foreach ($lines as $line) {if (strpos(trim($line), '#')===0) continue;list($name, $value)=explode('=', $line, 2);$name=trim($name);$value=trim($value);$value=trim($value,'"');if (!array_key_exists($name, $_SERVER)&&!array_key_exists($name, $_ENV)) {putenv(sprintf('%s=%s', $name, $value));$_ENV[$name]=$value;$_SERVER[$name]=$value;}}}public function config_load_env_vars($config){foreach(['DISPLAY_ERRORS', 'LOG_ERRORS','BASE_URL','CONTENT_URL','CONTENT_PATH','ADMIN_URL','MAX_UPLOAD_MB','MAX_UPLOAD_MB_IMG','MAX_UPLOAD_MB_VIDEO','MKDIR_CHMOD'] as $x) {$y=getenv($x);if($y===false) continue;if($x=='DISPLAY_ERRORS') $y=$this->isTrue($y);if($x=='LOG_ERRORS') $y=($y==='0'||$y===0||strtolower($y)==='false'||strtolower($y)==='off') ? FALSE : $y;if($x=='MAX_UPLOAD_MB') $y=intval($y);if($x=='MAX_UPLOAD_MB_IMG') $y=intval($y);if($x=='MAX_UPLOAD_MB_VIDEO') $y=intval($y);$config->{strtolower($x)}=$y;}return $config;}public function loadPlugins($config){if(empty($config->plugins)) return $config;foreach($config->plugins as $p){$pName=basename($p);if(!is_file($p.'/'.$pName.'.php')) { trigger_error('plugin-load-error: '.$p, E_USER_WARNING); continue; }$pConfig=require $p.'/'.$pName.'.php';$pConfig=(object) $pConfig;foreach(['item_schemas','blocks','routes','controllers','filters','events'] as $x) if(isset($pConfig->{$x})) $config->{$x}=array_merge( $pConfig->{$x}, $config->{$x}??[] );foreach(['js','css'] as $x) if(is_file($p.'/'.$pName.'.'.$x))$config->{'admin_'.$x}=file_get_contents($p.'/'.$pName.'.'.$x).$config->{'admin_'.$x};}return $config;}public function db($table=NULL){$this->db_init();$x=(new KlaySQLiteQueryBuilder($table));$x->load_dbe($this, $this->dbe);return $x;}}class KlaySQLiteQueryBuilder {protected $table;protected $select='*';protected $wheres=[];protected $params=[];protected $columns=[];protected $values=[];protected $limit=NULL;protected $offset=NULL;protected $order='created_at DESC';protected $groupBy=NULL;protected $dbe=NULL;protected $klay=NULL;protected $fetch_relations=FALSE;protected $raw_sql=NULL;protected $q=NULL;protected $action='select';protected $done=NULL;protected $rows_affected=NULL;protected $rawOutput=FALSE;public function __construct($table=null) {if($table !== null) $this->table=$table;return $this;}public function load_dbe($klay, $dbe){$this->klay=$klay;$this->dbe=$dbe;}public function select($columns='*') {$this->action='select';$this->select=is_array($columns) ? implode(', ', $columns) : $columns;return $this;}public function fixInsertable($x=NULL,$flags=[]){$x=(object) $x;if($this->table==='cms_config'&&$this->table==='cms_tokens') return $x;if(in_array('uid',$flags)) {if(empty($x->uid)) $x->uid=$this->klay->makeUid();}if(in_array('slug',$flags)) {if(empty($x->slug)) $x->slug=empty($x->title) ? $x->uid : $this->klay->slugify($x->title);}if(in_array('fields',$flags)) {if(isset($x->fields)&&(is_object($x->fields)||is_array($x->fields))) $x->fields=json_encode($x->fields);}if(in_array('created_at',$flags)) {if(empty($x->created_at)) $x->created_at=date('Y-m-d H:i:s');}if(in_array('updated_at',$flags)) {if(empty($x->updated_at)) $x->updated_at=date('Y-m-d H:i:s');}return $x;}public function where() {$a=func_get_args(); if(count($a)==2) { $col=$a[0]; $op='='; $val=$a[1]; } if(count($a)==3) { $col=$a[0]; $op=$a[1]; $val=$a[2]; }if((strpos($col,'fields->')!==false)) {if(!defined('SQLITE3_DETERMINISTIC')) { throw new Exception('SQLite JSON functions not supported'); return $this; }$col="json_extract(fields, '$.".str_replace('fields->','',$col)."')";}if(strtolower($op)=='in' || strtolower($op)=='not in') return $this->whereIn($col, $op, is_array($val)?$val:explode(',',$val));$this->wheres[]="$col $op ?";$this->params[]=$val;return $this;}public function whereIn($col, $op, array $vals) {$placeholders=implode(', ', array_fill(0, count($vals), '?'));$this->wheres[]="$col $op ($placeholders)";$this->params=array_merge($this->params, $vals);return $this;}public function whereJson($col, $op, $val) {if(!defined('SQLITE3_DETERMINISTIC')) { throw new Exception('SQLite JSON functions not supported'); return $this; }$col="json_extract(fields, '$.".str_replace('fields->','',$col)."')";$this->wheres[]="$col $op ?";$this->params[]=$val;return $this;}public function andWhere() {$a=func_get_args(); if(count($a)==2) { $col=$a[0]; $op='='; $val=$a[1]; } if(count($a)==3) { $col=$a[0]; $op=$a[1]; $val=$a[2]; }$this->wheres[]='AND';return $this->where($col, $op, $val);}public function orWhere() {$a=func_get_args(); if(count($a)==2) { $col=$a[0]; $op='='; $val=$a[1]; } if(count($a)==3) { $col=$a[0]; $op=$a[1]; $val=$a[2]; }$this->wheres[]='OR';return $this->where($col, $op, $val);}public function uid($x){ $this->where('uid',$x); return $this; }public function slug($x){ $this->where('slug',$x); return $this; }public function language($x){ $this->where('language',$x); return $this; }public function tagged($x){ $this->group()->where('tags','like', $x)->orWhere('tags','like', '%,'.$x)->orWhere('tags','like', '%,'.$x.',%')->orWhere('tags','like', $x.',%')->groupend(); return $this; }public function published(){ $this->where('published',1); return $this; }public function unpublished(){ $this->group()->where('published','is',null)->orWhere('published','!=',1)->groupend(); return $this; }public function or() { $this->wheres[]='OR'; return $this; }public function and() { $this->wheres[]='AND'; return $this; }public function group() { $this->wheres[]='('; return $this; }public function groupend() { $this->wheres[]=')'; return $this; }public function limit($x) { $this->limit=$x; return $this; }public function offset($x) { $this->offset=$x; return $this; }public function raw() { $this->rawOutput=true; return $this; }public function groupBy($x) { $this->groupBy=$x; return $this; }public function sql($x) { $this->raw_sql=$x; return $this; }public function params($x) { $this->params=array_merge($this->params, (array) $x); return $this; }public function getQmarkedValues() { $a=array_fill(0, count($this->values), '?'); return implode(', ',$a); }public function withRelated(){ $this->fetch_relations=true; return $this; }public function order($x) { if($x=='random') { $x='random()'; } $this->order=$x; return $this; }public function getOutput(){ return [ 'sql'=>$this->getSQL(), 'params'=>$this->getBindables(), 'rows_affected'=>$this->rows_affected]; }public function updateSyntax(){$x=[];foreach($this->columns as $c) $x[]="$c=?";return implode(', ',$x);}public function fixWhereStr($ar) {$s=implode(' AND ', $ar);foreach([1,2,3,4] as $x) {$s=str_replace('( AND ', '( ', $s );$s=str_replace(' AND )', ' )', $s );$s=str_replace(' AND OR AND ', ' OR ', $s );$s=str_replace(' AND AND AND ', ' AND ', $s );}return $s;}public function getSQL() {if($this->raw_sql) return $this->raw_sql;$a=$this->action;if($a=='select') $sql= "SELECT $this->select FROM `$this->table`";if($a=='insert')$sql="INSERT INTO `$this->table` (".implode(', ', $this->columns).") VALUES (".$this->getQmarkedValues().")";if($a=='update') $sql= "UPDATE `$this->table` SET ".$this->updateSyntax();if($a=='replace') $sql="REPLACE INTO `$this->table` (".implode(', ', $this->columns).") VALUES (".$this->getQmarkedValues().")";if($a=='upsert')$sql="REPLACE INTO `$this->table` (".implode(', ', $this->columns).") VALUES (".$this->getQmarkedValues().")";if($a=='delete') $sql= "DELETE FROM `$this->table`";if($a!=='replace'&&$a!=='upsert'&&!empty($this->wheres)) $sql .= ' WHERE ' . $this->fixWhereStr($this->wheres);if(isset($this->groupBy)) $sql .= ' GROUP BY '.$this->offset;if($a=='select'&&!empty($this->order)) $sql .= ' ORDER BY '.$this->order;if($a!=='update'&&$a!=='delete'&&!empty($this->limit)) $sql .= ' LIMIT '.$this->limit;if(!empty($this->offset)) $sql .= ' OFFSET '.$this->offset;return $sql;}public function getBindables() {if($this->action=='upsert'||$this->action=='replace') return $this->values;return array_merge($this->values, $this->params);}public function execute(){if(!$this->klay->db_tableFound($this->table)) $this->klay->db_createTable($this->table);$sql=$this->getSQL();$params=$this->getBindables();$this->q=$this->dbe->prepare($sql);if(!$this->q) return FALSE;$this->done=$this->q->execute($params);if(!$this->done) return FALSE;$this->rows_affected=$this->q->rowCount();$this->klay->sql_queries[]=$sql;return TRUE;}public function all(){$this->execute();$rows=$this->q->fetchAll(PDO::FETCH_OBJ);if(!$this->rawOutput) {foreach($rows as $x) if(isset($x->fields)) $x->fields=json_decode($x->fields);if($this->table=='asset') foreach($rows as $x) $x->files=$this->klay->asset_load_files($x->uid);if($this->table=='asset') foreach($rows as $x) $x->size=$this->klay->asset_load_size($x->uid);if($this->fetch_relations) $rows=$this->klay->fetch_relations($rows);}return $rows;}public function test($x=TRUE) { $this->klay->dd($this->getOutput()); }public function one(){$this->limit=1;$items=$this->all();return empty($items) ? NULL : $items[0];}public function count(){$this->select='COUNT(*)';$this->execute();$rowCount=$this->q->fetchColumn();return $rowCount;}public function insert($data) {$this->action='insert';$data=$this->fixInsertable($data,['uid','slug','fields','created_at','updated_at']);$this->columns=array_keys((array)$data);$this->values=array_values((array)$data);$this->execute();return ($this->done&&$this->rows_affected>0) ? $data : FALSE;;}public function update($data) {$this->action='update';$data=$this->fixInsertable($data,['fields','updated_at']);$this->columns=array_keys((array)$data);$this->values=array_values((array)$data);$this->execute();return ($this->done&&$this->rows_affected>0) ? $this->rows_affected : FALSE;}public function replace($data) {$this->action='replace';$data=$this->fixInsertable($data,['fields','updated_at']);$this->columns=array_keys((array)$data);$this->values=array_values((array)$data);$this->execute();return ($this->done&&$this->rows_affected>0) ? $this->rows_affected : FALSE;}public function upsert($data) {$data=(object)$data;if(isset($data->uid)) $existingRow=$this->klay->db($this->table)->where('uid',$data->uid)->raw()->one();if(isset($existingRow)) {if(!empty($existingRow->fields)) $existingRow->fields=(array) json_decode($existingRow->fields);$data=$this->klay->recursiveMerge((object)$existingRow, (object)$data);if(isset($data->fields)) $data->fields=(array) $data->fields;}$this->action='upsert';$data=$this->fixInsertable($data,['uid','slug','fields','created_at','updated_at']);$this->columns=array_keys((array)$data);$this->values=array_values((array)$data);$this->execute();return ($this->done&&$this->rows_affected>0) ? $this->rows_affected : FALSE;}public function delete() {$this->action='delete';$this->execute();return ($this->done&&$this->rows_affected>0) ? $this->rows_affected : FALSE;}}